#version 120
attribute vec3 in_position;
attribute vec3 in_normal;
attribute vec2 in_uv;

uniform mat4 projection;
uniform mat4 transform;
uniform mat4 normalTransform;
uniform vec3 directionalLight;

varying vec2 uv;
varying float light;

void main() {
	uv = in_uv;
	light = dot(normalize(normalTransform * vec4(in_normal, 0)), (vec4(normalize(directionalLight), 0)));
	gl_Position = projection * transform * vec4(in_position, 1);
}
