#version 120
varying vec2 uv;

uniform vec4 color;
uniform sampler2D textureSampler;
uniform sampler2D offsetTextureSampler;
uniform float strength;
uniform vec2 offset;

void main() {
	vec4 offset = texture2D(offsetTextureSampler, uv + offset);
	vec4 texColor = texture2D(textureSampler, uv + (offset.rg - 0.5) * strength * uv.y);
	vec4 multiplier = vec4((color.rgb - pow((1.0 - uv.y), 4.0) * 0.2) * color.a, color.a);
	gl_FragColor = texColor * multiplier;
}