#version 120
varying vec2 uv;
uniform sampler2D textureSampler;
uniform vec2 source0;
uniform vec2 source1;
uniform vec2 source2;
uniform float density;
uniform float samples;
uniform float decay;
uniform float strength0;
uniform float strength1;
uniform float strength2;
uniform float width;
uniform float height;

void main() {
	//vec2 pixelSize = vec2(1.0 / width, 1.0 / height);
	vec2 dist0 = uv - source0;
	vec2 dist1 = uv - source1;
	vec2 dist2 = uv - source2;
//	dist.y /= width / height;
	vec2 delta0 = dist0 / samples * density;
	vec2 delta1 = dist1 / samples * density;
	vec2 delta2 = dist2 / samples * density;
	vec4 color = vec4(0.0);
	for (int i = 0; i < int(samples); ++i) {
		vec2 sampleUv = source0 + float(i) * delta0;
		color.rgb += texture2D(textureSampler, sampleUv).rgb * strength0;
		sampleUv = source1 + float(i) * delta1;
		color.rgb += texture2D(textureSampler, sampleUv).rgb * strength1;
		sampleUv = source2 + float(i) * delta2;
		color.rgb += texture2D(textureSampler, sampleUv).rgb * strength2;
	}
	color = color / (samples * 3.0) / max(1.0, length((dist0 + dist1 + dist2) / 3.0 * decay));
	gl_FragColor = vec4(color.rgb, 0.0);
}