#version 120
varying float light;
varying vec2 uv;
uniform vec4 color;
uniform float ambientLight;
uniform float intensity;
uniform float threshold;
uniform vec2 shadowTextureOffset;
uniform vec2 dustTextureOffset;
uniform sampler2D shadowTexture;
uniform sampler2D dustTexture;

void main() {
	float directionalLightValue = max(0.0, intensity * light);
	float lightValue = clamp(ambientLight + directionalLightValue, 0.0, 1.0);
	vec3 shellColor = vec3(color.r * lightValue, color.g * lightValue, color.b * lightValue);
	vec4 shadowColor = texture2D(shadowTexture, uv + shadowTextureOffset);
	vec4 dustColor = texture2D(dustTexture, uv + dustTextureOffset);
	shellColor = floor(shellColor * threshold) / threshold;
	gl_FragColor = vec4(shellColor.rgb + dustColor.rgb * 0.2 - shadowColor.r * (54.0 / 255.0) * clamp(pow(0.8 - directionalLightValue, 3.0), 0.0, 1.0), 1.0);
}