#version 120
attribute vec3 in_position;
attribute vec3 in_normal;

uniform mat4 projection;
uniform mat4 transform;
uniform mat4 normalTransform;
uniform vec3 directionalLight;

varying float light;
varying vec3 normal;
varying vec4 pos;

void main() {
	vec4 normal4 = normalize(normalTransform * vec4(in_normal, 0));
	light = dot(normal4, (vec4(normalize(directionalLight), 0))); // is vec3 enough?
	normal = normal4.xyz;
	pos = projection * transform * vec4(in_position, 1);
	gl_Position = pos;
}