#version 120
varying vec2 uv;

uniform vec4 color;
uniform sampler2D textureSampler;
uniform vec2 offsetR;
uniform vec2 offsetG;
uniform vec2 offsetB;
uniform float strength;

void main() {
	vec4 texColor = texture2D(textureSampler, uv).rgba;
	texColor.r = texture2D(textureSampler, uv + offsetR * strength).r;
	texColor.g = texture2D(textureSampler, uv + offsetG * strength).g;
	texColor.b = texture2D(textureSampler, uv + offsetB * strength).b;
	vec4 multiplier = vec4(color.rgb * color.a, color.a);
	gl_FragColor = texColor * multiplier;
}