#version 120
attribute vec3 in_position;
attribute vec2 in_uv;

uniform mat4 projection;
uniform float power;
uniform float divider;
uniform vec2 offset;


varying vec2 uv;

void main() {
	uv = in_uv;
	vec4 pos = vec4(in_position.x, in_position.y, in_position.z, 1.0);
	pos += vec4(max(0.0, pow(-pos.z / divider, power)) * offset.x, max(0.0, pow(-pos.z / divider, power)) * offset.y, 0.0, 0.0);
	gl_Position = projection * pos;
}
