varying vec2 uv;

uniform sampler2D u;    // input velocity
uniform sampler2D x;    // qty to advect
uniform float timestep

void main()
{
   // follow the velocity field "back in time"
   vec2 pos = uv - timestep * texture(u, uv);
   // interpolate and write to the output fragment
   gl_FragColor = vec4(1, 1, 1, 1);//texture(x, pos);
}

/*
vec4 advect(vec2 uv, sampler2D textureSampler, float timestep)
{
  // follow the velocity field "back in time"
  float2 pos = coords - timestep * texture(textureSampler, uv).xy;
  return texture(pos);
}

void jacobi(vec2 coords, float alpha, float rBeta, float rdx)
{
  // left, right, bottom, and top x samples
  vec4 xL = texture(coords - vec2(1, 0)*rdx);
  vec4 xR = texture(coords + vec2(1, 0)*rdx);
  vec4 xB = texture(coords - vec2(0, 1)*rdx);
  vec4 xT = texture(coords + vec2(0, 1)*rdx);

  // b sample, from center
  vec4 bC = texture(coords).g;

  // evaluate Jacobi iteration
  return (xL + xR + xB + xT + alpha * bC) * rBeta;
}




void jacobi(half2 coords   : WPOS,   // grid coordinates
            
   out 
   half4 xNew : COLOR,  // result
            
   uniform 
   half alpha,
            uniform 
   half rBeta,      // reciprocal beta
            
   uniform samplerRECT x,   // x vector (Ax = b)
            
   uniform samplerRECT b)   // b vector (Ax = b)
{
  // left, right, bottom, and top x samples
  
  half4 xL = h4texRECT(x, coords - half2(1, 0));
  half4 xR = h4texRECT(x, coords + half2(1, 0));
  half4 xB = h4texRECT(x, coords - half2(0, 1));
  half4 xT = h4texRECT(x, coords + half2(0, 1));

  // b sample, from center
  
   half4 bC = h4texRECT(b, coords);

  // evaluate Jacobi iteration
  xNew = (xL + xR + xB + xT + alpha * bC) * rBeta;
}

*/