#version 330 core

in vec2 uv;
out vec4 color;

uniform vec4 u_color;
uniform sampler2D textureSampler;

void main() {
	vec4 texColor = texture(textureSampler, uv).rgba;
	vec4 multiplier = vec4(vec3(0, u_color.g, u_color.b) * u_color.a, u_color.a);
	color = texColor * multiplier;
}