physics = {}

physics.gravity = -1000
physics.maxSpeed = 1000

function physics.update(entity, dt)
	if type(entity) == "table" then
		if entity.vx ~= nil then 
			entity.x = (entity.x or 0) + get(entity.vx) * dt 
		end
		if entity.vy ~= nil then 
			entity.y = (entity.y or 0) + get(entity.vy) * dt 
		end
		if entity.vz ~= nil then 
			entity.z = (entity.z or 0) + get(entity.vz) * dt 
		end
		if entity.v ~= nil and entity.rotation ~= nil then
			if entity.x == nil then entity.x = 0 end
			if entity.y == nil then entity.y = 0 end
			entity.x = entity.x - entity.v * math.sin(entity.rotation / 180 * 3.141592653589793) * dt
			entity.y = entity.y + entity.v * math.cos(entity.rotation / 180 * 3.141592653589793) * dt
		end
		if entity.gravity ~= nil then
			if entity.gravity == true then entity.gravity = 1 end
			if entity.vy == nil then entity.vy = 0 end
			if entity.x == nil then entity.x = 0 end
			if entity.y == nil then entity.y = 0 end
			--print(entity.vy .. " " .. physics.gravity .. " " .. entity.gravity .. " " .. dt .. " " .. physics.maxSpeed)
			entity.vy = clamp(entity.vy + physics.gravity * entity.gravity * dt, -physics.maxSpeed, physics.maxSpeed)
		end
		for _,v in pairs(entity) do
			physics.update(v, dt)
		end
	end
end
