var SCALE = 2,
    _width = 1920 / SCALE,
    _height = 1080 / SCALE,
    _ctx = document.createElement("canvas").getContext("2d");
    
_ctx.canvas.width = _width;
_ctx.canvas.height = _height;

var vignette = document.getElementById('vignette');

//backbuffer
var _bctx = document.createElement('canvas').getContext('2d');
_bctx.canvas.width = _width;
_bctx.canvas.height = _height;

//ctx for hopalong, as scaling causes mayor problems
var _hctx = document.createElement('canvas').getContext('2d');
_hctx.canvas.width = 1920;//_width;
_hctx.canvas.height = 1080;//_height;


var compArray = ["clear", "copy", "destination", "source-over",
                   "destination-over", "source-in", "destination-in",
                   "source-out", "destination-out", "source-atop", 
                   "destination-atop", "xor", "lighter",

                   "normal", "multiply", "screen", "overlay",
                   "darken", "lighten", "color-dodge", "color-burn", "hard-light",
                   "soft-light", "difference", "exclusion", "hue", "saturation", 
                   "color", "luminosity"];


var _blot = [],
    _redLineCoords = [],
    _lineNoiseCoords = [],
    _hopa = 0,
    _lineRepeatY;

var _color = {
        blot:"#000",
        background: "#fff",
        redLine: '#f11',
        hopa:'#000'
    },
//----
    _color_normal = {
        blot:"#000",
        background: "#fff",
        redLine: '#f11',
        hopa:'#000'
    },
    _color_inverted = {
        blot:"#fff",
        background: "#000",
        redLine: '#f11',
        hopa:'#fff'
    };

function refreshColours(){
    _color = {
        blot:Random.color(),
        background: Random.color(),
        redLine:Random.color(),
        hopa:Random.color()
    }
}

function refreshCoords(blot, hopa, red, noise, line){
    
    if(blot === true){
        _blot = [];
        for(var i = 0; i < 50; i++){
            _blot.push({
                cp1x:   Random.range(_width/2.3, _width/1.3), cp1y: Random.range(_height/5, _height/1.3),
                cp2x:   Random.range(_width/2.3, _width/1.3), cp2y: Random.range(_height/5, _height/1.3),
                x:      Random.range(_width/2.3, _width/1.3), y:    Random.range(_height/5, _height/1.3)
            });
        }
    }
    
    if(hopa === true){
        _hopa = Random.range(0, 9001);
    }
    
    //redLine
    if(red === true){
        _redLineCoords= [];
        for(i = 0; i< 3; i++){
            var context = _bctx,
                w = Random.range(_width/(_width -2), _width/40),
                x = Random.range(w, (_width-w)/2);
        
            _redLineCoords.push({
                x: Random.range(0, _width),
                w: Random.range(_width/(_width -2), _width/40)
            });
        }
    }
    
    //lineNoise
    if(noise === true){
        
        _lineNoiseCoords = [];
        
        for( i = 0; i < 20; i++) {
            var h = Random.range(_height/100, _height/20),
                sY = Random.range(0, _height - h),
                dY = Random.range(0, _height - h),
                dX = Random.range(0, _width/10);
            
            _lineNoiseCoords.push({
                h: Random.range(_height/100, _height/20),
                sY: Random.range(0, _height - h),
                dY: Random.range(0, _height - h),
                dX: Random.range(0, _width/10)
            });
        }
    }
    
    if(line === true){
        _lineRepeatY = Random.range(0, _height);
    }
}

refreshCoords(true, true, true, true, true);


var _enableBlot = true,
    _enableHopa = true,
    _enableRedLine = false,
    _enableLineNoise = false,
    _enableLineRepeat = false,
    
    _inverted = false,
    _hopaMul = 1;
    
document.body.onkeyup = function(event){
    console.log("pressed", event.keyCode);
    switch(event.keyCode){
        case 81:
            _enableBlot = !_enableBlot;
            break;
        case 87:
            _enableHopa = !_enableHopa;
            break;
        case 69:
            _enableRedLine = !_enableRedLine;
            break;
        case 82:
            _enableLineNoise = !_enableLineNoise;
            break;
        case 84:
            _enableLineRepeat = !_enableLineRepeat;
            break;
            
        case 65:
            //refresh blot
            refreshCoords(true, false, false, false, false);
            break;
        case 83:
            //refresh hopa
            refreshCoords(false, true, false, false, false);
            break;
        case 68:
            //redLine w/refresh
            refreshCoords(false, false, true, false, false);
            break;
            
        case 70:
            //lineNoise w/refresh
            refreshCoords(false, false, false, true, false);
            break;
        case 71:
            //refreshSeep
            refreshCoords(false, false, false, false, true);
            break;
            
        case 32:
            _enableBlot = Random.float() > .5;
            _enableHopa = Random.float() > .5;
            _enableRedLine = Random.float() > .5;
            _enableLineNoise = Random.float() > .5;
            _enableLineRepeat = Random.float() > .5;
            
            refreshCoords(true, true, true, true, true);
            refreshColours();
            break;
            
        case 49:
            refreshColours();
            break;
            
        case 38:
            _k.setParts(_k.getParts()+1);
            break;
        
        case 40:
            _k.setParts(_k.getParts()-1);
            break;
            
        case 37:
            _k.setAngle(_k.getAngle()-5);
            break;
            
        case 39:
            _k.setAngle(_k.getAngle()+5);
            break;
    }
};

var _flippedY = false;


document.body.appendChild(_ctx.canvas);

var _hopalong = new Hopalong();
_hopalong.setContext(_hctx);//, _width, _height);

var _k = new Kaleidoscope();
_k.setContext(_bctx);

var _b = new SuperFastBlur();
_b.setContext(_bctx);

_k.setContext(_bctx);

var _startX = _width/2,
    _startY = _height/2;

var _startTime;
requestAnimationFrame(render);

function render(t){
    
    if(isNaN(_startTime))
        _startTime = t;
    
    _bctx.fillStyle = _color.background;
    _bctx.fillRect(0, 0, _width, _height);
    
    _bctx.fillStyle = _color.blot;
    if(_enableBlot)
        drawBlot(t);

    if(_enableRedLine)
        addRedLine();

    _bctx.fillStyle = _color.hopa;
    if(_enableHopa){
        _hctx.clearRect(0, 0, 1920, 1080);
        _hopalong.render(_hopa + _hopaMul);//(t * _hopaMul));// (Math.sin(t * _hopaMul)) );
        _bctx.drawImage(_hctx.canvas, 0, 0, _width, _height);
    }
        

    _k.render();

    //fill buffer
    _ctx.clearRect(0, 0, _width, _height);
    scale(1+ Math.abs((Math.sin(t/1000)/3)));

    if(_enableLineNoise)
        lineNoise();
    
    if(_enableLineRepeat)
        pullLine();
    
    blur();
    //invert();
    if(_flippedY){
        _ctx.save();
        _ctx.translate(0, _height);
        _ctx.scale(1, -1);
        _ctx.drawImage(_ctx.canvas, 0, 0);
        _ctx.restore();
    }
        
    requestAnimationFrame(render);
}

function blur(){
    //blur
    _bctx.drawImage(_ctx.canvas, 0, 0, _bctx.canvas.width, _bctx.canvas.height);
    //boxBlurImage( _bctx, 4, false, 1);
    _b.render(16);
    
    //stamp out mask with destination-out
    _ctx.save();
    _ctx.globalCompositeOperation = "destination-out";
    for(var i = 0; i < 9; i++){
        //could just use a vignette pic with more violent alpha
        _ctx.drawImage(vignette, 0, 0, _width, _height);
    }    
    _ctx.restore();
    
    //add second pic with destination-atop
    _ctx.save();
    _ctx.globalCompositeOperation = "destination-atop";
    _ctx.drawImage(_bctx.canvas, 0, 0, _width, _height);
    _ctx.restore();
    
    //and vignette the scene
    _ctx.drawImage(vignette, 0, 0, _width, _height);
}

function drawBlot(t){
    _bctx.beginPath();
    _bctx.moveTo(_startX, _startY);
    
    for(var i = 0, len = _blot.length; i < len; i++){
        
        var offsetSin = Math.sin((t / 1000) + (i * 100)) * _width / 20,
            offsetCos = Math.cos((t / 1000) + (i * 100)) * _height / 20;
        
        var offsetX = (i % 2) ? offsetSin : offsetCos,
            offsetY = (i % 2) ? offsetCos : offsetSin;
        _bctx.bezierCurveTo(
                _blot[i].cp1x   + offsetX, _blot[i].cp1y + offsetY,
                _blot[i].cp2x   + offsetX, _blot[i].cp2y + offsetY,
                _blot[i].x      + offsetX, _blot[i].y    + offsetY
        );
    }
    _bctx.closePath();
    _bctx.fill();
}

function scale(amount){
    
    var w = _width * amount,
        h = _height * amount,
        x = (_width - w) / 2,
        y = (_height - h) / 2;

    _ctx.drawImage(_bctx.canvas, x, y, w, h);
}

function invert(amount){
    
    if(amount === 0)
        return scale(1);
        
    if(idx >= compArray.length)
        idx = 0;
    if(idx < 0)
        idx = compArray.length - 1;

    var color = Math.round(255 * amount);
    
    _ctx.save();
    
    scale(1);

    _ctx.globalCompositeOperation = "exclusion";//compArray[idx];
    _ctx.fillStyle = "rgba("+ color +","+ color +","+ color +",1)";
    _ctx.fillRect(0, 0, _width, _height);
    _ctx.restore();
}

function pullLine(){
    
    var y = _lineRepeatY,
        h = _height - y;

    _ctx.drawImage(_ctx.canvas, 
        0, y, _width, 1,
        0, y, _width, h);
    
}

function lineNoise(amount){

    for(var i = 0, len = _lineNoiseCoords.length; i < len; i++) {

        _ctx.drawImage(_bctx.canvas,
            0, _lineNoiseCoords[i].sY, _width, _lineNoiseCoords[i].h,
            _lineNoiseCoords[i].dX, _lineNoiseCoords[i].dY, _width, _lineNoiseCoords[i].h);
    }
}

function addRedLine(){
    
    for(var i = 0, len = _redLineCoords.length; i < len; i++){
        _bctx.save();
        _bctx.fillStyle = _color.redLine;
        _bctx.fillRect(_redLineCoords[i].x, 0, _redLineCoords[i].w, _height);
        _bctx.restore();
    }
}