#version 330

uniform float uTime;
uniform float uMax;
//uniform vec2 uRes;
uniform vec3 uMouse;

uniform float uVol;
uniform sampler2D uTex0;
//uniform vec2 uTex0Res;

#define HSAMPLES 100    // try 512
#define MSAMPLES  12    // try  12

vec2 uRes = vec2(1240.0, 720.0);
vec2 uTex0Res = vec2(512.0, 512.0);

//
float noise(float t)
{
	return texture2D(uTex0,vec2(t,.0)/uTex0Res.xy).x;
}
float noise(vec2 t)
{
	return texture2D(uTex0,t/uTex0Res.xy).x;
}

vec3 lensflare(vec2 uv,vec2 pos)
{
	vec2 main = uv-pos;
	vec2 uvd = uv*(length(uv));
	
	float ang = atan(main.x,main.y);
	float dist=length(main); dist = pow(dist,.1);
	float n = noise(vec2(ang*16.0,dist*32.0));
	
	float f0 = 1.0/(length(uv-pos)*16.0+1.0);
	
	f0 = f0+f0*(sin(noise((pos.x+pos.y)*2.2+ang*4.0+5.954)*16.0)*.1+dist*.1+.8);
	
	float f1 = max(0.01-pow(length(uv+1.2*pos),1.9),.0)*7.0;

	float f2 = max(1.0/(1.0+32.0*pow(length(uvd+0.8*pos),2.0)),.0)*00.25;
	float f22 = max(1.0/(1.0+32.0*pow(length(uvd+0.85*pos),2.0)),.0)*00.23;
	float f23 = max(1.0/(1.0+32.0*pow(length(uvd+0.9*pos),2.0)),.0)*00.21;
	
	vec2 uvx = mix(uv,uvd,-0.5);
	
	float f4 = max(0.01-pow(length(uvx+0.4*pos),2.4),.0)*6.0;
	float f42 = max(0.01-pow(length(uvx+0.45*pos),2.4),.0)*5.0;
	float f43 = max(0.01-pow(length(uvx+0.5*pos),2.4),.0)*3.0;
	
	uvx = mix(uv,uvd,-.4);
	
	float f5 = max(0.01-pow(length(uvx+0.2*pos),5.5),.0)*2.0;
	float f52 = max(0.01-pow(length(uvx+0.4*pos),5.5),.0)*2.0;
	float f53 = max(0.01-pow(length(uvx+0.6*pos),5.5),.0)*2.0;
	
	uvx = mix(uv,uvd,-0.5);
	
	float f6 = max(0.01-pow(length(uvx-0.3*pos),1.6),.0)*6.0;
	float f62 = max(0.01-pow(length(uvx-0.325*pos),1.6),.0)*3.0;
	float f63 = max(0.01-pow(length(uvx-0.35*pos),1.6),.0)*5.0;
	
	vec3 c = vec3(.0);
	
	c.r = c.r + f2+f4+f5+f6; 
	c.g = c.g + f22+f42+f52+f62; 
	c.b = c.b + f23+f43+f53+f63;
	c = c*1.3 - vec3(length(uvd)*.05);
	c=c+vec3(f0);
	
	return c;
}

vec3 cc(vec3 color, float factor,float factor2) // color modifier
{
	float w = color.x+color.y+color.z;
	return mix(color,vec3(w)*factor,w*factor2);
}

vec4 lensMain( void )
{
	vec2 uv = gl_FragCoord.xy / uRes.xy - 0.5;
	uv.x = uv.x * uRes.x/uRes.y; //fix aspect ratio
	vec3 mouse = vec3(uMouse.xy/uRes.xy - 0.5,uMouse.z-.5);
	mouse.x = mouse.x * uRes.x/uRes.y; //fix aspect ratio
	if (uMouse.z<.5)
	{
		mouse.x=sin(uTime)*.5;
		mouse.y=sin(uTime*.913)*.5;
	}
	
	vec3 color = vec3(1.0 ,1.0, 1.0)*lensflare(uv,mouse.xy);
	color = color - noise(gl_FragCoord.xy)*.015;
	color = cc(color,.5,.1);

	vec4 lensColor = vec4(color,1.0);
    
//    vec2 p = (-uRes.xy + 2.0*gl_FragCoord.xy) / uRes.y;    
//    vec3 col = texture2D( uTex1, 0.5 + 0.5*uv ).xyz;
    
    
    return(lensColor);  
       
}

//

out vec4 fragColor;

void main ( void )
{
    vec2  p = (-uRes.xy+2.0*gl_FragCoord.xy)/uRes.y;
    float t =  12.25 + uTime;
	
    float an = 0.2*sin( -0.5*t );
    float co = cos( an ), si = sin( an );
    p = mat2(co,-si,si,co) * p;
    
    float ra = texture2D( uTex0, gl_FragCoord.xy/uTex0Res.xy ).x;
    
    vec3 tot = vec3(0.0);
    for( int j=0; j<MSAMPLES; j++ )
    {
        float time = t + 0.5*(1.0/24.0)*(float(j)+ra)/float(MSAMPLES);
        vec2  offset = time*vec2(0.03,0.1);
	
        vec3 uv;
        for( int i=0; i<HSAMPLES; i++ )
        {
            uv.z = (float(i)+ra)/float(HSAMPLES-1);
            uv.xy = offset + vec2(p.x,1.0)/abs(p.y) * (0.001+0.0125*uv.z) * 0.5 + sign(p.y)*0.1;
            if( texture2D( uTex0, uv.xy ).x < uv.z )
                break;
        }
    
        vec2  uv2 = offset + vec2(p.x-0.04,1.0)/abs(p.y) * (0.001+0.0125*uv.z) * 0.5 + sign(p.y)*0.1;
        float dif = clamp( texture2D(uTex0, uv.xy).x - texture2D(uTex0, uv2.xy).x, 0.0, 1.0 );
        vec3  col = vec3(2.0);
        col = col * (0.2+0.9*texture2D( uTex0, 24.0*uv.xy, 0.0 ).xyz);
        col = col * (0.5+0.5*texture2D( uTex0, 128.0*uv.xy, 0.0 ).xyz);
        col = col * (1.0-1.0*uv.z);
        col = col * (vec3(0.4,0.56,0.7)*0.7 + vec3(16.0,9.0,3.0)*dif);
        col = col * (clamp(3.0*abs(p.y)  - 0.6*uv.z + 0.1,0.0,2.0));
        tot = tot + col;
    }

    tot = (tot / float(MSAMPLES));
 
    fragColor = vec4( tot*smoothstep(0.0,2.0,uTime), 1.0 );
  //  fragColor += lensMain();	

    fragColor *= uVol;

}