

uniform float uTime;
uniform sampler2D uTex0;

vec2 uRes = vec2(1920.0, 1080.0);

out vec4 fragColor;

void main( void )
{
    vec2 p = (-uRes.xy + 2.0*fragCoord.xy) / uRes.y;

    vec2 cst = vec2((cos(uTime)), sin(0.0) );
    mat2 rot = (1.0 + 1.5*cst.x)*mat2(cst.x,-cst.y,cst.y,cst.x);

    vec3 col = texture2D( uTex0, 0.5 + 0.5*rot*p ).xyz;
    fragColor = vec4( col, 1.0 );
}