uniform sampler2D iChannel0;
uniform sampler2D tex0;
uniform sampler2D tex1;
uniform vec2 iResolution;
uniform float iGlobalTime;
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float rand(float co){
    return rand(vec2(co));
}
float hash(float c){return fract(sin(dot(c,12.9898))*43758.5453);}

vec2 curve(vec2 uv)
{
	uv = (uv - 0.5) * 2.0;
	uv *= 1.1;	
	uv.x *= 1.0 + pow((abs(uv.y) / 5.0), 2.0);
	uv.y *= 1.0 + pow((abs(uv.x) / 4.0), 2.0);
	uv  = (uv / 2.0) + 0.5;
	uv =  uv *0.92 + 0.04;
	return uv;
}
vec3 boxblur(sampler2D t, vec2 pos, float blur){
    //if(blur < 0.3) return vec3(0.9);
    vec3 c = vec3(0);
   
    float it = 0.0;
    for(float i = 0.0; i < 180.0; i++){
        vec2 rval;
        rval.x = blur * rand(vec2(0.002345*iGlobalTime+pos.x, float(i)+pos.y)) - blur / 2.0;
        rval.y = blur * rand(vec2(pos.x + float(i), pos.y+0.007615*iGlobalTime)) - blur / 2.0;
        c += texture2D(t, pos + 0.25*rval*vec2(1.0/iResolution.x, 1.0/iResolution.y)).rgb;
        it += 1.0;
    }
    return c/it;
}

void main( ) {  
     vec2 p = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    
    	float T=iGlobalTime*0.2;
	vec2 j = vec2(3.,0.)/ iResolution.xy;
	vec2 k = vec2(0.,3.)/ iResolution.xy;
    vec4 C = vec4( 0., 0., 0., 1.);
    if(uv.x<0. || uv.x>1.) {
    	C = vec4(.0,.0,.0,1.0);
    } else {
        float dist = 
            texture2D( iChannel0, uv).w +
            texture2D( iChannel0, uv+j).w +
            texture2D( iChannel0, uv+k).w +
            texture2D( iChannel0, uv-j).w +
            texture2D( iChannel0, uv-k).w;
        C.rgb = boxblur( iChannel0,  uv, 3./(1.+dist)+dist*dist*16000.);
    }
        //C.rgb = tone(C.rgb,2.1);
    	//C.rgb-=vec3(.1);
    	C.rgb *= 1.1-pow(length(p.x),8.)/2.+rand(p*iGlobalTime)/40.;
    	C.rgb *= 1.1-pow(length(p.y),8.)/2.+rand(p*iGlobalTime)/40.;
        //C.rgb=max(C.rgb,vec3(.08,.105,.09));
    	C.w=1.;
    	gl_FragColor = C;
}