/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Launcher {
    public Launcher() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        final JFrame frame = new JFrame();
        frame.setTitle("Fibber 28");
        frame.setSize(250, 120);
        frame.setResizable(true);
        frame.setLocationRelativeTo(null);
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        frame.add(panel);
        final Checkbox full = new Checkbox("Fullscreen", null, true);
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        final JTextField width = new JTextField();
        width.setText("" + gd.getDisplayMode().getWidth());
        final JTextField height = new JTextField();
        height.setText("" + gd.getDisplayMode().getHeight());
        JButton launch = new JButton("Start");
        launch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Integer.parseInt(width.getText());
                }
                catch (Exception e) {
                    width.setBackground(Color.RED);
                    return;
                }
                try {
                    Integer.parseInt(height.getText());
                }
                catch (Exception e) {
                    height.setBackground(Color.RED);
                    return;
                }
                frame.dispose();
                Settings s = new Settings();
                s.fullscreen = full.getState();
                s.resolution = new Dimension(Integer.parseInt(width.getText()), Integer.parseInt(height.getText()));
                new Raytracer(s).run();
            }
        });
        panel.add(full);
        panel.add(new JLabel("Resolution:"));
        panel.add(width);
        panel.add(new JLabel("x"));
        panel.add(height);
        panel.add(launch);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        new Launcher();
    }
}

