/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.openal.AL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class SOFTBufferSubData {
    public static final int AL_BYTE_RW_OFFSETS_SOFT = 4145;
    public static final int AL_SAMPLE_RW_OFFSETS_SOFT = 4146;
    public final long BufferSubDataSOFT;

    public SOFTBufferSubData(FunctionProvider provider) {
        this.BufferSubDataSOFT = provider.getFunctionAddress("alBufferSubDataSOFT");
    }

    public static SOFTBufferSubData getInstance() {
        return AL.getCapabilities().__SOFTBufferSubData;
    }

    static SOFTBufferSubData create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("AL_SOFT_buffer_sub_data")) {
            return null;
        }
        SOFTBufferSubData funcs = new SOFTBufferSubData(provider);
        boolean supported = Checks.checkFunctions(funcs.BufferSubDataSOFT);
        return AL.checkExtension("AL_SOFT_buffer_sub_data", funcs, supported);
    }

    public static native void nalBufferSubDataSOFT(int var0, int var1, long var2, int var4, int var5, long var6);

    public static void nalBufferSubDataSOFT(int buffer, int format, long data, int offset, int length) {
        long __functionAddress = SOFTBufferSubData.getInstance().BufferSubDataSOFT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        SOFTBufferSubData.nalBufferSubDataSOFT(buffer, format, data, offset, length, __functionAddress);
    }

    public static void alBufferSubDataSOFT(int buffer, int format, ByteBuffer data, int offset, int length) {
        SOFTBufferSubData.nalBufferSubDataSOFT(buffer, format, MemoryUtil.memAddress(data), offset, length);
    }
}

