/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GL21 {
    public static final int GL_CURRENT_RASTER_SECONDARY_COLOR = 33887;
    public static final int GL_FLOAT_MAT2x3 = 35685;
    public static final int GL_FLOAT_MAT2x4 = 35686;
    public static final int GL_FLOAT_MAT3x2 = 35687;
    public static final int GL_FLOAT_MAT3x4 = 35688;
    public static final int GL_FLOAT_MAT4x2 = 35689;
    public static final int GL_FLOAT_MAT4x3 = 35690;
    public static final int GL_PIXEL_PACK_BUFFER = 35051;
    public static final int GL_PIXEL_UNPACK_BUFFER = 35052;
    public static final int GL_PIXEL_PACK_BUFFER_BINDING = 35053;
    public static final int GL_PIXEL_UNPACK_BUFFER_BINDING = 35055;
    public static final int GL_SRGB = 35904;
    public static final int GL_SRGB8 = 35905;
    public static final int GL_SRGB_ALPHA = 35906;
    public static final int GL_SRGB8_ALPHA8 = 35907;
    public static final int GL_SLUMINANCE_ALPHA = 35908;
    public static final int GL_SLUMINANCE8_ALPHA8 = 35909;
    public static final int GL_SLUMINANCE = 35910;
    public static final int GL_SLUMINANCE8 = 35911;
    public static final int GL_COMPRESSED_SRGB = 35912;
    public static final int GL_COMPRESSED_SRGB_ALPHA = 35913;
    public static final int GL_COMPRESSED_SLUMINANCE = 35914;
    public static final int GL_COMPRESSED_SLUMINANCE_ALPHA = 35915;
    public final long UniformMatrix2x3fv;
    public final long UniformMatrix3x2fv;
    public final long UniformMatrix2x4fv;
    public final long UniformMatrix4x2fv;
    public final long UniformMatrix3x4fv;
    public final long UniformMatrix4x3fv;

    public GL21(FunctionProvider provider) {
        this.UniformMatrix2x3fv = provider.getFunctionAddress("glUniformMatrix2x3fv");
        this.UniformMatrix3x2fv = provider.getFunctionAddress("glUniformMatrix3x2fv");
        this.UniformMatrix2x4fv = provider.getFunctionAddress("glUniformMatrix2x4fv");
        this.UniformMatrix4x2fv = provider.getFunctionAddress("glUniformMatrix4x2fv");
        this.UniformMatrix3x4fv = provider.getFunctionAddress("glUniformMatrix3x4fv");
        this.UniformMatrix4x3fv = provider.getFunctionAddress("glUniformMatrix4x3fv");
    }

    public static GL21 getInstance() {
        return GL.getCapabilities().__GL21;
    }

    static GL21 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL21")) {
            return null;
        }
        GL21 funcs = new GL21(provider);
        boolean supported = Checks.checkFunctions(funcs.UniformMatrix2x3fv, funcs.UniformMatrix3x2fv, funcs.UniformMatrix2x4fv, funcs.UniformMatrix4x2fv, funcs.UniformMatrix3x4fv, funcs.UniformMatrix4x3fv);
        return GL.checkExtension("OpenGL21", funcs, supported);
    }

    public static native void nglUniformMatrix2x3fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix2x3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL21.getInstance().UniformMatrix2x3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL21.nglUniformMatrix2x3fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix2x3fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GL21.nglUniformMatrix2x3fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2x3fv(int location, boolean transpose, FloatBuffer value) {
        GL21.nglUniformMatrix2x3fv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3x2fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix3x2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL21.getInstance().UniformMatrix3x2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL21.nglUniformMatrix3x2fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix3x2fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GL21.nglUniformMatrix3x2fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3x2fv(int location, boolean transpose, FloatBuffer value) {
        GL21.nglUniformMatrix3x2fv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix2x4fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix2x4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL21.getInstance().UniformMatrix2x4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL21.nglUniformMatrix2x4fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix2x4fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GL21.nglUniformMatrix2x4fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2x4fv(int location, boolean transpose, FloatBuffer value) {
        GL21.nglUniformMatrix2x4fv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4x2fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix4x2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL21.getInstance().UniformMatrix4x2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL21.nglUniformMatrix4x2fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix4x2fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GL21.nglUniformMatrix4x2fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4x2fv(int location, boolean transpose, FloatBuffer value) {
        GL21.nglUniformMatrix4x2fv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3x4fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix3x4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL21.getInstance().UniformMatrix3x4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL21.nglUniformMatrix3x4fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix3x4fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GL21.nglUniformMatrix3x4fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3x4fv(int location, boolean transpose, FloatBuffer value) {
        GL21.nglUniformMatrix3x4fv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4x3fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix4x3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL21.getInstance().UniformMatrix4x3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL21.nglUniformMatrix4x3fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix4x3fv(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GL21.nglUniformMatrix4x3fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4x3fv(int location, boolean transpose, FloatBuffer value) {
        GL21.nglUniformMatrix4x3fv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }
}

