/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GLXAMDGPUAssociation {
    public static final int GLX_GPU_VENDOR_AMD = 7936;
    public static final int GLX_GPU_RENDERER_STRING_AMD = 7937;
    public static final int GLX_GPU_OPENGL_VERSION_STRING_AMD = 7938;
    public static final int GLX_GPU_FASTEST_TARGET_GPUS_AMD = 8610;
    public static final int GLX_GPU_RAM_AMD = 8611;
    public static final int GLX_GPU_CLOCK_AMD = 8612;
    public static final int GLX_GPU_NUM_PIPES_AMD = 8613;
    public static final int GLX_GPU_NUM_SIMD_AMD = 8614;
    public static final int GLX_GPU_NUM_RB_AMD = 8615;
    public static final int GLX_GPU_NUM_SPI_AMD = 8616;
    public final long BlitContextFramebufferAMD;
    public final long CreateAssociatedContextAMD;
    public final long CreateAssociatedContextAttribsAMD;
    public final long DeleteAssociatedContextAMD;
    public final long GetContextGPUIDAMD;
    public final long GetCurrentAssociatedContextAMD;
    public final long GetGPUIDsAMD;
    public final long GetGPUInfoAMD;
    public final long MakeAssociatedContextCurrentAMD;

    public GLXAMDGPUAssociation(FunctionProvider provider) {
        this.BlitContextFramebufferAMD = provider.getFunctionAddress("glXBlitContextFramebufferAMD");
        this.CreateAssociatedContextAMD = provider.getFunctionAddress("glXCreateAssociatedContextAMD");
        this.CreateAssociatedContextAttribsAMD = provider.getFunctionAddress("glXCreateAssociatedContextAttribsAMD");
        this.DeleteAssociatedContextAMD = provider.getFunctionAddress("glXDeleteAssociatedContextAMD");
        this.GetContextGPUIDAMD = provider.getFunctionAddress("glXGetContextGPUIDAMD");
        this.GetCurrentAssociatedContextAMD = provider.getFunctionAddress("glXGetCurrentAssociatedContextAMD");
        this.GetGPUIDsAMD = provider.getFunctionAddress("glXGetGPUIDsAMD");
        this.GetGPUInfoAMD = provider.getFunctionAddress("glXGetGPUInfoAMD");
        this.MakeAssociatedContextCurrentAMD = provider.getFunctionAddress("glXMakeAssociatedContextCurrentAMD");
    }

    public static GLXAMDGPUAssociation getInstance() {
        return GL.getCapabilities().__GLXAMDGPUAssociation;
    }

    static GLXAMDGPUAssociation create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_AMD_gpu_association")) {
            return null;
        }
        GLXAMDGPUAssociation funcs = new GLXAMDGPUAssociation(provider);
        boolean supported = Checks.checkFunctions(funcs.BlitContextFramebufferAMD, funcs.CreateAssociatedContextAMD, funcs.CreateAssociatedContextAttribsAMD, funcs.DeleteAssociatedContextAMD, funcs.GetContextGPUIDAMD, funcs.GetCurrentAssociatedContextAMD, funcs.GetGPUIDsAMD, funcs.GetGPUInfoAMD, funcs.MakeAssociatedContextCurrentAMD);
        return GL.checkExtension("GLX_AMD_gpu_association", funcs, supported);
    }

    public static native void nglXBlitContextFramebufferAMD(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, long var12);

    public static void glXBlitContextFramebufferAMD(long dstCtx, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().BlitContextFramebufferAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(dstCtx);
        }
        GLXAMDGPUAssociation.nglXBlitContextFramebufferAMD(dstCtx, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter, __functionAddress);
    }

    public static native long nglXCreateAssociatedContextAMD(int var0, long var1, long var3);

    public static long glXCreateAssociatedContextAMD(int id, long share_list) {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().CreateAssociatedContextAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(share_list);
        }
        return GLXAMDGPUAssociation.nglXCreateAssociatedContextAMD(id, share_list, __functionAddress);
    }

    public static native long nglXCreateAssociatedContextAttribsAMD(int var0, long var1, long var3, long var5);

    public static long nglXCreateAssociatedContextAttribsAMD(int id, long share_context, long attribList) {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().CreateAssociatedContextAttribsAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(share_context);
        }
        return GLXAMDGPUAssociation.nglXCreateAssociatedContextAttribsAMD(id, share_context, attribList, __functionAddress);
    }

    public static long glXCreateAssociatedContextAttribsAMD(int id, long share_context, ByteBuffer attribList) {
        return GLXAMDGPUAssociation.nglXCreateAssociatedContextAttribsAMD(id, share_context, MemoryUtil.memAddress(attribList));
    }

    public static long glXCreateAssociatedContextAttribsAMD(int id, long share_context, IntBuffer attribList) {
        return GLXAMDGPUAssociation.nglXCreateAssociatedContextAttribsAMD(id, share_context, MemoryUtil.memAddress(attribList));
    }

    public static native int nglXDeleteAssociatedContextAMD(long var0, long var2);

    public static int glXDeleteAssociatedContextAMD(long ctx) {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().DeleteAssociatedContextAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ctx);
        }
        return GLXAMDGPUAssociation.nglXDeleteAssociatedContextAMD(ctx, __functionAddress);
    }

    public static native int nglXGetContextGPUIDAMD(long var0, long var2);

    public static int glXGetContextGPUIDAMD(long ctx) {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().GetContextGPUIDAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ctx);
        }
        return GLXAMDGPUAssociation.nglXGetContextGPUIDAMD(ctx, __functionAddress);
    }

    public static native long nglXGetCurrentAssociatedContextAMD(long var0);

    public static long glXGetCurrentAssociatedContextAMD() {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().GetCurrentAssociatedContextAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GLXAMDGPUAssociation.nglXGetCurrentAssociatedContextAMD(__functionAddress);
    }

    public static native int nglXGetGPUIDsAMD(int var0, int var1, long var2);

    public static int glXGetGPUIDsAMD(int maxCount, int ids) {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().GetGPUIDsAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GLXAMDGPUAssociation.nglXGetGPUIDsAMD(maxCount, ids, __functionAddress);
    }

    public static native int nglXGetGPUInfoAMD(int var0, int var1, int var2, int var3, long var4, long var6);

    public static int nglXGetGPUInfoAMD(int id, int property, int dataType, int size, long data) {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().GetGPUInfoAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GLXAMDGPUAssociation.nglXGetGPUInfoAMD(id, property, dataType, size, data, __functionAddress);
    }

    public static int glXGetGPUInfoAMD(int id, int property, int dataType, int size, ByteBuffer data) {
        return GLXAMDGPUAssociation.nglXGetGPUInfoAMD(id, property, dataType, size, MemoryUtil.memAddress(data));
    }

    public static native int nglXMakeAssociatedContextCurrentAMD(long var0, long var2);

    public static int glXMakeAssociatedContextCurrentAMD(long ctx) {
        long __functionAddress = GLXAMDGPUAssociation.getInstance().MakeAssociatedContextCurrentAMD;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ctx);
        }
        return GLXAMDGPUAssociation.nglXMakeAssociatedContextCurrentAMD(ctx, __functionAddress);
    }
}

