/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class WGLARBPixelFormat {
    public static final int WGL_NUMBER_PIXEL_FORMATS_ARB = 8192;
    public static final int WGL_DRAW_TO_WINDOW_ARB = 8193;
    public static final int WGL_DRAW_TO_BITMAP_ARB = 8194;
    public static final int WGL_ACCELERATION_ARB = 8195;
    public static final int WGL_NEED_PALETTE_ARB = 8196;
    public static final int WGL_NEED_SYSTEM_PALETTE_ARB = 8197;
    public static final int WGL_SWAP_LAYER_BUFFERS_ARB = 8198;
    public static final int WGL_SWAP_METHOD_ARB = 8199;
    public static final int WGL_NUMBER_OVERLAYS_ARB = 8200;
    public static final int WGL_NUMBER_UNDERLAYS_ARB = 8201;
    public static final int WGL_TRANSPARENT_ARB = 8202;
    public static final int WGL_TRANSPARENT_RED_VALUE_ARB = 8247;
    public static final int WGL_TRANSPARENT_GREEN_VALUE_ARB = 8248;
    public static final int WGL_TRANSPARENT_BLUE_VALUE_ARB = 8249;
    public static final int WGL_TRANSPARENT_ALPHA_VALUE_ARB = 8250;
    public static final int WGL_TRANSPARENT_INDEX_VALUE_ARB = 8251;
    public static final int WGL_SHARE_DEPTH_ARB = 8204;
    public static final int WGL_SHARE_STENCIL_ARB = 8205;
    public static final int WGL_SHARE_ACCUM_ARB = 8206;
    public static final int WGL_SUPPORT_GDI_ARB = 8207;
    public static final int WGL_SUPPORT_OPENGL_ARB = 8208;
    public static final int WGL_DOUBLE_BUFFER_ARB = 8209;
    public static final int WGL_STEREO_ARB = 8210;
    public static final int WGL_PIXEL_TYPE_ARB = 8211;
    public static final int WGL_COLOR_BITS_ARB = 8212;
    public static final int WGL_RED_BITS_ARB = 8213;
    public static final int WGL_RED_SHIFT_ARB = 8214;
    public static final int WGL_GREEN_BITS_ARB = 8215;
    public static final int WGL_GREEN_SHIFT_ARB = 8216;
    public static final int WGL_BLUE_BITS_ARB = 8217;
    public static final int WGL_BLUE_SHIFT_ARB = 8218;
    public static final int WGL_ALPHA_BITS_ARB = 8219;
    public static final int WGL_ALPHA_SHIFT_ARB = 8220;
    public static final int WGL_ACCUM_BITS_ARB = 8221;
    public static final int WGL_ACCUM_RED_BITS_ARB = 8222;
    public static final int WGL_ACCUM_GREEN_BITS_ARB = 8223;
    public static final int WGL_ACCUM_BLUE_BITS_ARB = 8224;
    public static final int WGL_ACCUM_ALPHA_BITS_ARB = 8225;
    public static final int WGL_DEPTH_BITS_ARB = 8226;
    public static final int WGL_STENCIL_BITS_ARB = 8227;
    public static final int WGL_AUX_BUFFERS_ARB = 8228;
    public static final int WGL_NO_ACCELERATION_ARB = 8229;
    public static final int WGL_GENERIC_ACCELERATION_ARB = 8230;
    public static final int WGL_FULL_ACCELERATION_ARB = 8231;
    public static final int WGL_SWAP_EXCHANGE_ARB = 8232;
    public static final int WGL_SWAP_COPY_ARB = 8233;
    public static final int WGL_SWAP_UNDEFINED_ARB = 8234;
    public static final int WGL_TYPE_RGBA_ARB = 8235;
    public static final int WGL_TYPE_COLORINDEX_ARB = 8236;
    public final long GetPixelFormatAttribivARB;
    public final long GetPixelFormatAttribfvARB;
    public final long ChoosePixelFormatARB;

    public WGLARBPixelFormat(FunctionProvider provider) {
        this.GetPixelFormatAttribivARB = provider.getFunctionAddress("wglGetPixelFormatAttribivARB");
        this.GetPixelFormatAttribfvARB = provider.getFunctionAddress("wglGetPixelFormatAttribfvARB");
        this.ChoosePixelFormatARB = provider.getFunctionAddress("wglChoosePixelFormatARB");
    }

    public static WGLARBPixelFormat getInstance() {
        return GL.getCapabilities().__WGLARBPixelFormat;
    }

    static WGLARBPixelFormat create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_ARB_pixel_format")) {
            return null;
        }
        WGLARBPixelFormat funcs = new WGLARBPixelFormat(provider);
        boolean supported = Checks.checkFunctions(funcs.GetPixelFormatAttribivARB, funcs.GetPixelFormatAttribfvARB, funcs.ChoosePixelFormatARB);
        return GL.checkExtension("WGL_ARB_pixel_format", funcs, supported);
    }

    public static native int nwglGetPixelFormatAttribivARB(long var0, int var2, int var3, int var4, long var5, long var7, long var9);

    public static int nwglGetPixelFormatAttribivARB(long hdc, int pixelFormat, int layerPlane, int n, long attributes, long values) {
        long __functionAddress = WGLARBPixelFormat.getInstance().GetPixelFormatAttribivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hdc);
        }
        return WGLARBPixelFormat.nwglGetPixelFormatAttribivARB(hdc, pixelFormat, layerPlane, n, attributes, values, __functionAddress);
    }

    public static int wglGetPixelFormatAttribivARB(long hdc, int pixelFormat, int layerPlane, int n, ByteBuffer attributes, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)attributes, n << 2);
            Checks.checkBuffer((Buffer)values, n << 2);
        }
        return WGLARBPixelFormat.nwglGetPixelFormatAttribivARB(hdc, pixelFormat, layerPlane, n, MemoryUtil.memAddress(attributes), MemoryUtil.memAddress(values));
    }

    public static int wglGetPixelFormatAttribivARB(long hdc, int pixelFormat, int layerPlane, IntBuffer attributes, IntBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, attributes.remaining());
        }
        return WGLARBPixelFormat.nwglGetPixelFormatAttribivARB(hdc, pixelFormat, layerPlane, attributes.remaining(), MemoryUtil.memAddress(attributes), MemoryUtil.memAddress(values));
    }

    public static int wglGetPixelFormatAttribiARB(long hdc, int pixelFormat, int layerPlane, int attribute, IntBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attributes = __buffer.intParam(attribute);
        return WGLARBPixelFormat.nwglGetPixelFormatAttribivARB(hdc, pixelFormat, layerPlane, 1, __buffer.address(attributes), MemoryUtil.memAddress(values));
    }

    public static native int nwglGetPixelFormatAttribfvARB(long var0, int var2, int var3, int var4, long var5, long var7, long var9);

    public static int nwglGetPixelFormatAttribfvARB(long hdc, int pixelFormat, int layerPlane, int n, long attributes, long values) {
        long __functionAddress = WGLARBPixelFormat.getInstance().GetPixelFormatAttribfvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hdc);
        }
        return WGLARBPixelFormat.nwglGetPixelFormatAttribfvARB(hdc, pixelFormat, layerPlane, n, attributes, values, __functionAddress);
    }

    public static int wglGetPixelFormatAttribfvARB(long hdc, int pixelFormat, int layerPlane, int n, ByteBuffer attributes, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)attributes, n << 2);
            Checks.checkBuffer((Buffer)values, n << 2);
        }
        return WGLARBPixelFormat.nwglGetPixelFormatAttribfvARB(hdc, pixelFormat, layerPlane, n, MemoryUtil.memAddress(attributes), MemoryUtil.memAddress(values));
    }

    public static int wglGetPixelFormatAttribfvARB(long hdc, int pixelFormat, int layerPlane, IntBuffer attributes, FloatBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, attributes.remaining());
        }
        return WGLARBPixelFormat.nwglGetPixelFormatAttribfvARB(hdc, pixelFormat, layerPlane, attributes.remaining(), MemoryUtil.memAddress(attributes), MemoryUtil.memAddress(values));
    }

    public static int wglGetPixelFormatAttribfARB(long hdc, int pixelFormat, int layerPlane, int attribute, FloatBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attributes = __buffer.intParam(attribute);
        return WGLARBPixelFormat.nwglGetPixelFormatAttribfvARB(hdc, pixelFormat, layerPlane, 1, __buffer.address(attributes), MemoryUtil.memAddress(values));
    }

    public static native int nwglChoosePixelFormatARB(long var0, long var2, long var4, int var6, long var7, long var9, long var11);

    public static int nwglChoosePixelFormatARB(long hdc, long attribIList, long attribFList, int maxFormats, long formats, long numFormats) {
        long __functionAddress = WGLARBPixelFormat.getInstance().ChoosePixelFormatARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hdc);
        }
        return WGLARBPixelFormat.nwglChoosePixelFormatARB(hdc, attribIList, attribFList, maxFormats, formats, numFormats, __functionAddress);
    }

    public static int wglChoosePixelFormatARB(long hdc, ByteBuffer attribIList, ByteBuffer attribFList, int maxFormats, ByteBuffer formats, ByteBuffer numFormats) {
        if (LWJGLUtil.CHECKS) {
            if (attribIList != null) {
                Checks.checkNT4(attribIList);
            }
            if (attribFList != null) {
                Checks.checkNT4(attribFList);
            }
            Checks.checkBuffer((Buffer)formats, maxFormats << 2);
            Checks.checkBuffer((Buffer)numFormats, 4);
        }
        return WGLARBPixelFormat.nwglChoosePixelFormatARB(hdc, MemoryUtil.memAddressSafe(attribIList), MemoryUtil.memAddressSafe(attribFList), maxFormats, MemoryUtil.memAddress(formats), MemoryUtil.memAddress(numFormats));
    }

    public static int wglChoosePixelFormatARB(long hdc, IntBuffer attribIList, FloatBuffer attribFList, IntBuffer formats, IntBuffer numFormats) {
        if (LWJGLUtil.CHECKS) {
            if (attribIList != null) {
                Checks.checkNT(attribIList);
            }
            if (attribFList != null) {
                Checks.checkNT(attribFList);
            }
            Checks.checkBuffer((Buffer)numFormats, 1);
        }
        return WGLARBPixelFormat.nwglChoosePixelFormatARB(hdc, MemoryUtil.memAddressSafe(attribIList), MemoryUtil.memAddressSafe(attribFList), formats.remaining(), MemoryUtil.memAddress(formats), MemoryUtil.memAddress(numFormats));
    }
}

