/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XKeyEvent
implements Pointer {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int ROOT;
    public static final int SUBWINDOW;
    public static final int TIME;
    public static final int X;
    public static final int Y;
    public static final int X_ROOT;
    public static final int Y_ROOT;
    public static final int STATE;
    public static final int KEYCODE;
    public static final int SAME_SCREEN;
    private final ByteBuffer struct;

    public XKeyEvent() {
        this(XKeyEvent.malloc());
    }

    public XKeyEvent(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setType(int type) {
        XKeyEvent.type(this.struct, type);
    }

    public void setSerial(long serial) {
        XKeyEvent.serial(this.struct, serial);
    }

    public void setSendEvent(int send_event) {
        XKeyEvent.send_event(this.struct, send_event);
    }

    public void setDisplay(long display) {
        XKeyEvent.display(this.struct, display);
    }

    public void setWindow(long window) {
        XKeyEvent.window(this.struct, window);
    }

    public void setRoot(long root) {
        XKeyEvent.root(this.struct, root);
    }

    public void setSubwindow(long subwindow) {
        XKeyEvent.subwindow(this.struct, subwindow);
    }

    public void setTime(long time) {
        XKeyEvent.time(this.struct, time);
    }

    public void setX(int x) {
        XKeyEvent.x(this.struct, x);
    }

    public void setY(int y) {
        XKeyEvent.y(this.struct, y);
    }

    public void setXRoot(int x_root) {
        XKeyEvent.x_root(this.struct, x_root);
    }

    public void setYRoot(int y_root) {
        XKeyEvent.y_root(this.struct, y_root);
    }

    public void setState(int state) {
        XKeyEvent.state(this.struct, state);
    }

    public void setKeycode(int keycode) {
        XKeyEvent.keycode(this.struct, keycode);
    }

    public void setSameScreen(int same_screen) {
        XKeyEvent.same_screen(this.struct, same_screen);
    }

    public int getType() {
        return XKeyEvent.type(this.struct);
    }

    public long getSerial() {
        return XKeyEvent.serial(this.struct);
    }

    public int getSendEvent() {
        return XKeyEvent.send_event(this.struct);
    }

    public long getDisplay() {
        return XKeyEvent.display(this.struct);
    }

    public long getWindow() {
        return XKeyEvent.window(this.struct);
    }

    public long getRoot() {
        return XKeyEvent.root(this.struct);
    }

    public long getSubwindow() {
        return XKeyEvent.subwindow(this.struct);
    }

    public long getTime() {
        return XKeyEvent.time(this.struct);
    }

    public int getX() {
        return XKeyEvent.x(this.struct);
    }

    public int getY() {
        return XKeyEvent.y(this.struct);
    }

    public int getXRoot() {
        return XKeyEvent.x_root(this.struct);
    }

    public int getYRoot() {
        return XKeyEvent.y_root(this.struct);
    }

    public int getState() {
        return XKeyEvent.state(this.struct);
    }

    public int getKeycode() {
        return XKeyEvent.keycode(this.struct);
    }

    public int getSameScreen() {
        return XKeyEvent.same_screen(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, long window, long root, long subwindow, long time, int x, int y, int x_root, int y_root, int state, int keycode, int same_screen) {
        ByteBuffer xkeyevent = XKeyEvent.malloc();
        XKeyEvent.type(xkeyevent, type);
        XKeyEvent.serial(xkeyevent, serial);
        XKeyEvent.send_event(xkeyevent, send_event);
        XKeyEvent.display(xkeyevent, display);
        XKeyEvent.window(xkeyevent, window);
        XKeyEvent.root(xkeyevent, root);
        XKeyEvent.subwindow(xkeyevent, subwindow);
        XKeyEvent.time(xkeyevent, time);
        XKeyEvent.x(xkeyevent, x);
        XKeyEvent.y(xkeyevent, y);
        XKeyEvent.x_root(xkeyevent, x_root);
        XKeyEvent.y_root(xkeyevent, y_root);
        XKeyEvent.state(xkeyevent, state);
        XKeyEvent.keycode(xkeyevent, keycode);
        XKeyEvent.same_screen(xkeyevent, same_screen);
        return xkeyevent;
    }

    public static void type(ByteBuffer xkeyevent, int type) {
        xkeyevent.putInt(xkeyevent.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xkeyevent, long serial) {
        PointerBuffer.put(xkeyevent, xkeyevent.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xkeyevent, int send_event) {
        xkeyevent.putInt(xkeyevent.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xkeyevent, long display) {
        PointerBuffer.put(xkeyevent, xkeyevent.position() + DISPLAY, display);
    }

    public static void window(ByteBuffer xkeyevent, long window) {
        PointerBuffer.put(xkeyevent, xkeyevent.position() + WINDOW, window);
    }

    public static void root(ByteBuffer xkeyevent, long root) {
        PointerBuffer.put(xkeyevent, xkeyevent.position() + ROOT, root);
    }

    public static void subwindow(ByteBuffer xkeyevent, long subwindow) {
        PointerBuffer.put(xkeyevent, xkeyevent.position() + SUBWINDOW, subwindow);
    }

    public static void time(ByteBuffer xkeyevent, long time) {
        PointerBuffer.put(xkeyevent, xkeyevent.position() + TIME, time);
    }

    public static void x(ByteBuffer xkeyevent, int x) {
        xkeyevent.putInt(xkeyevent.position() + X, x);
    }

    public static void y(ByteBuffer xkeyevent, int y) {
        xkeyevent.putInt(xkeyevent.position() + Y, y);
    }

    public static void x_root(ByteBuffer xkeyevent, int x_root) {
        xkeyevent.putInt(xkeyevent.position() + X_ROOT, x_root);
    }

    public static void y_root(ByteBuffer xkeyevent, int y_root) {
        xkeyevent.putInt(xkeyevent.position() + Y_ROOT, y_root);
    }

    public static void state(ByteBuffer xkeyevent, int state) {
        xkeyevent.putInt(xkeyevent.position() + STATE, state);
    }

    public static void keycode(ByteBuffer xkeyevent, int keycode) {
        xkeyevent.putInt(xkeyevent.position() + KEYCODE, keycode);
    }

    public static void same_screen(ByteBuffer xkeyevent, int same_screen) {
        xkeyevent.putInt(xkeyevent.position() + SAME_SCREEN, same_screen);
    }

    public static int type(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + TYPE);
    }

    public static long serial(ByteBuffer xkeyevent) {
        return PointerBuffer.get(xkeyevent, xkeyevent.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xkeyevent) {
        return PointerBuffer.get(xkeyevent, xkeyevent.position() + DISPLAY);
    }

    public static long window(ByteBuffer xkeyevent) {
        return PointerBuffer.get(xkeyevent, xkeyevent.position() + WINDOW);
    }

    public static long root(ByteBuffer xkeyevent) {
        return PointerBuffer.get(xkeyevent, xkeyevent.position() + ROOT);
    }

    public static long subwindow(ByteBuffer xkeyevent) {
        return PointerBuffer.get(xkeyevent, xkeyevent.position() + SUBWINDOW);
    }

    public static long time(ByteBuffer xkeyevent) {
        return PointerBuffer.get(xkeyevent, xkeyevent.position() + TIME);
    }

    public static int x(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + X);
    }

    public static int y(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + Y);
    }

    public static int x_root(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + X_ROOT);
    }

    public static int y_root(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + Y_ROOT);
    }

    public static int state(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + STATE);
    }

    public static int keycode(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + KEYCODE);
    }

    public static int same_screen(ByteBuffer xkeyevent) {
        return xkeyevent.getInt(xkeyevent.position() + SAME_SCREEN);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(15);
        SIZEOF = XKeyEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        WINDOW = offsets.get(4);
        ROOT = offsets.get(5);
        SUBWINDOW = offsets.get(6);
        TIME = offsets.get(7);
        X = offsets.get(8);
        Y = offsets.get(9);
        X_ROOT = offsets.get(10);
        Y_ROOT = offsets.get(11);
        STATE = offsets.get(12);
        KEYCODE = offsets.get(13);
        SAME_SCREEN = offsets.get(14);
    }
}

