/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XRRModeInfo
implements Pointer {
    public static final int SIZEOF;
    public static final int ID;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DOTCLOCK;
    public static final int HSYNCSTART;
    public static final int HSYNCEND;
    public static final int HTOTAL;
    public static final int HSKEW;
    public static final int VSYNCSTART;
    public static final int VSYNCEND;
    public static final int VTOTAL;
    public static final int NAME;
    public static final int NAMELENGTH;
    public static final int MODEFLAGS;
    private final ByteBuffer struct;

    public XRRModeInfo() {
        this(XRRModeInfo.malloc());
    }

    public XRRModeInfo(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setId(long id) {
        XRRModeInfo.id(this.struct, id);
    }

    public void setWidth(int width) {
        XRRModeInfo.width(this.struct, width);
    }

    public void setHeight(int height) {
        XRRModeInfo.height(this.struct, height);
    }

    public void setDotClock(long dotClock) {
        XRRModeInfo.dotClock(this.struct, dotClock);
    }

    public void setHSyncStart(int hSyncStart) {
        XRRModeInfo.hSyncStart(this.struct, hSyncStart);
    }

    public void setHSyncEnd(int hSyncEnd) {
        XRRModeInfo.hSyncEnd(this.struct, hSyncEnd);
    }

    public void setHTotal(int hTotal) {
        XRRModeInfo.hTotal(this.struct, hTotal);
    }

    public void setHSkew(int hSkew) {
        XRRModeInfo.hSkew(this.struct, hSkew);
    }

    public void setVSyncStart(int vSyncStart) {
        XRRModeInfo.vSyncStart(this.struct, vSyncStart);
    }

    public void setVSyncEnd(int vSyncEnd) {
        XRRModeInfo.vSyncEnd(this.struct, vSyncEnd);
    }

    public void setVTotal(int vTotal) {
        XRRModeInfo.vTotal(this.struct, vTotal);
    }

    public void setName(long name) {
        XRRModeInfo.name(this.struct, name);
    }

    public void setName(ByteBuffer name) {
        XRRModeInfo.name(this.struct, name);
    }

    public void setNameLength(int nameLength) {
        XRRModeInfo.nameLength(this.struct, nameLength);
    }

    public void setModeFlags(long modeFlags) {
        XRRModeInfo.modeFlags(this.struct, modeFlags);
    }

    public long getId() {
        return XRRModeInfo.id(this.struct);
    }

    public int getWidth() {
        return XRRModeInfo.width(this.struct);
    }

    public int getHeight() {
        return XRRModeInfo.height(this.struct);
    }

    public long getDotClock() {
        return XRRModeInfo.dotClock(this.struct);
    }

    public int getHSyncStart() {
        return XRRModeInfo.hSyncStart(this.struct);
    }

    public int getHSyncEnd() {
        return XRRModeInfo.hSyncEnd(this.struct);
    }

    public int getHTotal() {
        return XRRModeInfo.hTotal(this.struct);
    }

    public int getHSkew() {
        return XRRModeInfo.hSkew(this.struct);
    }

    public int getVSyncStart() {
        return XRRModeInfo.vSyncStart(this.struct);
    }

    public int getVSyncEnd() {
        return XRRModeInfo.vSyncEnd(this.struct);
    }

    public int getVTotal() {
        return XRRModeInfo.vTotal(this.struct);
    }

    public long getName() {
        return XRRModeInfo.name(this.struct);
    }

    public ByteBuffer getName(int byteLen) {
        return XRRModeInfo.name(this.struct, byteLen);
    }

    public int getNameLength() {
        return XRRModeInfo.nameLength(this.struct);
    }

    public long getModeFlags() {
        return XRRModeInfo.modeFlags(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long id, int width, int height, long dotClock, int hSyncStart, int hSyncEnd, int hTotal, int hSkew, int vSyncStart, int vSyncEnd, int vTotal, ByteBuffer name, int nameLength, long modeFlags) {
        ByteBuffer xrrmodeinfo = XRRModeInfo.malloc();
        XRRModeInfo.id(xrrmodeinfo, id);
        XRRModeInfo.width(xrrmodeinfo, width);
        XRRModeInfo.height(xrrmodeinfo, height);
        XRRModeInfo.dotClock(xrrmodeinfo, dotClock);
        XRRModeInfo.hSyncStart(xrrmodeinfo, hSyncStart);
        XRRModeInfo.hSyncEnd(xrrmodeinfo, hSyncEnd);
        XRRModeInfo.hTotal(xrrmodeinfo, hTotal);
        XRRModeInfo.hSkew(xrrmodeinfo, hSkew);
        XRRModeInfo.vSyncStart(xrrmodeinfo, vSyncStart);
        XRRModeInfo.vSyncEnd(xrrmodeinfo, vSyncEnd);
        XRRModeInfo.vTotal(xrrmodeinfo, vTotal);
        XRRModeInfo.name(xrrmodeinfo, name);
        XRRModeInfo.nameLength(xrrmodeinfo, nameLength);
        XRRModeInfo.modeFlags(xrrmodeinfo, modeFlags);
        return xrrmodeinfo;
    }

    public static void id(ByteBuffer xrrmodeinfo, long id) {
        PointerBuffer.put(xrrmodeinfo, xrrmodeinfo.position() + ID, id);
    }

    public static void width(ByteBuffer xrrmodeinfo, int width) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + WIDTH, width);
    }

    public static void height(ByteBuffer xrrmodeinfo, int height) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + HEIGHT, height);
    }

    public static void dotClock(ByteBuffer xrrmodeinfo, long dotClock) {
        PointerBuffer.put(xrrmodeinfo, xrrmodeinfo.position() + DOTCLOCK, dotClock);
    }

    public static void hSyncStart(ByteBuffer xrrmodeinfo, int hSyncStart) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + HSYNCSTART, hSyncStart);
    }

    public static void hSyncEnd(ByteBuffer xrrmodeinfo, int hSyncEnd) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + HSYNCEND, hSyncEnd);
    }

    public static void hTotal(ByteBuffer xrrmodeinfo, int hTotal) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + HTOTAL, hTotal);
    }

    public static void hSkew(ByteBuffer xrrmodeinfo, int hSkew) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + HSKEW, hSkew);
    }

    public static void vSyncStart(ByteBuffer xrrmodeinfo, int vSyncStart) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + VSYNCSTART, vSyncStart);
    }

    public static void vSyncEnd(ByteBuffer xrrmodeinfo, int vSyncEnd) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + VSYNCEND, vSyncEnd);
    }

    public static void vTotal(ByteBuffer xrrmodeinfo, int vTotal) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + VTOTAL, vTotal);
    }

    public static void name(ByteBuffer xrrmodeinfo, long name) {
        PointerBuffer.put(xrrmodeinfo, xrrmodeinfo.position() + NAME, name);
    }

    public static void name(ByteBuffer xrrmodeinfo, ByteBuffer name) {
        XRRModeInfo.name(xrrmodeinfo, MemoryUtil.memAddressSafe(name));
    }

    public static void nameLength(ByteBuffer xrrmodeinfo, int nameLength) {
        xrrmodeinfo.putInt(xrrmodeinfo.position() + NAMELENGTH, nameLength);
    }

    public static void modeFlags(ByteBuffer xrrmodeinfo, long modeFlags) {
        PointerBuffer.put(xrrmodeinfo, xrrmodeinfo.position() + MODEFLAGS, modeFlags);
    }

    public static long id(ByteBuffer xrrmodeinfo) {
        return PointerBuffer.get(xrrmodeinfo, xrrmodeinfo.position() + ID);
    }

    public static int width(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + WIDTH);
    }

    public static int height(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + HEIGHT);
    }

    public static long dotClock(ByteBuffer xrrmodeinfo) {
        return PointerBuffer.get(xrrmodeinfo, xrrmodeinfo.position() + DOTCLOCK);
    }

    public static int hSyncStart(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + HSYNCSTART);
    }

    public static int hSyncEnd(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + HSYNCEND);
    }

    public static int hTotal(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + HTOTAL);
    }

    public static int hSkew(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + HSKEW);
    }

    public static int vSyncStart(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + VSYNCSTART);
    }

    public static int vSyncEnd(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + VSYNCEND);
    }

    public static int vTotal(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + VTOTAL);
    }

    public static long name(ByteBuffer xrrmodeinfo) {
        return PointerBuffer.get(xrrmodeinfo, xrrmodeinfo.position() + NAME);
    }

    public static ByteBuffer name(ByteBuffer xrrmodeinfo, int byteLen) {
        return MemoryUtil.memByteBuffer(XRRModeInfo.name(xrrmodeinfo), byteLen);
    }

    public static int nameLength(ByteBuffer xrrmodeinfo) {
        return xrrmodeinfo.getInt(xrrmodeinfo.position() + NAMELENGTH);
    }

    public static long modeFlags(ByteBuffer xrrmodeinfo) {
        return PointerBuffer.get(xrrmodeinfo, xrrmodeinfo.position() + MODEFLAGS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(14);
        SIZEOF = XRRModeInfo.offsets(MemoryUtil.memAddress(offsets));
        ID = offsets.get(0);
        WIDTH = offsets.get(1);
        HEIGHT = offsets.get(2);
        DOTCLOCK = offsets.get(3);
        HSYNCSTART = offsets.get(4);
        HSYNCEND = offsets.get(5);
        HTOTAL = offsets.get(6);
        HSKEW = offsets.get(7);
        VSYNCSTART = offsets.get(8);
        VSYNCEND = offsets.get(9);
        VTOTAL = offsets.get(10);
        NAME = offsets.get(11);
        NAMELENGTH = offsets.get(12);
        MODEFLAGS = offsets.get(13);
    }
}

