/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.Visual;

public final class XWindowAttributes
implements Pointer {
    public static final int SIZEOF;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int BORDER_WIDTH;
    public static final int DEPTH;
    public static final int VISUAL;
    public static final int ROOT;
    public static final int CLAZZ;
    public static final int BIT_GRAVITY;
    public static final int WIN_GRAVITY;
    public static final int BACKING_STORE;
    public static final int BACKING_PLANES;
    public static final int BACKING_PIXEL;
    public static final int SAVE_UNDER;
    public static final int COLORMAP;
    public static final int MAP_INSTALLED;
    public static final int MAP_STATE;
    public static final int ALL_EVENT_MASKS;
    public static final int YOUR_EVENT_MASK;
    public static final int DO_NOT_PROPAGATE_MASK;
    public static final int OVERRIDE_REDIRECT;
    public static final int SCREEN;
    private final ByteBuffer struct;

    public XWindowAttributes() {
        this(XWindowAttributes.malloc());
    }

    public XWindowAttributes(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setX(int x) {
        XWindowAttributes.x(this.struct, x);
    }

    public void setY(int y) {
        XWindowAttributes.y(this.struct, y);
    }

    public void setWidth(int width) {
        XWindowAttributes.width(this.struct, width);
    }

    public void setHeight(int height) {
        XWindowAttributes.height(this.struct, height);
    }

    public void setBorderWidth(int border_width) {
        XWindowAttributes.border_width(this.struct, border_width);
    }

    public void setDepth(int depth) {
        XWindowAttributes.depth(this.struct, depth);
    }

    public void setVisual(long visual) {
        XWindowAttributes.visual(this.struct, visual);
    }

    public void setVisual(ByteBuffer visual) {
        XWindowAttributes.visual(this.struct, visual);
    }

    public void setRoot(long root) {
        XWindowAttributes.root(this.struct, root);
    }

    public void setClazz(int clazz) {
        XWindowAttributes.clazz(this.struct, clazz);
    }

    public void setBitGravity(int bit_gravity) {
        XWindowAttributes.bit_gravity(this.struct, bit_gravity);
    }

    public void setWinGravity(int win_gravity) {
        XWindowAttributes.win_gravity(this.struct, win_gravity);
    }

    public void setBackingStore(int backing_store) {
        XWindowAttributes.backing_store(this.struct, backing_store);
    }

    public void setBackingPlanes(long backing_planes) {
        XWindowAttributes.backing_planes(this.struct, backing_planes);
    }

    public void setBackingPixel(long backing_pixel) {
        XWindowAttributes.backing_pixel(this.struct, backing_pixel);
    }

    public void setSaveUnder(int save_under) {
        XWindowAttributes.save_under(this.struct, save_under);
    }

    public void setColormap(long colormap) {
        XWindowAttributes.colormap(this.struct, colormap);
    }

    public void setMapInstalled(int map_installed) {
        XWindowAttributes.map_installed(this.struct, map_installed);
    }

    public void setMapState(int map_state) {
        XWindowAttributes.map_state(this.struct, map_state);
    }

    public void setAllEventMasks(long all_event_masks) {
        XWindowAttributes.all_event_masks(this.struct, all_event_masks);
    }

    public void setYourEventMask(long your_event_mask) {
        XWindowAttributes.your_event_mask(this.struct, your_event_mask);
    }

    public void setDoNotPropagateMask(long do_not_propagate_mask) {
        XWindowAttributes.do_not_propagate_mask(this.struct, do_not_propagate_mask);
    }

    public void setOverrideRedirect(int override_redirect) {
        XWindowAttributes.override_redirect(this.struct, override_redirect);
    }

    public void setScreen(long screen) {
        XWindowAttributes.screen(this.struct, screen);
    }

    public int getX() {
        return XWindowAttributes.x(this.struct);
    }

    public int getY() {
        return XWindowAttributes.y(this.struct);
    }

    public int getWidth() {
        return XWindowAttributes.width(this.struct);
    }

    public int getHeight() {
        return XWindowAttributes.height(this.struct);
    }

    public int getBorderWidth() {
        return XWindowAttributes.border_width(this.struct);
    }

    public int getDepth() {
        return XWindowAttributes.depth(this.struct);
    }

    public long getVisual() {
        return XWindowAttributes.visual(this.struct);
    }

    public ByteBuffer getVisualBuffer() {
        return XWindowAttributes.visualBuffer(this.struct);
    }

    public long getRoot() {
        return XWindowAttributes.root(this.struct);
    }

    public int getClazz() {
        return XWindowAttributes.clazz(this.struct);
    }

    public int getBitGravity() {
        return XWindowAttributes.bit_gravity(this.struct);
    }

    public int getWinGravity() {
        return XWindowAttributes.win_gravity(this.struct);
    }

    public int getBackingStore() {
        return XWindowAttributes.backing_store(this.struct);
    }

    public long getBackingPlanes() {
        return XWindowAttributes.backing_planes(this.struct);
    }

    public long getBackingPixel() {
        return XWindowAttributes.backing_pixel(this.struct);
    }

    public int getSaveUnder() {
        return XWindowAttributes.save_under(this.struct);
    }

    public long getColormap() {
        return XWindowAttributes.colormap(this.struct);
    }

    public int getMapInstalled() {
        return XWindowAttributes.map_installed(this.struct);
    }

    public int getMapState() {
        return XWindowAttributes.map_state(this.struct);
    }

    public long getAllEventMasks() {
        return XWindowAttributes.all_event_masks(this.struct);
    }

    public long getYourEventMask() {
        return XWindowAttributes.your_event_mask(this.struct);
    }

    public long getDoNotPropagateMask() {
        return XWindowAttributes.do_not_propagate_mask(this.struct);
    }

    public int getOverrideRedirect() {
        return XWindowAttributes.override_redirect(this.struct);
    }

    public long getScreen() {
        return XWindowAttributes.screen(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int x, int y, int width, int height, int border_width, int depth, ByteBuffer visual, long root, int clazz, int bit_gravity, int win_gravity, int backing_store, long backing_planes, long backing_pixel, int save_under, long colormap, int map_installed, int map_state, long all_event_masks, long your_event_mask, long do_not_propagate_mask, int override_redirect, long screen) {
        ByteBuffer xwindowattributes = XWindowAttributes.malloc();
        XWindowAttributes.x(xwindowattributes, x);
        XWindowAttributes.y(xwindowattributes, y);
        XWindowAttributes.width(xwindowattributes, width);
        XWindowAttributes.height(xwindowattributes, height);
        XWindowAttributes.border_width(xwindowattributes, border_width);
        XWindowAttributes.depth(xwindowattributes, depth);
        XWindowAttributes.visual(xwindowattributes, visual);
        XWindowAttributes.root(xwindowattributes, root);
        XWindowAttributes.clazz(xwindowattributes, clazz);
        XWindowAttributes.bit_gravity(xwindowattributes, bit_gravity);
        XWindowAttributes.win_gravity(xwindowattributes, win_gravity);
        XWindowAttributes.backing_store(xwindowattributes, backing_store);
        XWindowAttributes.backing_planes(xwindowattributes, backing_planes);
        XWindowAttributes.backing_pixel(xwindowattributes, backing_pixel);
        XWindowAttributes.save_under(xwindowattributes, save_under);
        XWindowAttributes.colormap(xwindowattributes, colormap);
        XWindowAttributes.map_installed(xwindowattributes, map_installed);
        XWindowAttributes.map_state(xwindowattributes, map_state);
        XWindowAttributes.all_event_masks(xwindowattributes, all_event_masks);
        XWindowAttributes.your_event_mask(xwindowattributes, your_event_mask);
        XWindowAttributes.do_not_propagate_mask(xwindowattributes, do_not_propagate_mask);
        XWindowAttributes.override_redirect(xwindowattributes, override_redirect);
        XWindowAttributes.screen(xwindowattributes, screen);
        return xwindowattributes;
    }

    public static void x(ByteBuffer xwindowattributes, int x) {
        xwindowattributes.putInt(xwindowattributes.position() + X, x);
    }

    public static void y(ByteBuffer xwindowattributes, int y) {
        xwindowattributes.putInt(xwindowattributes.position() + Y, y);
    }

    public static void width(ByteBuffer xwindowattributes, int width) {
        xwindowattributes.putInt(xwindowattributes.position() + WIDTH, width);
    }

    public static void height(ByteBuffer xwindowattributes, int height) {
        xwindowattributes.putInt(xwindowattributes.position() + HEIGHT, height);
    }

    public static void border_width(ByteBuffer xwindowattributes, int border_width) {
        xwindowattributes.putInt(xwindowattributes.position() + BORDER_WIDTH, border_width);
    }

    public static void depth(ByteBuffer xwindowattributes, int depth) {
        xwindowattributes.putInt(xwindowattributes.position() + DEPTH, depth);
    }

    public static void visual(ByteBuffer xwindowattributes, long visual) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + VISUAL, visual);
    }

    public static void visual(ByteBuffer xwindowattributes, ByteBuffer visual) {
        XWindowAttributes.visual(xwindowattributes, MemoryUtil.memAddressSafe(visual));
    }

    public static void root(ByteBuffer xwindowattributes, long root) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + ROOT, root);
    }

    public static void clazz(ByteBuffer xwindowattributes, int clazz) {
        xwindowattributes.putInt(xwindowattributes.position() + CLAZZ, clazz);
    }

    public static void bit_gravity(ByteBuffer xwindowattributes, int bit_gravity) {
        xwindowattributes.putInt(xwindowattributes.position() + BIT_GRAVITY, bit_gravity);
    }

    public static void win_gravity(ByteBuffer xwindowattributes, int win_gravity) {
        xwindowattributes.putInt(xwindowattributes.position() + WIN_GRAVITY, win_gravity);
    }

    public static void backing_store(ByteBuffer xwindowattributes, int backing_store) {
        xwindowattributes.putInt(xwindowattributes.position() + BACKING_STORE, backing_store);
    }

    public static void backing_planes(ByteBuffer xwindowattributes, long backing_planes) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + BACKING_PLANES, backing_planes);
    }

    public static void backing_pixel(ByteBuffer xwindowattributes, long backing_pixel) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + BACKING_PIXEL, backing_pixel);
    }

    public static void save_under(ByteBuffer xwindowattributes, int save_under) {
        xwindowattributes.putInt(xwindowattributes.position() + SAVE_UNDER, save_under);
    }

    public static void colormap(ByteBuffer xwindowattributes, long colormap) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + COLORMAP, colormap);
    }

    public static void map_installed(ByteBuffer xwindowattributes, int map_installed) {
        xwindowattributes.putInt(xwindowattributes.position() + MAP_INSTALLED, map_installed);
    }

    public static void map_state(ByteBuffer xwindowattributes, int map_state) {
        xwindowattributes.putInt(xwindowattributes.position() + MAP_STATE, map_state);
    }

    public static void all_event_masks(ByteBuffer xwindowattributes, long all_event_masks) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + ALL_EVENT_MASKS, all_event_masks);
    }

    public static void your_event_mask(ByteBuffer xwindowattributes, long your_event_mask) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + YOUR_EVENT_MASK, your_event_mask);
    }

    public static void do_not_propagate_mask(ByteBuffer xwindowattributes, long do_not_propagate_mask) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + DO_NOT_PROPAGATE_MASK, do_not_propagate_mask);
    }

    public static void override_redirect(ByteBuffer xwindowattributes, int override_redirect) {
        xwindowattributes.putInt(xwindowattributes.position() + OVERRIDE_REDIRECT, override_redirect);
    }

    public static void screen(ByteBuffer xwindowattributes, long screen) {
        PointerBuffer.put(xwindowattributes, xwindowattributes.position() + SCREEN, screen);
    }

    public static int x(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + X);
    }

    public static int y(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + Y);
    }

    public static int width(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + WIDTH);
    }

    public static int height(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + HEIGHT);
    }

    public static int border_width(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + BORDER_WIDTH);
    }

    public static int depth(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + DEPTH);
    }

    public static long visual(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + VISUAL);
    }

    public static ByteBuffer visualBuffer(ByteBuffer xwindowattributes) {
        return MemoryUtil.memByteBuffer(XWindowAttributes.visual(xwindowattributes), Visual.SIZEOF);
    }

    public static long root(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + ROOT);
    }

    public static int clazz(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + CLAZZ);
    }

    public static int bit_gravity(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + BIT_GRAVITY);
    }

    public static int win_gravity(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + WIN_GRAVITY);
    }

    public static int backing_store(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + BACKING_STORE);
    }

    public static long backing_planes(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + BACKING_PLANES);
    }

    public static long backing_pixel(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + BACKING_PIXEL);
    }

    public static int save_under(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + SAVE_UNDER);
    }

    public static long colormap(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + COLORMAP);
    }

    public static int map_installed(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + MAP_INSTALLED);
    }

    public static int map_state(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + MAP_STATE);
    }

    public static long all_event_masks(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + ALL_EVENT_MASKS);
    }

    public static long your_event_mask(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + YOUR_EVENT_MASK);
    }

    public static long do_not_propagate_mask(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + DO_NOT_PROPAGATE_MASK);
    }

    public static int override_redirect(ByteBuffer xwindowattributes) {
        return xwindowattributes.getInt(xwindowattributes.position() + OVERRIDE_REDIRECT);
    }

    public static long screen(ByteBuffer xwindowattributes) {
        return PointerBuffer.get(xwindowattributes, xwindowattributes.position() + SCREEN);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(23);
        SIZEOF = XWindowAttributes.offsets(MemoryUtil.memAddress(offsets));
        X = offsets.get(0);
        Y = offsets.get(1);
        WIDTH = offsets.get(2);
        HEIGHT = offsets.get(3);
        BORDER_WIDTH = offsets.get(4);
        DEPTH = offsets.get(5);
        VISUAL = offsets.get(6);
        ROOT = offsets.get(7);
        CLAZZ = offsets.get(8);
        BIT_GRAVITY = offsets.get(9);
        WIN_GRAVITY = offsets.get(10);
        BACKING_STORE = offsets.get(11);
        BACKING_PLANES = offsets.get(12);
        BACKING_PIXEL = offsets.get(13);
        SAVE_UNDER = offsets.get(14);
        COLORMAP = offsets.get(15);
        MAP_INSTALLED = offsets.get(16);
        MAP_STATE = offsets.get(17);
        ALL_EVENT_MASKS = offsets.get(18);
        YOUR_EVENT_MASK = offsets.get(19);
        DO_NOT_PROPAGATE_MASK = offsets.get(20);
        OVERRIDE_REDIRECT = offsets.get(21);
        SCREEN = offsets.get(22);
    }
}

