/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class DISPLAY_DEVICE
implements Pointer {
    public static final int SIZEOF;
    public static final int CB;
    public static final int DEVICENAME;
    public static final int DEVICESTRING;
    public static final int STATEFLAGS;
    public static final int DEVICEID;
    public static final int DEVICEKEY;
    private final ByteBuffer struct;

    public DISPLAY_DEVICE() {
        this(DISPLAY_DEVICE.malloc());
    }

    public DISPLAY_DEVICE(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setCb(int cb) {
        DISPLAY_DEVICE.cb(this.struct, cb);
    }

    public void setDeviceName(ByteBuffer DeviceName) {
        DISPLAY_DEVICE.DeviceNameSet(this.struct, DeviceName);
    }

    public void setDeviceName(CharSequence DeviceName) {
        DISPLAY_DEVICE.DeviceName(this.struct, DeviceName);
    }

    public void setDeviceString(ByteBuffer DeviceString) {
        DISPLAY_DEVICE.DeviceStringSet(this.struct, DeviceString);
    }

    public void setDeviceString(CharSequence DeviceString) {
        DISPLAY_DEVICE.DeviceString(this.struct, DeviceString);
    }

    public void setStateFlags(int StateFlags) {
        DISPLAY_DEVICE.StateFlags(this.struct, StateFlags);
    }

    public void setDeviceID(ByteBuffer DeviceID) {
        DISPLAY_DEVICE.DeviceIDSet(this.struct, DeviceID);
    }

    public void setDeviceID(CharSequence DeviceID) {
        DISPLAY_DEVICE.DeviceID(this.struct, DeviceID);
    }

    public void setDeviceKey(ByteBuffer DeviceKey) {
        DISPLAY_DEVICE.DeviceKeySet(this.struct, DeviceKey);
    }

    public void setDeviceKey(CharSequence DeviceKey) {
        DISPLAY_DEVICE.DeviceKey(this.struct, DeviceKey);
    }

    public int getCb() {
        return DISPLAY_DEVICE.cb(this.struct);
    }

    public void getDeviceName(ByteBuffer DeviceName) {
        DISPLAY_DEVICE.DeviceNameGet(this.struct, DeviceName);
    }

    public String getDeviceNameString() {
        return DISPLAY_DEVICE.DeviceNameString(this.struct);
    }

    public String getDeviceNameString(int byteLen) {
        return DISPLAY_DEVICE.DeviceNameString(this.struct, byteLen);
    }

    public void getDeviceString(ByteBuffer DeviceString) {
        DISPLAY_DEVICE.DeviceStringGet(this.struct, DeviceString);
    }

    public String getDeviceStringString() {
        return DISPLAY_DEVICE.DeviceStringString(this.struct);
    }

    public String getDeviceStringString(int byteLen) {
        return DISPLAY_DEVICE.DeviceStringString(this.struct, byteLen);
    }

    public int getStateFlags() {
        return DISPLAY_DEVICE.StateFlags(this.struct);
    }

    public void getDeviceID(ByteBuffer DeviceID) {
        DISPLAY_DEVICE.DeviceIDGet(this.struct, DeviceID);
    }

    public String getDeviceIDString() {
        return DISPLAY_DEVICE.DeviceIDString(this.struct);
    }

    public String getDeviceIDString(int byteLen) {
        return DISPLAY_DEVICE.DeviceIDString(this.struct, byteLen);
    }

    public void getDeviceKey(ByteBuffer DeviceKey) {
        DISPLAY_DEVICE.DeviceKeyGet(this.struct, DeviceKey);
    }

    public String getDeviceKeyString() {
        return DISPLAY_DEVICE.DeviceKeyString(this.struct);
    }

    public String getDeviceKeyString(int byteLen) {
        return DISPLAY_DEVICE.DeviceKeyString(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int cb, ByteBuffer DeviceName, ByteBuffer DeviceString, int StateFlags, ByteBuffer DeviceID, ByteBuffer DeviceKey) {
        ByteBuffer display_device = DISPLAY_DEVICE.malloc();
        DISPLAY_DEVICE.cb(display_device, cb);
        DISPLAY_DEVICE.DeviceNameSet(display_device, DeviceName);
        DISPLAY_DEVICE.DeviceStringSet(display_device, DeviceString);
        DISPLAY_DEVICE.StateFlags(display_device, StateFlags);
        DISPLAY_DEVICE.DeviceIDSet(display_device, DeviceID);
        DISPLAY_DEVICE.DeviceKeySet(display_device, DeviceKey);
        return display_device;
    }

    public static ByteBuffer malloc(int cb, CharSequence DeviceName, CharSequence DeviceString, int StateFlags, CharSequence DeviceID, CharSequence DeviceKey) {
        ByteBuffer display_device = DISPLAY_DEVICE.malloc();
        DISPLAY_DEVICE.cb(display_device, cb);
        DISPLAY_DEVICE.DeviceName(display_device, DeviceName);
        DISPLAY_DEVICE.DeviceString(display_device, DeviceString);
        DISPLAY_DEVICE.StateFlags(display_device, StateFlags);
        DISPLAY_DEVICE.DeviceID(display_device, DeviceID);
        DISPLAY_DEVICE.DeviceKey(display_device, DeviceKey);
        return display_device;
    }

    public static void cb(ByteBuffer display_device, int cb) {
        display_device.putInt(display_device.position() + CB, cb);
    }

    public static void DeviceNameSet(ByteBuffer display_device, ByteBuffer DeviceName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(DeviceName);
            Checks.checkBufferGT(DeviceName, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(DeviceName), MemoryUtil.memAddress(display_device) + (long)DEVICENAME, DeviceName.remaining());
    }

    public static void DeviceName(ByteBuffer display_device, CharSequence DeviceName) {
        MemoryUtil.memEncodeUTF16(DeviceName, true, display_device, DEVICENAME);
    }

    public static void DeviceStringSet(ByteBuffer display_device, ByteBuffer DeviceString) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(DeviceString);
            Checks.checkBufferGT(DeviceString, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(DeviceString), MemoryUtil.memAddress(display_device) + (long)DEVICESTRING, DeviceString.remaining());
    }

    public static void DeviceString(ByteBuffer display_device, CharSequence DeviceString) {
        MemoryUtil.memEncodeUTF16(DeviceString, true, display_device, DEVICESTRING);
    }

    public static void StateFlags(ByteBuffer display_device, int StateFlags) {
        display_device.putInt(display_device.position() + STATEFLAGS, StateFlags);
    }

    public static void DeviceIDSet(ByteBuffer display_device, ByteBuffer DeviceID) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(DeviceID);
            Checks.checkBufferGT(DeviceID, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(DeviceID), MemoryUtil.memAddress(display_device) + (long)DEVICEID, DeviceID.remaining());
    }

    public static void DeviceID(ByteBuffer display_device, CharSequence DeviceID) {
        MemoryUtil.memEncodeUTF16(DeviceID, true, display_device, DEVICEID);
    }

    public static void DeviceKeySet(ByteBuffer display_device, ByteBuffer DeviceKey) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(DeviceKey);
            Checks.checkBufferGT(DeviceKey, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(DeviceKey), MemoryUtil.memAddress(display_device) + (long)DEVICEKEY, DeviceKey.remaining());
    }

    public static void DeviceKey(ByteBuffer display_device, CharSequence DeviceKey) {
        MemoryUtil.memEncodeUTF16(DeviceKey, true, display_device, DEVICEKEY);
    }

    public static int cb(ByteBuffer display_device) {
        return display_device.getInt(display_device.position() + CB);
    }

    public static void DeviceNameGet(ByteBuffer display_device, ByteBuffer DeviceName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(DeviceName, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(display_device) + (long)DEVICENAME, MemoryUtil.memAddress(DeviceName), DeviceName.remaining());
    }

    public static String DeviceNameString(ByteBuffer display_device) {
        return MemoryUtil.memDecodeUTF16(display_device, MemoryUtil.memStrLen2(display_device, DEVICENAME), DEVICENAME);
    }

    public static String DeviceNameString(ByteBuffer display_device, int byteLen) {
        return MemoryUtil.memDecodeUTF16(display_device, byteLen, DEVICENAME);
    }

    public static void DeviceStringGet(ByteBuffer display_device, ByteBuffer DeviceString) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(DeviceString, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(display_device) + (long)DEVICESTRING, MemoryUtil.memAddress(DeviceString), DeviceString.remaining());
    }

    public static String DeviceStringString(ByteBuffer display_device) {
        return MemoryUtil.memDecodeUTF16(display_device, MemoryUtil.memStrLen2(display_device, DEVICESTRING), DEVICESTRING);
    }

    public static String DeviceStringString(ByteBuffer display_device, int byteLen) {
        return MemoryUtil.memDecodeUTF16(display_device, byteLen, DEVICESTRING);
    }

    public static int StateFlags(ByteBuffer display_device) {
        return display_device.getInt(display_device.position() + STATEFLAGS);
    }

    public static void DeviceIDGet(ByteBuffer display_device, ByteBuffer DeviceID) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(DeviceID, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(display_device) + (long)DEVICEID, MemoryUtil.memAddress(DeviceID), DeviceID.remaining());
    }

    public static String DeviceIDString(ByteBuffer display_device) {
        return MemoryUtil.memDecodeUTF16(display_device, MemoryUtil.memStrLen2(display_device, DEVICEID), DEVICEID);
    }

    public static String DeviceIDString(ByteBuffer display_device, int byteLen) {
        return MemoryUtil.memDecodeUTF16(display_device, byteLen, DEVICEID);
    }

    public static void DeviceKeyGet(ByteBuffer display_device, ByteBuffer DeviceKey) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(DeviceKey, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(display_device) + (long)DEVICEKEY, MemoryUtil.memAddress(DeviceKey), DeviceKey.remaining());
    }

    public static String DeviceKeyString(ByteBuffer display_device) {
        return MemoryUtil.memDecodeUTF16(display_device, MemoryUtil.memStrLen2(display_device, DEVICEKEY), DEVICEKEY);
    }

    public static String DeviceKeyString(ByteBuffer display_device, int byteLen) {
        return MemoryUtil.memDecodeUTF16(display_device, byteLen, DEVICEKEY);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = DISPLAY_DEVICE.offsets(MemoryUtil.memAddress(offsets));
        CB = offsets.get(0);
        DEVICENAME = offsets.get(1);
        DEVICESTRING = offsets.get(2);
        STATEFLAGS = offsets.get(3);
        DEVICEID = offsets.get(4);
        DEVICEKEY = offsets.get(5);
    }
}

