/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javafx.animation.PauseTransition;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class MultiTower
extends GenericTower {
    private LineTo projectileTo = new LineTo();
    private int towerPrice = 200;
    private Random random = new Random();
    private int reloadTime = 250;
    private int minHit = 1;
    private PauseTransition pt = new PauseTransition();

    public MultiTower(double _width) {
        this.range = 150.0;
        this.price = this.towerPrice;
        this.width = _width;
        this.body = new Group();
        this.groundPoly = this.getShape();
        this.body.getChildren().add((Object)this.groundPoly);
    }

    public MultiTower(double _x, double _y, double _width) {
        this.range = 150.0;
        this.price = this.towerPrice;
        this.width = _width;
        this.x = _x;
        this.y = _y;
        GenericTower.towers.add(this);
        this.body = new Group();
        this.groundPoly = this.getShape();
        this.projectilePath.getElements().add((Object)this.projectileFrom);
        this.projectilePath.getElements().add((Object)this.projectileTo);
        this.groundPoly.setLayoutX(0.0 - this.width);
        this.groundPoly.setLayoutY(0.0 - this.width);
        this.groundPoly.setFill((Paint)Color.BLACK);
        this.groundPoly.setStroke((Paint)Color.LIGHTGREEN);
        this.groundPoly.setStrokeWidth(2.0);
        DropShadow outerGlow = new DropShadow();
        outerGlow.setOffsetX(0.0);
        outerGlow.setOffsetY(0.0);
        outerGlow.setRadius(20.0);
        outerGlow.setColor(Color.LIGHTGREEN);
        this.groundPoly.setEffect((Effect)outerGlow);
        this.body.getChildren().add((Object)this.groundPoly);
        this.body.setLayoutX(this.x);
        this.body.setLayoutY(this.y);
        this.projectileFrom.setX(this.x);
        this.projectileFrom.setY(this.y);
        this.projectileTo.setX(this.x);
        this.projectileTo.setY(this.y);
        this.rangeCircle = new Circle(this.x, this.y, this.range);
        this.body.getTransforms().add((Object)this.rotation);
        this.rangeCircle.setFill((Paint)Color.WHITE);
        this.rangeCircle.setOpacity(0.0);
    }

    @Override
    public Polygon getShape() {
        Polygon poly = new Polygon();
        poly.getPoints().addAll((Object[])new Double[]{-3.0, this.width, this.width * 0.5, this.width * 2.0, this.width * 1.5, this.width * 2.0, this.width * 2.0 + 3.0, this.width, this.width * 1.5, 0.0, this.width * 0.5, 0.0});
        poly.setLayoutX(0.0 - this.width);
        poly.setLayoutY(0.0 - this.width);
        return poly;
    }

    @Override
    public void rotate(double monsterX, double monsterY) {
        this.projectileTo.setX(monsterX);
        this.projectileTo.setY(monsterY);
    }

    @Override
    public void shoot(GenericMonster m) {
        new MultiProjectile(this, m, this.projectilePath);
    }

    @Override
    public void handleMonsters() {
        if (this.hasAmmo && this.monstersInRange.size() > 0) {
            this.hasAmmo = false;
            ArrayList lookingAt = new ArrayList(this.monstersInRange);
            Collections.shuffle(lookingAt);
            int shootAt = this.minHit + this.random.nextInt(lookingAt.size());
            if (shootAt > lookingAt.size() - 1) {
                shootAt = lookingAt.size() - 1;
            }
            for (int i = 0; i < shootAt; ++i) {
                GenericMonster monsterInSight = (GenericMonster)lookingAt.get(i);
                Shape monsterBody = monsterInSight.getBody();
                Bounds monsterBounds = monsterBody.localToScene(monsterBody.getBoundsInLocal());
                double monsterX = monsterBounds.getMinX() + monsterBounds.getWidth() * 0.5;
                double monsterY = monsterBounds.getMinY() + monsterBounds.getHeight() * 0.5;
                this.rotate(monsterX, monsterY);
                this.shoot(monsterInSight);
            }
            this.pt.setDuration(Duration.millis((double)this.reloadTime));
            this.pt.setOnFinished(e -> {
                this.hasAmmo = true;
            });
            this.pt.play();
        }
    }
}

