/*
 * Decompiled with CFR 0.152.
 */
import javafx.animation.Interpolator;
import javafx.animation.PathTransition;
import javafx.animation.PauseTransition;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class QuickProjectile
extends GenericProjectile {
    private Polygon bullet;

    public QuickProjectile(GenericTower t, GenericMonster m) {
        this.damage = 7;
        this.hitTime = 70;
        this.reloadTime = 150;
        this.fromTower = t;
        t.setHasAmmo(false);
        GenericProjectile.projectiles.add(this);
        Defence.projectileGroup.getChildren().add((Object)this.body);
        this.bullet = new Polygon();
        this.bullet.getPoints().addAll((Object[])new Double[]{0.0, 0.0, 0.0, 10.0, 10.0, 5.0});
        this.bullet.setFill((Paint)Color.YELLOWGREEN);
        this.body.getChildren().add((Object)this.bullet);
        this.pt = new PathTransition();
        this.pt.setDuration(Duration.millis((double)this.hitTime));
        this.pt.setNode((Node)this.body);
        this.pt.setInterpolator(Interpolator.LINEAR);
        this.pt.setPath((Shape)this.fromTower.getProjectilePath());
        this.pt.setOrientation(PathTransition.OrientationType.ORTHOGONAL_TO_TANGENT);
        this.pt.play();
        this.pt.setOnFinished(e -> {
            m.damage(this.damage);
            projectiles.remove(this);
            Defence.projectileGroup.getChildren().remove((Object)this.body);
            PauseTransition pause = new PauseTransition();
            pause.setDuration(Duration.millis((double)this.reloadTime));
            pause.setOnFinished(ep -> t.setHasAmmo(true));
            pause.play();
        });
    }
}

