/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class GLFWvidmode
implements Pointer {
    public static final int SIZEOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int REDBITS;
    public static final int GREENBITS;
    public static final int BLUEBITS;
    public static final int REFRESHRATE;
    private final ByteBuffer struct;

    public GLFWvidmode() {
        this(GLFWvidmode.malloc());
    }

    public GLFWvidmode(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setWidth(int width) {
        GLFWvidmode.width(this.struct, width);
    }

    public void setHeight(int height) {
        GLFWvidmode.height(this.struct, height);
    }

    public void setRedBits(int redBits) {
        GLFWvidmode.redBits(this.struct, redBits);
    }

    public void setGreenBits(int greenBits) {
        GLFWvidmode.greenBits(this.struct, greenBits);
    }

    public void setBlueBits(int blueBits) {
        GLFWvidmode.blueBits(this.struct, blueBits);
    }

    public void setRefreshRate(int refreshRate) {
        GLFWvidmode.refreshRate(this.struct, refreshRate);
    }

    public int getWidth() {
        return GLFWvidmode.width(this.struct);
    }

    public int getHeight() {
        return GLFWvidmode.height(this.struct);
    }

    public int getRedBits() {
        return GLFWvidmode.redBits(this.struct);
    }

    public int getGreenBits() {
        return GLFWvidmode.greenBits(this.struct);
    }

    public int getBlueBits() {
        return GLFWvidmode.blueBits(this.struct);
    }

    public int getRefreshRate() {
        return GLFWvidmode.refreshRate(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int width, int height, int redBits, int greenBits, int blueBits, int refreshRate) {
        ByteBuffer glfwvidmode = GLFWvidmode.malloc();
        GLFWvidmode.width(glfwvidmode, width);
        GLFWvidmode.height(glfwvidmode, height);
        GLFWvidmode.redBits(glfwvidmode, redBits);
        GLFWvidmode.greenBits(glfwvidmode, greenBits);
        GLFWvidmode.blueBits(glfwvidmode, blueBits);
        GLFWvidmode.refreshRate(glfwvidmode, refreshRate);
        return glfwvidmode;
    }

    public static void width(ByteBuffer glfwvidmode, int width) {
        glfwvidmode.putInt(glfwvidmode.position() + WIDTH, width);
    }

    public static void height(ByteBuffer glfwvidmode, int height) {
        glfwvidmode.putInt(glfwvidmode.position() + HEIGHT, height);
    }

    public static void redBits(ByteBuffer glfwvidmode, int redBits) {
        glfwvidmode.putInt(glfwvidmode.position() + REDBITS, redBits);
    }

    public static void greenBits(ByteBuffer glfwvidmode, int greenBits) {
        glfwvidmode.putInt(glfwvidmode.position() + GREENBITS, greenBits);
    }

    public static void blueBits(ByteBuffer glfwvidmode, int blueBits) {
        glfwvidmode.putInt(glfwvidmode.position() + BLUEBITS, blueBits);
    }

    public static void refreshRate(ByteBuffer glfwvidmode, int refreshRate) {
        glfwvidmode.putInt(glfwvidmode.position() + REFRESHRATE, refreshRate);
    }

    public static int width(ByteBuffer glfwvidmode) {
        return glfwvidmode.getInt(glfwvidmode.position() + WIDTH);
    }

    public static int height(ByteBuffer glfwvidmode) {
        return glfwvidmode.getInt(glfwvidmode.position() + HEIGHT);
    }

    public static int redBits(ByteBuffer glfwvidmode) {
        return glfwvidmode.getInt(glfwvidmode.position() + REDBITS);
    }

    public static int greenBits(ByteBuffer glfwvidmode) {
        return glfwvidmode.getInt(glfwvidmode.position() + GREENBITS);
    }

    public static int blueBits(ByteBuffer glfwvidmode) {
        return glfwvidmode.getInt(glfwvidmode.position() + BLUEBITS);
    }

    public static int refreshRate(ByteBuffer glfwvidmode) {
        return glfwvidmode.getInt(glfwvidmode.position() + REFRESHRATE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = GLFWvidmode.offsets(MemoryUtil.memAddress(offsets));
        WIDTH = offsets.get(0);
        HEIGHT = offsets.get(1);
        REDBITS = offsets.get(2);
        GREENBITS = offsets.get(3);
        BLUEBITS = offsets.get(4);
        REFRESHRATE = offsets.get(5);
    }
}

