/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL42;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBBaseInstance {
    public final long DrawArraysInstancedBaseInstance;
    public final long DrawElementsInstancedBaseInstance;
    public final long DrawElementsInstancedBaseVertexBaseInstance;

    public ARBBaseInstance(FunctionProvider provider) {
        this.DrawArraysInstancedBaseInstance = provider.getFunctionAddress("glDrawArraysInstancedBaseInstance");
        this.DrawElementsInstancedBaseInstance = provider.getFunctionAddress("glDrawElementsInstancedBaseInstance");
        this.DrawElementsInstancedBaseVertexBaseInstance = provider.getFunctionAddress("glDrawElementsInstancedBaseVertexBaseInstance");
    }

    public static ARBBaseInstance getInstance() {
        return GL.getCapabilities().__ARBBaseInstance;
    }

    static ARBBaseInstance create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_base_instance")) {
            return null;
        }
        ARBBaseInstance funcs = new ARBBaseInstance(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedBaseInstance, funcs.DrawElementsInstancedBaseInstance, funcs.DrawElementsInstancedBaseVertexBaseInstance);
        return GL.checkExtension("GL_ARB_base_instance", funcs, supported);
    }

    public static void glDrawArraysInstancedBaseInstance(int mode, int first, int count, int primcount, int baseinstance) {
        long __functionAddress = ARBBaseInstance.getInstance().DrawArraysInstancedBaseInstance;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL42.nglDrawArraysInstancedBaseInstance(mode, first, count, primcount, baseinstance, __functionAddress);
    }

    public static void nglDrawElementsInstancedBaseInstance(int mode, int count, int type, long indices, int primcount, int baseinstance) {
        long __functionAddress = ARBBaseInstance.getInstance().DrawElementsInstancedBaseInstance;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL42.nglDrawElementsInstancedBaseInstance(mode, count, type, indices, primcount, baseinstance, __functionAddress);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, int count, int type, ByteBuffer indices, int primcount, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count / GLChecks.typeToBytes(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, count, type, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, int count, int type, long indicesOffset, int primcount, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, count, type, indicesOffset, primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, int type, ByteBuffer indices, int primcount, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining() * GLChecks.typeToBytes(type), type, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, ByteBuffer indices, int primcount, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, ShortBuffer indices, int primcount, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void glDrawElementsInstancedBaseInstance(int mode, IntBuffer indices, int primcount, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseInstance(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, baseinstance);
    }

    public static void nglDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, long indices, int primcount, int basevertex, int baseinstance) {
        long __functionAddress = ARBBaseInstance.getInstance().DrawElementsInstancedBaseVertexBaseInstance;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL42.nglDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indices, primcount, basevertex, baseinstance, __functionAddress);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, ByteBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count / GLChecks.typeToBytes(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, long indicesOffset, int primcount, int basevertex, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, count, type, indicesOffset, primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int type, ByteBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining() * GLChecks.typeToBytes(type), type, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, ByteBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, ShortBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }

    public static void glDrawElementsInstancedBaseVertexBaseInstance(int mode, IntBuffer indices, int primcount, int basevertex, int baseinstance) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBBaseInstance.nglDrawElementsInstancedBaseVertexBaseInstance(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, basevertex, baseinstance);
    }
}

