/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class NVPointSprite {
    public static final int GL_POINT_SPRITE_NV = 34913;
    public static final int GL_COORD_REPLACE_NV = 34914;
    public static final int GL_POINT_SPRITE_R_MODE_NV = 34915;
    public final long PointParameteriNV;
    public final long PointParameterivNV;

    public NVPointSprite(FunctionProvider provider) {
        this.PointParameteriNV = provider.getFunctionAddress("glPointParameteriNV");
        this.PointParameterivNV = provider.getFunctionAddress("glPointParameterivNV");
    }

    public static NVPointSprite getInstance() {
        return GL.getCapabilities().__NVPointSprite;
    }

    static NVPointSprite create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_point_sprite")) {
            return null;
        }
        NVPointSprite funcs = new NVPointSprite(provider);
        boolean supported = Checks.checkFunctions(funcs.PointParameteriNV, funcs.PointParameterivNV);
        return GL.checkExtension("GL_NV_point_sprite", funcs, supported);
    }

    public static native void nglPointParameteriNV(int var0, int var1, long var2);

    public static void glPointParameteriNV(int pname, int param) {
        long __functionAddress = NVPointSprite.getInstance().PointParameteriNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVPointSprite.nglPointParameteriNV(pname, param, __functionAddress);
    }

    public static native void nglPointParameterivNV(int var0, long var1, long var3);

    public static void nglPointParameterivNV(int pname, long params) {
        long __functionAddress = NVPointSprite.getInstance().PointParameterivNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        NVPointSprite.nglPointParameterivNV(pname, params, __functionAddress);
    }

    public static void glPointParameterivNV(int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        NVPointSprite.nglPointParameterivNV(pname, MemoryUtil.memAddress(params));
    }

    public static void glPointParameterivNV(int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVPointSprite.nglPointParameterivNV(pname, MemoryUtil.memAddress(params));
    }
}

