/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class timespec
implements Pointer {
    public static final int SIZEOF;
    public static final int SEC;
    public static final int NSEC;
    private final ByteBuffer struct;

    public timespec() {
        this(timespec.malloc());
    }

    public timespec(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setSec(long sec) {
        timespec.sec(this.struct, sec);
    }

    public void setNsec(long nsec) {
        timespec.nsec(this.struct, nsec);
    }

    public long getSec() {
        return timespec.sec(this.struct);
    }

    public long getNsec() {
        return timespec.nsec(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long sec, long nsec) {
        ByteBuffer timespec2 = timespec.malloc();
        timespec.sec(timespec2, sec);
        timespec.nsec(timespec2, nsec);
        return timespec2;
    }

    public static void sec(ByteBuffer timespec2, long sec) {
        timespec2.putLong(timespec2.position() + SEC, sec);
    }

    public static void nsec(ByteBuffer timespec2, long nsec) {
        PointerBuffer.put(timespec2, timespec2.position() + NSEC, nsec);
    }

    public static long sec(ByteBuffer timespec2) {
        return timespec2.getLong(timespec2.position() + SEC);
    }

    public static long nsec(ByteBuffer timespec2) {
        return PointerBuffer.get(timespec2, timespec2.position() + NSEC);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = timespec.offsets(MemoryUtil.memAddress(offsets));
        SEC = offsets.get(0);
        NSEC = offsets.get(1);
    }
}

