/*
 * Decompiled with CFR 0.152.
 */
package render;

import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import render.Utilities;

public class GLSLProgram {
    public static final int VERTEX_ATTRIB = 0;
    public static final int UV_COORDS_ATTRIB = 1;
    public static final int NORMAL_COORDS_ATTRIB = 2;
    public static final int UV_COORDS_ATTRIB_2D = 1;
    private final int programID;
    private Map<String, Integer> locationCache = new HashMap<String, Integer>();

    public GLSLProgram(String vertex, String fragment) {
        this.programID = GLSLProgram.load(vertex, fragment);
    }

    public int getUniform(String name) {
        if (this.locationCache.containsKey(name)) {
            return this.locationCache.get(name);
        }
        int result = GL20.glGetUniformLocation(this.getProgramID(), name);
        if (result == -1) {
            System.err.println("Could not find uniform variable'" + name + "'!");
        } else {
            this.locationCache.put(name, result);
        }
        return GL20.glGetUniformLocation(this.getProgramID(), name);
    }

    public void setUniform1i(String name, int value) {
        GL20.glUniform1i(this.getUniform(name), value);
    }

    public void setUniform2f(String name, float x, float y) {
        GL20.glUniform2f(this.getUniform(name), x, y);
    }

    public void enable() {
        GL20.glUseProgram(this.getProgramID());
    }

    public void disable() {
        GL20.glUseProgram(0);
    }

    public void free() {
        GL20.glDeleteProgram(this.getProgramID());
    }

    public static int load(String vertPath, String fragPath) {
        String vert = Utilities.loadAsString(vertPath);
        String frag = Utilities.loadAsString(fragPath);
        String utils = Utilities.loadAsString("shaders/utils.oj");
        frag = frag.replaceAll("OJ_INCLUDE_UTILS", utils);
        int addedLines = utils.split("\n").length;
        int program = GL20.glCreateProgram();
        int vertID = GL20.glCreateShader(35633);
        int fragID = GL20.glCreateShader(35632);
        GL20.glShaderSource(vertID, (CharSequence)vert);
        GL20.glShaderSource(fragID, (CharSequence)frag);
        GL20.glCompileShader(vertID);
        if (GL20.glGetShaderi(vertID, 35713) == 0) {
            System.err.println("Failed to compile vertexd shader!");
            System.err.println(GL20.glGetShaderInfoLog(vertID));
        }
        GL20.glCompileShader(fragID);
        if (GL20.glGetShaderi(fragID, 35713) == 0) {
            System.err.println("Failed to compile fragment shader!");
            String err = GL20.glGetShaderInfoLog(fragID);
            System.err.println(err);
            System.out.println("Added lines: " + addedLines);
            throw new RuntimeException("Failed to compile fragment shader");
        }
        GL20.glAttachShader(program, vertID);
        GL20.glAttachShader(program, fragID);
        GL20.glLinkProgram(program);
        GL20.glValidateProgram(program);
        GL20.glDetachShader(program, vertID);
        GL20.glDetachShader(program, fragID);
        GL20.glDeleteShader(vertID);
        GL20.glDeleteShader(fragID);
        System.out.println("Error: " + GL11.glGetError());
        return program;
    }

    public int getProgramID() {
        return this.programID;
    }
}

