/*
 * Decompiled with CFR 0.152.
 */
package render;

import game.Game;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.vecmath.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWvidmode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import render.FBO;
import render.Fonts;
import render.GLSLProgram;
import render.InputHandler;
import render.Settings;
import render.Texture;
import sound.Sound;

public class Renderer {
    private GLFWErrorCallback errorCallback;
    private GLFWKeyCallback keyCallback;
    private long window;
    private int vertexCount;
    private int vaoId;
    private int vboId;
    private InputHandler input;
    private GLSLProgram shader;
    private GLSLProgram textureShader;
    private long tick;
    private Texture noise;
    private Texture ui;
    private FBO fbo;
    private int windowWidth = 1280;
    private int windowHeight = 720;
    private int fboWidth = this.windowWidth / 4;
    private int fboHeight = this.windowHeight / 4;
    private Game game;
    private final int uiImgSize = 512;
    private Settings settings;
    private Sound sound;

    public Renderer(Settings s) {
        this.settings = s;
        this.windowWidth = s.resolution.width;
        this.windowHeight = s.resolution.height;
        this.fboWidth = (int)((double)this.windowWidth * s.resolutionModifier);
        this.fboHeight = (int)((double)this.windowHeight * s.resolutionModifier);
        this.sound = new Sound(this.settings.volume);
    }

    public void run() {
        try {
            try {
                this.init();
                this.loop();
                GLFW.glfwDestroyWindow(this.window);
                this.keyCallback.release();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.shader.free();
                this.textureShader.free();
                this.noise.free();
                this.fbo.free();
                GL15.glBindBuffer(34962, 0);
                GL15.glDeleteBuffers(this.vboId);
                GL30.glBindVertexArray(0);
                GL30.glDeleteVertexArrays(this.vaoId);
                GLFW.glfwTerminate();
                this.errorCallback.release();
            }
        }
        finally {
            this.shader.free();
            this.textureShader.free();
            this.noise.free();
            this.fbo.free();
            GL15.glBindBuffer(34962, 0);
            GL15.glDeleteBuffers(this.vboId);
            GL30.glBindVertexArray(0);
            GL30.glDeleteVertexArrays(this.vaoId);
            GLFW.glfwTerminate();
            this.errorCallback.release();
        }
    }

    private void init() {
        this.errorCallback = Callbacks.errorCallbackPrint(System.err);
        GLFW.glfwSetErrorCallback(this.errorCallback);
        if (GLFW.glfwInit() != 1) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 0);
        this.window = GLFW.glfwCreateWindow(this.windowWidth, this.windowHeight, "Scrubber", this.settings.fullscreen ? GLFW.glfwGetPrimaryMonitor() : 0L, 0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        if (this.settings.fullscreen) {
            GLFW.glfwSetInputMode(this.window, 208897, 212994);
        }
        ByteBuffer vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        if (!this.settings.fullscreen) {
            GLFW.glfwSetWindowPos(this.window, (GLFWvidmode.width(vidmode) - this.windowWidth) / 2, (GLFWvidmode.height(vidmode) - this.windowHeight) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.window);
        GLFW.glfwSwapInterval(0);
        GLFW.glfwShowWindow(this.window);
        GLContext.createFromCurrent();
        this.setupQuad();
        this.shader = new GLSLProgram("shaders/vertex.vert", "shaders/fragment.frag");
        this.textureShader = new GLSLProgram("shaders/vertex.vert", "shaders/textureRender.frag");
        this.tick = 0L;
        this.noise = Texture.getTexture("noise.png");
        this.ui = new Texture(new BufferedImage(512, 512, 2));
        this.fbo = new FBO(this.fboWidth, this.fboHeight, true);
        this.keyCallback = new InputHandler();
        GLFW.glfwSetKeyCallback(this.window, this.keyCallback);
        this.errorCallback = Callbacks.errorCallbackPrint(System.err);
        GLFW.glfwSetErrorCallback(this.errorCallback);
        this.game = new Game(this.noise, this.window, this.sound, this);
    }

    public void setupQuad() {
        float[] vertices = new float[]{-1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f};
        FloatBuffer verticesBuffer = BufferUtils.createFloatBuffer(vertices.length);
        verticesBuffer.put(vertices);
        verticesBuffer.flip();
        this.vertexCount = 6;
        this.vaoId = GL30.glGenVertexArrays();
        GL30.glBindVertexArray(this.vaoId);
        GL20.glEnableVertexAttribArray(0);
        this.vboId = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, this.vboId);
        GL15.glBufferData(34962, verticesBuffer, 35044);
        GL20.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        GL15.glBindBuffer(34962, 0);
        GL30.glBindVertexArray(0);
    }

    private void loop() {
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        int tickID = GL20.glGetUniformLocation(this.shader.getProgramID(), "tick");
        int playerPosID = GL20.glGetUniformLocation(this.shader.getProgramID(), "playerPos");
        int positionsID = GL20.glGetUniformLocation(this.shader.getProgramID(), "positions");
        int playerForwardID = GL20.glGetUniformLocation(this.shader.getProgramID(), "playerForward");
        int playerUpID = GL20.glGetUniformLocation(this.shader.getProgramID(), "playerUp");
        int forwardsID = GL20.glGetUniformLocation(this.shader.getProgramID(), "forwards");
        int upsID = GL20.glGetUniformLocation(this.shader.getProgramID(), "ups");
        int entitiesID = GL20.glGetUniformLocation(this.shader.getProgramID(), "entities");
        int numEntitiesID = GL20.glGetUniformLocation(this.shader.getProgramID(), "numEntities");
        int nextNodePosID = GL20.glGetUniformLocation(this.shader.getProgramID(), "nextNodePos");
        int playerSpeedID = GL20.glGetUniformLocation(this.shader.getProgramID(), "playerSpeed");
        int rollVelID = GL20.glGetUniformLocation(this.shader.getProgramID(), "rollVel");
        int pitchVelID = GL20.glGetUniformLocation(this.shader.getProgramID(), "pitchVel");
        int yawVelID = GL20.glGetUniformLocation(this.shader.getProgramID(), "yawVel");
        int batteryID = GL20.glGetUniformLocation(this.shader.getProgramID(), "battery");
        int windowSizeIDFrag = GL20.glGetUniformLocation(this.shader.getProgramID(), "windowSize");
        int shakeID = GL20.glGetUniformLocation(this.shader.getProgramID(), "shake");
        int shakeTickID = GL20.glGetUniformLocation(this.shader.getProgramID(), "shakeTick");
        int texLoc = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "tex");
        int uiLoc = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "ui");
        int noisePLoc = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "noiseP");
        int windowSizeID = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "windowSize");
        int uiImgSizeID = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "uiImgSize");
        int radioDisID = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "radioDis");
        int nodeTakenID = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "nodeTakenTick");
        int tickID2 = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "tick");
        int gameOverID = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "gameOver");
        long start = System.nanoTime();
        double frameTime = 0.0;
        double fps = -1.0;
        boolean gameOver = false;
        while (GLFW.glfwWindowShouldClose(this.window) == 0) {
            long t0 = System.nanoTime();
            float elapsed = (float)((double)(System.nanoTime() - start) / 1.0E9);
            InputHandler.update();
            GLFW.glfwPollEvents();
            if (!gameOver) {
                gameOver |= this.game.update(this.window, elapsed);
            } else {
                this.sound.stopMusic();
                if (InputHandler.down(256)) {
                    GLFW.glfwSetWindowShouldClose(this.window, 1);
                }
                if (InputHandler.down(257)) {
                    gameOver = false;
                    this.game = new Game(this.noise, this.window, this.sound, this);
                }
            }
            BufferedImage uiImg = new BufferedImage(512, 512, 2);
            Graphics2D g = (Graphics2D)uiImg.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
            g.setFont(Fonts.mainFont30);
            g.setColor(new Color(0, 0, 255, 0));
            g.fillRect(0, 0, uiImg.getWidth(), uiImg.getHeight());
            g.setColor(Color.WHITE);
            g.drawString("Score: " + this.game.getPlayer().getScore(), 50, 50);
            int p = (int)(100.0f * this.game.getPlayer().getBattery());
            g.drawString("Battery: " + p + "%", 50, 100);
            Vector3f disv = new Vector3f(this.game.getPlayerPos());
            disv.sub(this.game.getNextNodePos());
            float dis = disv.length();
            g.drawString("Geiger: " + (int)dis, 50, 150);
            if (gameOver) {
                g.drawString("GAME OVER", 50, 200);
                g.drawString("Press Enter to Restart", 50, 250);
            }
            g.dispose();
            this.ui.changeImage(uiImg);
            GL13.glActiveTexture(33984);
            GL11.glBindTexture(3553, this.noise.textureID);
            GL30.glBindFramebuffer(36160, this.fbo.fbo);
            GL11.glViewport(0, 0, this.fbo.width, this.fbo.height);
            GL11.glClear(16640);
            this.shader.enable();
            GL20.glUniform1f(tickID, elapsed);
            Vector3f camPos = this.game.getPlayerPos();
            Vector3f forward = this.game.getPlayer().getForward();
            Vector3f up = this.game.getPlayer().getUp();
            float rollVel = this.game.getPlayer().getRollVel();
            float pitchVel = this.game.getPlayer().getPitchVel();
            float yawVel = this.game.getPlayer().getYawVel();
            GL20.glUniform1f(rollVelID, rollVel);
            GL20.glUniform1f(pitchVelID, pitchVel);
            GL20.glUniform1f(yawVelID, yawVel);
            GL20.glUniform1f(batteryID, this.game.getPlayer().getBattery());
            Vector3f nextNodePos = this.game.getNextNodePos();
            GL20.glUniform3f(nextNodePosID, nextNodePos.x, nextNodePos.y, nextNodePos.z);
            float playerSpeed = this.game.getPlayerSpeed();
            GL20.glUniform1f(playerSpeedID, playerSpeed);
            GL20.glUniform3f(playerPosID, camPos.x, camPos.y, camPos.z);
            GL20.glUniform3f(playerForwardID, forward.x, forward.y, forward.z);
            GL20.glUniform3f(playerUpID, up.x, up.y, up.z);
            GL20.glUniform2f(windowSizeIDFrag, this.windowWidth, this.windowHeight);
            GL20.glUniform1f(shakeID, this.game.getPlayer().getShake());
            GL20.glUniform1f(shakeTickID, this.game.getPlayer().getShakeTick());
            GL30.glBindVertexArray(this.vaoId);
            GL11.glDrawArrays(4, 0, this.vertexCount);
            GL30.glBindVertexArray(0);
            this.shader.disable();
            GL13.glActiveTexture(33984);
            GL11.glBindTexture(3553, this.fbo.textureID);
            GL13.glActiveTexture(33985);
            GL11.glBindTexture(3553, this.ui.textureID);
            GL13.glActiveTexture(33986);
            GL11.glBindTexture(3553, this.noise.textureID);
            GL30.glBindFramebuffer(36160, 0);
            GL11.glViewport(0, 0, this.windowWidth, this.windowHeight);
            this.textureShader.enable();
            GL20.glUniform1i(texLoc, 0);
            GL20.glUniform1i(uiLoc, 1);
            GL20.glUniform1i(noisePLoc, 2);
            GL20.glUniform2f(windowSizeID, this.windowWidth, this.windowHeight);
            GL20.glUniform1f(uiImgSizeID, 512.0f);
            GL20.glUniform1f(radioDisID, this.game.getRadioDis());
            GL20.glUniform1f(nodeTakenID, this.game.getPlayer().getNodeTakenTick());
            GL20.glUniform1f(tickID2, elapsed);
            GL20.glUniform1f(gameOverID, gameOver ? 1.0f : 0.0f);
            GL30.glBindVertexArray(this.vaoId);
            GL11.glDrawArrays(4, 0, this.vertexCount);
            GL30.glBindVertexArray(0);
            this.textureShader.disable();
            GL11.glBindTexture(3553, 0);
            GLFW.glfwSwapBuffers(this.window);
            ++this.tick;
            frameTime = (double)(System.nanoTime() - t0) / 1.0E9;
            if (frameTime * 1000.0 < 33.33) {
                try {
                    Thread.sleep((long)(33.33 - frameTime * 1000.0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            fps = 1000.0 / ((double)(System.nanoTime() - t0) / 1000000.0);
        }
        GL11.glBindTexture(3553, 0);
        System.exit(0);
    }
}

