#version 330

in vec2 fragCoord;
out vec4 fragColor;

uniform sampler2D tex;
uniform sampler2D ui;
uniform sampler2D noiseP;
uniform vec2 windowSize;
uniform float uiImgSize;
uniform float radioDis;
uniform float tick;
uniform float nodeTakenTick;
uniform float gameOver;

vec3 laplacian(vec3 center, vec3 up, vec3 down, vec3 right, vec3 left)
{
	return 4*center -up - left - right - down;
}


vec3 gaussblur(vec3 a, vec3 b, vec3 c, vec3 d, vec3 e, vec3 f, vec3 g, vec3 h, vec3 i)
{
	float k2 = 1/24.0;//
	float k1 = 16*k2;
	return k1*a + k2*(b + c + d + e + f + g + h + i);
}


vec3 blur(vec3 center, vec3 up, vec3 down, vec3 right, vec3 left)
{
	return 0.333*center + 0.166*up + 0.166*left + 0.166*right + 0.166*down;
}

vec3 sharpen(vec3 center, vec3 up, vec3 down, vec3 right, vec3 left)
{
	return 5*center -up - left - right - down;
}

void main()
{	
	
	float xd = 0.5/640.0;
	float yd = 0.5/360.0;
	vec2 uv = 0.5*(fragCoord + vec2(1));
	
	float uvx = uv.x/uiImgSize*windowSize.x;
	float uvy = uv.y/uiImgSize*windowSize.y;
	uvy = 1-uvy + (windowSize.y - uiImgSize) / uiImgSize; 
	vec4 uiCol = texture(ui, vec2(uvx, uvy));
	
	
	vec3 center = texture(tex, uv).xyz;
	vec3 up = texture(tex, vec2(uv.x, uv.y + yd)).xyz; 
	vec3 left = texture(tex, vec2(uv.x - xd, uv.y)).xyz; 
	vec3 right = texture(tex, vec2(uv.x + xd, uv.y)).xyz; 
	vec3 down = texture(tex, vec2(uv.x, uv.y - yd)).xyz; 
	
	vec3 upLeft = texture(tex, vec2(uv.x - xd, uv.y + yd)).xyz;
	vec3 upRight = texture(tex, vec2(uv.x + xd, uv.y + yd)).xyz;
	vec3 downLeft = texture(tex, vec2(uv.x - xd, uv.y - yd)).xyz;
	vec3 downRight = texture(tex, vec2(uv.x + xd, uv.y - yd)).xyz;
	
	vec3 shar = sharpen(center, up, down, right, left);
	vec3 blu = blur(center, up, down, right, left);
	vec3 lapl = laplacian(center, up, down, right, left);
    
    //fragColor = vec4(center, 1.0) * (1 - 0.6*length(laplacian(center, up, down, right ,left)));
    //fragColor = vec4(vec3(length(laplacian(center, up, down, right ,left))), 1.0);
    //fragColor = vec4(mix(shar, blu, 0.9), 1.0);
  	//fragColor = vec4(shar, 1.0);
  	
  	/*if (texture(noiseP, vec2(uvx, uvy)).x - 0.5 >  smoothstep(50, 200, radioDis * 100)*smoothstep(nodeTakenTick-0.8, nodeTakenTick + 0.8, tick)) {
	  	fragColor = vec4(1-center, 1.0);
  	} else {
	  	fragColor = vec4(center, 1.0);
  	}*/
  	
	  	fragColor = vec4(center, 1.0);
  	//fragColor = vec4( mix(center, 1-center, 1- smoothstep(0, 30, radioDis)), 1.0);
  	//fragColor = vec4(center, 1.0);
  //	float rd = 2 - 2*smoothstep(0, 50, radioDis)*smoothstep(nodeTakenTick-0.8, nodeTakenTick + 0.8, tick);
  //	fragColor = vec4((1 + clamp(rd, 0, 2))*(center -0.5) + 0.5,1.0);
  	//fragColor = vec4((1 + rd)*(mix(center, lapl, rd)-0.5)+0.5 ,1.0);
  	 //fragColor = vec4(gaussblur(center, up, left, right, down , upLeft, upRight, downLeft, downRight), 1.0);
	if (gameOver != 0.0) {
		float g = fragColor.x + fragColor.y + fragColor.z;
		fragColor = vec4(g/3, g/3, g/3, 1.0);
	} 
	if (uvx < 1 && uvy < 1) { //&& uvx > -1 && uvx < 1 && uvy > -1 && uvy < 1
		fragColor = vec4(mix(fragColor, uiCol, uiCol.a).rgb, 1.0);
	} 
}

