//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
CLR0_1	EQU	1
CLR1_1	EQU	4
PAGE_SWAP_HL	EQU	#171F
;-------
BCLR0A	EQU	0
BCLR0B	EQU	0
;-
BCLR1A	EQU	5
BCLR1B	EQU	1
;-
BCLR2A	EQU	5
BCLR2B	EQU	1
;-
BCLR3A	EQU	7
BCLR3B	EQU	0
;-------
SCLR11A	EQU	2
SCLR11B	EQU	0
;-
SCLR12A	EQU	2
SCLR12B	EQU	6
;-
SCLR13A	EQU	2
SCLR13B	EQU	7
;-
SCLR14A	EQU	6
SCLR14B	EQU	7
;-
SCLR15A	EQU	7
SCLR15B	EQU	7
;-------
SCLR21A	EQU	2
SCLR21B	EQU	0
;-
SCLR22A	EQU	2
SCLR22B	EQU	6
;-
SCLR23A	EQU	2
SCLR23B	EQU	7
;-
SCLR24A	EQU	6
SCLR24B	EQU	7
;-
SCLR25A	EQU	7
SCLR25B	EQU	7

SCR_ADR	EQU	#D800
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	LD	A,#17
	CALL	PAGER
	LD	A,7
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),7*8+7
	LDIR
	
	;---
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,6143
	LD	(HL),#0F
	LDIR
	;---
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR
	;---
	AND	A
	RET	C
	RET	C
	;RET	C
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	XOR	A
	OUT	(#FE),A

	LD	A,98
	DEC	A
	JP	NZ,$-1
	RET NZ:DEC BC

	CALL	TRUBA
	CALL	SWAP

	AND	A
	RET	C
	RET	C
	;RET	C
	RET
//======================================================== FX_PROCEDURES
TRUBA	LD	(SOHRSP1),SP
	;---
	LD	SP,FRAME1A
FRAME_ADR EQU	$-2
	;---
	LD	HL,#5800
	POP BC:LD A,C:ADD A,A:ADD A,A:ADD A,A:LD D,A:ADD A,C:LD E,A:LD A,D:ADD A,B:LD D,A:LD A,B:ADD A,A:ADD A,A:ADD A,A:ADD A,B:LD B,A:AND HX:ADD A,C:LD C,A:LD (HL),E:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),E:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),B:INC L:LD (HL),E
	LD	HL,SCR_ADR
	;---
	EXX
	;---
	LD	BC,#7FFE
	LD	HL,PAGE_SWAP_HL
	POP	DE
	LD	A,3
	LD	LX,3
	LD	HX,7*8
	AND	A
	;---
	INCLUDE	"generated/out_code_all.asm"
	;---
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;-----------------------
SWAP	LD	A,0
	XOR	#FF
	LD	(SWAP+1),A
	JP	Z,SWAP_A
SWAP_B	;---
	LD	DE,FRAME_TBL_B
	JP	SWAP0
SWAP_A	;---
	LD	DE,FRAME_TBL_A
	JP	SWAP0
SWAP0	;---
	LD	HL,0
ALPHA	EQU	$-2
	LD	BC,#00C3	;#0186
	ADD	HL,BC
	LD	(ALPHA),HL
	LD	L,H
	LD	H,ROTTBL/256
	LD	A,(HL)
	ADD	A,A
	LD	L,A
	LD	H,0
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(FRAME_ADR),DE
	RET
//======================================================== FX_TABLES
FRAME_TBL_A
	DW	FRAME1A
	DW	FRAME2A
	DW	FRAME3A
	DW	FRAME4A
	DW	FRAME5A
	DW	FRAME6A
	DW	FRAME7A
	DW	FRAME8A
	DW	FRAME9A
	DW	FRAME10A
	DW	FRAME11A
	DW	FRAME12A
	DW	FRAME13A
	DW	FRAME14A
	DW	FRAME15A
	DW	FRAME16A
FRAME_TBL_B	
	DW	FRAME1B
	DW	FRAME2B
	DW	FRAME3B
	DW	FRAME4B
	DW	FRAME5B
	DW	FRAME6B
	DW	FRAME7B
	DW	FRAME8B
	DW	FRAME9B
	DW	FRAME10B
	DW	FRAME11B
	DW	FRAME12B
	DW	FRAME13B
	DW	FRAME14B
	DW	FRAME15B
	DW	FRAME16B
	
	ORG	(($+255)/256)*256
ROTTBL	INCBIN	"generated/rotate_tbl.bin"