
// FX HEADER
//========================================================
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//========================================================
// FX CONST
//========================================================
CLR0	EQU	3	;-+
CLR1	EQU	6	;--  
CLRP	EQU	1	;   


UPFREE	EQU	8
//========================================================
// FX INIT
//========================================================
EFF_INI_
	EI
	HALT

	LD	A,#17+8
	CALL	PAGER
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),CLRP
	LDIR
	LD	HL,#5800
	LD	DE,#D800
	LD	BC,768
	LDIR

	LD	HL,SCR+32*8
	LD	DE,#4000
	LD	LX,192-8

LL1	PUSH	DE
	DUP	32
	LDI
	EDUP
	POP DE
	CALL	DOWNDE
	DEC	LX
	JP	NZ,LL1

	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR

	CALL	INITBL
	CALL	INIBOARD
	CALL	Y_CORR

	LD	HL,COS053
	LD	B,0
CORCOS	LD	A,(HL)
	CP	53
	JP	C,$+5
	LD	A,53
	LD	(HL),A
	INC	L
	DJNZ	CORCOS

	LD	IY,0
	CALL	INTCORR
	RET

DOWNDE	INC	D
	LD	A,D
	AND	7
	RET	NZ
	LD	A,E
	ADD	A,#20
	LD	E,A
	RET	C
	LD	A,D
	SUB	8
	LD	D,A
	RET


//------
;CNT0 - up_free+1
;CNT1 - up_border+1
;CNT2 - paper->
;CNT3 - dw_border
;JPADR0 -    

;47 ->48 only border down

INITBL	LD	HL,YTBL
	LD	LX,8
	LD	B,1
	LD	C,1
	LD	E,-1
INIt01	;--
	LD (HL),B:INC L:LD (HL),C:INC L
	LD (HL),E:INC L
	LD A,C:ADD A,8:LD C,A
	DEC	LX
	JP	NZ,INIt01
	;--
	LD	LX,8
INIt02	;--
	LD (HL),B:INC L:LD (HL),C:INC L
	LD (HL),E:INC L
	LD A,E:ADD A,8:LD E,A
	DEC	LX
	JP	NZ,INIt02
	;--
	LD	LX,8
INIt03	;--
	LD (HL),B:INC L
	LD (HL),C:INC L
	LD (HL),E:INC L
	LD A,B:ADD A,4:LD B,A
	LD A,C:SUB 8:LD C,A
	LD A,E:ADD A,8:LD E,A
	DEC	LX
	JP	NZ,INIt03
	;--
	LD	LX,8
INIt04	;--
	LD (HL),B:INC L
	LD (HL),C:INC L
	LD (HL),E:INC L
	LD A,B:ADD A,4:LD B,A
	DEC	LX
	JP	NZ,INIt04
	;--
	LD	LX,16
	;--
INIt05	LD (HL),B:INC L
	LD (HL),C:INC L
	LD (HL),E:INC L
	LD A,B:ADD A,4:LD B,A
	LD A,E:SUB 8:LD E,A
	DEC	LX
	JP	NZ,INIt05

	LD	LX,10
	;--
INIt06	LD (HL),B:INC L
	LD (HL),C:INC L
	LD (HL),E:INC L
	LD A,B:ADD A,4:LD B,A
	DEC	LX
	JP	NZ,INIt06
	;--
	;--------------- 
	LD	HL,YTBL+256
	LD	BC,C_RET
	LD	E,0
	LD	LX,9
	;--
INIt20	LD (HL),E:INC L
	LD (HL),B:INC L:LD (HL),C:INC L
	DEC	LX
	JP	NZ,INIt20
	;--
	LD	LX,7
	LD	BC,C_PAP
	;--
INIt21	LD (HL),E:INC L
	LD (HL),B:INC L:LD (HL),C:INC L
	DEC	LX
	JP	NZ,INIt21
	;--
	LD	BC,C_PAP
	LD	LX,8+8
	;--
INIt22	LD (HL),E:INC L
	LD (HL),B:INC L:LD (HL),C:INC L
	DEC	LX
	JP	NZ,INIt22
	;--
	LD	LX,5
	;--
INIt23	LD (HL),E:INC L
	LD (HL),B:INC L:LD (HL),C:INC L
	LD A,E:ADD A,8:LD E,A
	DEC	LX
	JP	NZ,INIt23
	;--
	LD	LX,11
	;--
INIt24	LD (HL),E:INC L
	LD (HL),B:INC L:LD (HL),C:INC L
	DEC	LX
	JP	NZ,INIt24
	;--
	LD	LX,5
	LD	BC,C_BDW_L
	;--
INIt25	LD (HL),E:INC L
	LD (HL),B:INC L:LD (HL),C:INC L
	LD A,E:SUB 8:LD E,A
	DEC	LX
	JP	NZ,INIt25
	;--
	LD	BC,C_RET
	LD (HL),E:INC L
	LD (HL),B:INC L:LD (HL),C:INC L


	;------------------
	LD	HL,YTBL+512
	LD	DE,128*2
	LD	B,0
	LD	LX,16
	;--
INIt30	LD (HL),B:INC L
	LD (HL),E:INC L:LD (HL),D:INC L
	PUSH	HL
	LD	HL,0-2*8
	ADD	HL,DE
	LD D,H:LD E,L
	POP	HL
	DEC	LX
	JP	NZ,INIt30
	;--
	LD	LX,48
	;--
INIt31	LD (HL),B:INC L
	LD (HL),E:INC L:LD (HL),D:INC L
	DEC	LX
	JP	NZ,INIt31



	//-------------------
	RET
//------
INIBOARD
	LD	HL,B_TBL
	LD	IX,MAPZX
	LD	LY,16
INI4	;--
	LD	C,8*2
INI3	LD	A,(IX)
	INC	IX
	LD	B,8
INI2	RLA
	LD	DE,CLR0*256+CLR1
	JP	C,INI1
	LD	DE,CLR1*256+CLR0
INI1	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	DJNZ	INI2
	DEC	C
	JP	NZ,INI3
	;--
	DEC	LY
	JP	NZ,INI4
	;--------------- ini attr board
	LD	HL,#5860
	LD	DE,#5868
	DUP 4:LD (HL),CLR0*8+CLRP:INC HL:EDUP
	DUP 4:LD (HL),CLR1*8+CLRP:INC HL:EDUP
	LD	L,#60
	LD	BC,32*16-8
	LDIR
	LD	HL,#D860
	LD	DE,#D868
	DUP 4:LD (HL),CLR1*8+CLRP:INC HL:EDUP
	DUP 4:LD (HL),CLR0*8+CLRP:INC HL:EDUP	;CLR0!!!!
	LD	L,#60
	LD	BC,32*16-8
	LDIR	
	;--------------------
	RET
//========================================================
// FX MAINLOOP
//========================================================
EFF_RUN_
	EI
	HALT
	;--
	LD	BC,90-10-3-1-2-1-1
W0	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W0
	NOP:NOP:LD A,R

	;--
	LD	A,0	;7 /7
CNT0	EQU	$-1
	;--
UP0	DEC	A	;4
	JP	Z,UP_1	;10 /14
	;--------------- 424
	NOP		;4
	LD	B,29	;7
	LD	B,29	;7
	DEC	B	;4
	JP	NZ,$-1	;10
	;--
	JP	UP0	;10



UP_1	;------------------

	CALL BORDER_UP

	;-- next step
	LD	HL,(XXXX0)
	LD	DE,64*4
	ADD	HL,DE
	LD	(XXXX0),HL
	;--
	LD	A,16
XCNT	EQU	$-1
	DEC	A
	JP	NZ,XCNT1
	LD	HL,B_TBL	;10
	LD	(XXXX0),HL	;16
	LD	A,16
	LD	A,16
XCNT1	LD	(XCNT),A


	;---------------
	LD	DE,64*2-UPFREE*8*2
	ADD	HL,DE
	LD	A,(HL)
	CP	CLR0
	JP	Z,NS1
	LD	A,#17+8
	JP	NS0
NS1	LD	A,#17
	JP	NS0
NS0	LD	BC,#7FFD
	CALL	PAGER
;----------------------- correct params for output
	;37-vertical 8x_Size
	;board=16 size
	;-16	- only border up
	;0..37	- border+pap+border
	;+16	- only border down //69 positions
;---------------------------------------------------------
	CALL	Y_CORR
	;---------- 4t correct
	SCF
	RET	NC
	;RET	NC	
	;RET	NC



	LD	A,0	;7
	IN	A,(#FE)	;11
	DEC	HL	;6
	BIT	0,A	;8
	JP	Z,xUP	;10
	DEC	HL	;6
	BIT	1,A	;8
	JP	Z,xDW	;10
	;--

	LD	HL,0
CADR1	EQU	$-2
	LD	DE,#0130
	ADD	HL,DE
	LD	(CADR1),HL
	LD	L,H
	LD	H,COS053/256
	LD	A,(HL)
	LD	A,R
	LD	A,27
	LD	(YPOS),A
	;--
	RET



xUP	LD	HL,YPOS	;10
	LD	A,R	;9
	LD	A,(HL)	;7
	OR	A	;4
	JP	Z,xxRET	;10
	;--
	DEC	(HL)	;7
	LD	A,R	;9
	RET

xDW	DEC	HL	;6
	LD	HL,YPOS	;10
	LD	A,(HL)	;7
	CP	53	;7	
	JP	Z,xxRET	;10
	INC	(HL)	;7
	LD	A,R	;9
	RET






xxRET	RET

//--------------------------------------
;CNT0 - up_free+1
;CNT1 - uplines+1
;CNT1 - paplines	->
;JPADR0 -    
Y_CORR	LD	A,0	//0..53
YPOS	EQU	$-1
	LD	L,A
	ADD	A,A
	ADD	A,L
	LD	L,A	;pos*3
	LD	H,YTBL/256
	;--
	LD A,(HL):LD (CNT0),A:INC L
	LD A,(HL):LD (CNT1),A:INC L
	LD A,(HL):LD (CNT2),A:INC H
	LD E,(HL):DEC L:LD D,(HL):DEC L:LD (JPADR0),DE
	LD A,(HL):INC H:LD D,(HL):INC L:LD (CNT3),A
	LD E,(HL):INC L:LD D,(HL):LD (XXXX1),DE

	RET


CADR0	DW	0
//------------------------------------------
BORDER_UP
	;----------------- BORDER_UP
	LD	(SOHRSP1),SP
	;--
	LD	IY,0	;14
CNT2	EQU	$-2
CNT3	EQU	$-1
	LD	BC,#7FFD ;10
	EXX		;4
	;--
	LD	BC,#00FE
	LD	IX,C_BUP ;14
	LD	A,64+1-8*UPFREE
CNT1	EQU	$-1

	LD	HL,B_TBL ;10
XXXX0	EQU	$-2
	LD	DE,0	;10
XXXX1	EQU	$-2
	ADD	HL,DE	;11
	LD	SP,HL	;6
	;----------------
C_BUP	DEC	A	;4
	JP	Z,C_PAP	;10
JPADR0	EQU	$-2
	;--
	POP	DE	;10
	;--
	DUP	6
	OUT (C),E:NOP:OUT (C),D:NOP ;32
	EDUP
	;--
	JP	(IX)	;8
;----------------------------------- //paper
C_PAP	POP	DE	;10
	OUT (C),E:NOP:OUT (C),D	;28
	;--pause 94
	LD	A,5	
	DEC	A
	JP	NZ,$-1
	;--
	POP	AF	;10
	PUSH	AF	;11
	CP	CLR0	;7
	JP	Z,C_PAP1 ;10
	LD	A,#17	;7
	JP	C_PAP0	;10 /38
C_PAP1	LD	A,#17+8	;7 -
	JP	C_PAP0	;10 -
C_PAP0	;--
	OUT (C),E:NOP:OUT (C),D	;28
	;--
	EXX		;4
	OUT	(C),A	;12
	EXX		;4
	NOP		;4 /24
	;--------------------------
C_PAP_L	POP	DE	;10
	OUT (C),E:DEC HL:OUT (C),D	;28
	;--pause 94
	LD	A,3	
	DEC	A
	JP	NZ,$-1
	LD	HL,C_PAP_L ;10
	;--
	DEC	LY	;8
	JP	Z,C_PAP_E ;10 /18
	;--
	POP	AF	;10
	PUSH	AF	;11
	CP	CLR0	;7
	JP	Z,C_PAP1x ;10
	LD	A,#17	;7
	JP	C_PAP0x	;10 /38
C_PAP1x	LD	A,#17+8	;7 -
	JP	C_PAP0x	;10 -
C_PAP0x	;--
	OUT (C),E:NOP:OUT (C),D	;28
	;--
	EXX		;4
	OUT	(C),A	;12
	EXX		;4  /20
	;--
	JP	(HL)	;4
C_PAP_E	;--------------------------
	;pause_55
	LD	A,3	;7	48
	DEC	A	;4
	JP	NZ,$-1	;10
	DEC	HL	;6
	;--
	OUT (C),E:NOP:OUT (C),D	;28
	;-- 26free
	NOP
	LD	A,HY	;8
	OR	A	;4
	JP	Z,C_RET	;10
C_BDW_L	;-----------------   
	POP	DE	;10
	;--
	DUP	6
	OUT (C),E:NOP:OUT (C),D:NOP ;32
	EDUP
	;--
	XOR	A	;4
	DEC	HY	;8
	JP	NZ,C_BDW_L ;10
;-----------------------------------
C_RET	OUT	(C),A
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
//----------------------------------
MAPZX	INCBIN	"mapzx3.bin"
	ORG	(($/256)+1)*256
COS053	INCBIN "cos0-54.bin"
YTBL	DS	768,0
//-----------------------
	ORG	(($/256)+1)*256
B_TBL	//-----------
	ORG	YTBL
SCR	INCBIN	"demarche.out"