// FX HEADER
//========================================================
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//========================================================
// FX CONST
//========================================================
COLOR1	EQU	6
COLOR2	EQU	3

;Change rotate direction
;LD (R_DIR_TBL), ROT_R_TBL or ROT_L_TBL
//========================================================
// FX INIT
//========================================================
EFF_INI_
	XOR	A
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),L
	LDIR

	LD	HL,RGBADD
	LD	DE,RGBADD+1
	LD	(HL),C
	LD	BC,255
	LDIR

	LD	HL,RGBADD+128
	LD	DE,RGBADD+129
	LD	(HL),C
	LD	BC,127
	LDIR
	//---
	LD	A,#10
	CALL	PAGER
	LD	HL,SCR2M
	LD	DE,#4000
	CALL	DEPACKER
	LD	A,#17
	CALL	PAGER
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR
	RET
;--------------------------------------
FADEIN	LD	A,2
	DEC	A
	LD	(FADEIN+1),A
	RET	NZ
	LD	A,2
	LD	(FADEIN+1),A
	LD	A,8
FADE	EQU	$-1
	SUB	1
	RET	C
	LD	(FADE),A
	LD	C,A
	LD	HL,RGBADD + 63
	LD	IX,RGBADD + 127
	LD	E,8
FD3	LD	A,E
	DEC	A
	SUB	C
	JP	NC,FD2
	XOR	A
FD2	ADD	A,A
	ADD	A,A
	ADD	A,A
	LD	D,A
	LD	B,8
FD0	LD	A,B
	DEC	A
	SUB	C
	JP	NC,FD1
	XOR	A
FD1	OR	D
	LD	(HL),A
	DEC	L
	OR	#40
	LD	(IX),A
	DEC	LX
	DEC	B
	JP	NZ,FD0
	DEC	E
	JP	NZ,FD3
	RET
;---------------------------------------
SCR_FADEIN ;
	LD	DE,#D800
	EXX
	LD	HL,RGB1
FADE_RGB EQU	$-1
	LD	D,RGBADD/256
	LD	C,3
EF3	LD	B,0
EF2	LD	E,(HL)
	LD	A,(DE)
	EXX
	LD	(DE),A
	INC	E
	EXX
	INC	L
	DJNZ	EF2
	INC	H
	EXX
	INC	D
	EXX
	DEC	C
	JP	NZ,EF3
	RET
;----------------------------
ROLL	LD	A,24
	SUB	1
	RET	C
	LD	(ROLL+1),A
	LD	HL,RGB2
ROLL_RGB2 EQU	$-2
	LD	DE,#5800
ROLL_ATTR2 EQU	$-2
	CALL	LDI32
	LD	(ROLL_RGB2),HL
	LD	(ROLL_ATTR2),DE
	LD	HL,RGB1
ROLL_RGB1 EQU	$-2
	LD	DE,#D800
ROLL_ATTR1 EQU	$-2
	CALL	LDI32
	LD	(ROLL_RGB1),HL
	LD	(ROLL_ATTR1),DE
	RET
LDI32	DUP	32
	LDI
	EDUP
	RET
//------------------------------------------
FAZE0	;fade in screen
	LD	A,(CURR_SCR)
	XOR	#08 + #02
	LD	(CURR_SCR),A
	CALL	PAGER
	CALL	SCR_FADEIN
	CALL	FADEIN
	LD	A,(CURR_SCR)
	AND	#08
	LD	A,RGB1/256
	JP	NZ,FZ0_1
	LD	A,RGB2/256
FZ0_1	LD	(FADE_RGB),A
	RET
//------------------------------------------
ROT_RGB_TBL
	DB	79
	DW	ROT_R_0
	DB	0
	;--
	DB	83
	DW	ROT_R_1
	DB	0
	;--
	DB	103
	DW	ROT_R_2
	DB	0
	;--
	DB	103
	DW	ROT_R_3
	DB	0
	;--
	DB	79
	DW	ROT_R_4
	DB	0
	;--
	DB	83
	DW	ROT_R_5
	DB	0
	;--
	DB	103
	DW	ROT_R_6
	DB	0
	;--
	DB	105
	DW	ROT_R_7
	DB	0
//------------------------------------------
EFF_RUN_
	EI
	HALT	;1638 for music; +2730 ~1848 free takts
	LD	A,(EFF_FAZE)
	OR	A
	JP	Z,FAZE0
	DEC	A
	JP	Z,FAZE2
FZ_JP_FIX	EQU	$-2
	DEC	A
	JP	Z,FAZE2
	RET
;----------------------
FAZE2	LD	A,7
	OUT	(#FE),A
	;--
	LD	A,#17
	CALL	PAGER
	;--
	LD	HL,#5800
	LD	DE,#5801
	LD	(HL),7*8+7
	LD	BC,767
	LDIR
	;--
	DUP	4
	EI
	HALT
	EDUP
	
	LD	BC,1150
BLNW1	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,BLNW1
	
	LD	HL,RGB2X
	LD	DE,#D800
	LD	BC,768
	LDIR
	LD	HL,RGB1X
	LD	DE,#5800
	LD	BC,768
	LDIR	
	;--
	LD	A,#10
	CALL	PAGER
	;--
	LD	HL,FAZE1
	LD	(FZ_JP_FIX),HL
	;--
	AND	A
	;RET	C
	;RET	C
	RET	C
	;--
	RET
;----------------------
FAZE1	;rotate screen
	LD	A,#17+#08
CURR_SCR	EQU	$-1
	XOR	#08
	LD	LY,A
	XOR	#02
	LD	(CURR_SCR),A
	AND	#18
	LD	HY,A
	CALL	PAGER
	LD	A,103
	DEC	A
	JP	NZ,$-1
	DEC	HL
	NOP
	LD	A,0
ROT_FAZE EQU	$-1
	INC	A
	AND	15
	LD	(ROT_FAZE),A
	RRA
	AND	7
	ADD	A,A
	ADD	A,A
	LD	C,A
	LD	B,0
	EXX
	LD	A,(ROT_FAZE)
	INC	A
	AND	15
	RRA
	AND	7
	ADD	A,A
	ADD	A,A
	LD	C,A
	LD	B,0
	LD	HL,ROT_RGB_TBL
	ADD	HL,BC
	LD	A,(HL)
	INC	HL
	LD	LX,A
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	LD	BC,#7FFD
	EXX
	LD	HL,ROT_TBL
	ADD	HL,BC
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	C,(HL)
	INC	HL
	LD	B,(HL)
	INC	HL
	LD	(FX_ROT_GO),BC
	SCF
	CCF	
	LD	(FX_RET + 1),SP
	LD	BC,#00FE
	LD	SP,SCR_0
FX_ROT_GO EQU	$-2
	RET
FX_RET	LD	SP,0

	XOR	A
	OUT	(#FE),A

	;RET	C
	;RET	C
	;RET	C
	RET
ROT_TBL
	DB	COLOR1, COLOR2
	DW	SCR_0
	DB	COLOR1, COLOR2
	DW	SCR_1
	DB	COLOR1, COLOR2
	DW	SCR_2
	DB	COLOR1, COLOR2
	DW	SCR_3
	DB	COLOR2, COLOR1
	DW	SCR_0
	DB	COLOR2, COLOR1
	DW	SCR_1
	DB	COLOR2, COLOR1
	DW	SCR_2
	DB	COLOR2, COLOR1
	DW	SCR_3	
SCR_WAIT ;97!!! 10  jp
	LD	A,5	;7
	DEC	A	
	JP	NZ,$-1	;14*5 = 70
	RET	;10
;---------------
WS1_32	OUT (C),E
	JP	SCR_WAIT32 ;10
WS2_32	OUT (C),D
	JP	SCR_WAIT32 ;10
;SCR_WAIT32 ;139t
	LD	A,8	;7
	DEC	A
	JP	NZ,$-1	;14 * 8
	RET C: RET C
	RET	;10
;-----------------
SCR_WAIT32_ ;117
	LD	A,6	;7
	DEC	A
	JP	NZ,$-1	;84
	NOP:NOP:NOP:NOP
	RET	;10
SCR_WAIT32
	LD	A,LX	;8
	OR	A	;4
	JP	Z,SCR_WAIT32_	;10
	DEC	LX	;8
	RET	C	;6 /34
	;---
	LD	A,LY	;8 obv
	EXX		;4 obv
	OUT	(C),A	;12 obv
	;---
	LD	E,(HL)	;7
	INC	HL	;6
	LD	D,(HL)	;7
	INC	HL	;6
	LD	A,(HL)	;7
	INC	HL	;6
	LD	(DE),A	;7 /46
	;---
	LD	A,HY	;8 obv
	OUT	(C),A	;12 obv
	EXX		;4 obv
	RET		;10 obv //58t 
;-----------------
	LD	A,96
FZX	EQU	$-1
	SUB	1
	JP	NC,FZX1
	LD	A,1
	LD	(EFF_FAZE),A
	XOR	A
FZX1	LD	(FZX),A
	LD	A,(CURR_SCR)
	XOR	#08
	LD	(CURR_SCR),A
	
	LD	A,220
XXX	EQU	$-1
	SUB	1
	JP	C,XXX1
	LD	(XXX),A
	RET
XXX1	LD	A,2
	LD	(EFF_FAZE),A
	RET
//---------------------------
W_SCR	INCLUDE	"screens.asm"
ROT_R_TBL	INCLUDE	"rot_r_tbl.asm"

	ORG	(($+255)/256)*256
RGB1	INCBIN	"2mans-rgb-1.bin"
RGB2	INCBIN	"2mans-rgb-2.bin"
RGB1X	INCBIN	"begin-1_attr_0.bin"
RGB2X	INCBIN	"begin-1_attr_1.bin"


RGBADD	DS	256,0

	DISPLAY	"SCR_WAIT32 ", /A, SCR_WAIT32