	DEVICE	ZXSPECTRUM128
//====================================================
// Compile constant declaration
//====================================================
CM_PREVIEW	EQU	0	; compile effect for preview on emulator/real
CM_DEMO		EQU	1	; compile KERNAL and FX for DEMO
MT_PENTAGON	EQU	0	; zx-hardware type
MT_ZX128	EQU	1
MT_ZX2A		EQU	2
//====================================================
T_FX_INI	EQU	0
T_FX_RUN	EQU	1
T_ASM		EQU	2
T_IM2DEMO	EQU	3
T_NEXTFAZE	EQU	4
T_DEPACK	EQU	5
//====================================================
// Compile parameters setup
//====================================================
	DEFINE	SHOW_BORDER_ALLOCATION	0
MACHINE_TYPE	EQU	MT_PENTAGON
COMPILE_MODE	EQU	CM_PREVIEW
	DEFINE	EFFECT	10
	//effect number for "preview/effect" compile mode
//====================================================
// Memory Pages Layout
//====================================================
PGSCR5	EQU	#15
PGSCR7	EQU	#17
PGFAST0	EQU	#10
PGFAST1	EQU	#12
	IF MACHINE_TYPE=MT_PENTAGON OR MACHINE_TYPE=MT_ZX128
PGSLOW0	EQU	#11	
PGSLOW1	EQU	#13
PGFAST2	EQU	#14
PGFAST3	EQU	#16
	ENDIF
	IF MACHINE_TYPE=MT_ZX2A
PGSLOW0	EQU	#14
PGSLOW1	EQU	#16
PGFAST2	EQU	#11
PGFAST3	EQU	#13
	ENDIF
//====================================================
// Low memory kernal (LOW_KERNAL)
//====================================================
		ORG	#6200
LOW_KERNAL_BEGIN
		JP	MAIN_DEMO
//----------- kernal routines (jump table)
DEPACKER	JP	DEPACKER_
CLEAR_RGB	JP	CLEAR_RGB_
INTCORR		JP	INTCORR_
MUSIC_ON	JP	MUSIC_ON_
//----------------------------------------------------------------------
//				Demo StartUp procedure
//----------------------------------------------------------------------
MAIN_DEMO
	//-------
	IF COMPILE_MODE=CM_PREVIEW AND NOT EFFECT=10
CLEAR_RGB_COLOR	EQU	0
	ELSE
CLEAR_RGB_COLOR	EQU	7
	ENDIF
	//------ kernal initialization
	CALL	CLEAR_RGB_
	//-------
	IF COMPILE_MODE=CM_DEMO
		CALL	LOADER
	ENDIF
	
	DI
	LD	SP,VAR_STACK	
	CALL	IM2CORR
	CALL	INTCORR_
	IF COMPILE_MODE=CM_DEMO
		CALL	MUSIC_INIT2
	ELSE
		CALL	MUSIC_INIT
	ENDIF
	CALL	MUSIC_INIT

	//----- main loop procedure
	LD	IY,EFFTABLE
MLOOP	LD	A,(IY)
	INC	IY
	ADD	A,A
	LD	L,A
	LD	H,COMMTBL/256	;    
	LD	E,(HL)
	INC	L
	LD	D,(HL)
	EX	DE,HL
	LD	DE,MLOOP1
	PUSH	DE
	JP	(HL)		; CALL
MLOOP1	JP	MLOOP
//====================================================
// ROUTINES
//====================================================
MUSIC_ON_
	LD	A,MUS_PAGE
	LD	(MPLPAGE),A
	LD	HL,MUS_PLAY
	LD	(MPLADR),HL
	RET
MUSIC_INIT
	LD	A,MUS_PAGE
	CALL	PAGER
	JP	PLAYER	;MUS_INI
MUSIC_INIT2
	LD	A,#14
	CALL	PAGER
	JP	#C000	;MUS_INI
MUS_PLAY_FX //---------------
	PUSH	HL,DE,BC,AF	;44
	EXX			;4
	PUSH	HL,DE,BC	;33 /80
	;--
	LD	HL,(MUSPOS_LOCAL) ;16
	INC	HL		  ;6
	LD	(MUSPOS_LOCAL),HL ;16
	LD	HL,(MUSPOS)	;16
	INC	HL		;6
	LD	(MUSPOS),HL	;16 /38*2=76
	;--
	IF	COMPILE_MODE = CM_DEMO
		LD	A,#14		;7
MPLPAGE		EQU	$-1
		LD	BC,#7FFD	;10
		OUT	(C),A		;12
		CALL	#C003; MRET;	;17-- reg on use: bc,bc`,hl`,de`,a
	ELSE
		LD	A,MUS_PAGE	;7
MPLPAGE		EQU	$-1
		LD	BC,#7FFD	;10
		OUT	(C),A		;12
		CALL	MUS_PLAY; MRET;	;17-- reg on use: bc,bc`,hl`,de`,a
	ENDIF
MPLADR	EQU	$-2
	LD	A,(PAGE)	;13
	LD	BC,#7FFD	;10
	OUT	(C),A		;12 /81
	;--
	POP	BC,DE,HL	;30
	EXX			;4
	POP	AF,BC,DE,HL	;40
	EI			;4
MRET	RET			;10 /84 //321+player(1317)=1638 +-    
COMM_DEPACK //---------------
	LD	A,(IY)
	INC	IY
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
	EX	DE,HL
	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY	
	PUSH	IY
	CALL	PAGER
	CALL	DEPACKER
	POP	IY
	RET
COMM_INI //---------------
	PUSH	IY
	LD	A,#10
	CALL	PAGER
	CALL	EFF_INI	;init
	POP	IY
	RET
COMM_NEXTFAZE
	LD	HL,EFF_FAZE
	INC	(HL)
	JP	COMM_E2
COMM_EXE //---------------
	XOR	A
	LD	(EFF_FAZE),A
	LD	HL,0
	LD	(MUSPOS_LOCAL),HL
COMM_E2	LD	E,(IY)
	INC	IY
	LD	D,(IY)
	INC	IY
	PUSH	IY
COMM_E1	PUSH	DE
	CALL	EFF_RUN
	POP	DE
	LD	HL,(MUSPOS)
	AND	A
	SBC	HL,DE
	JP	C,COMM_E1
	POP	IY
	LD	A,#10
	CALL	PAGER
	RET
COMM_ASM //-------------   
	PUSH	IY
	POP	HL
	JP	(HL)
	//   :
	;	
	;	LD	IY,$+5
	;	RET
;------
DEPACKER_
	PUSH	IY
	CALL	DEPACK
	POP	IY
	RET
DEPACK	INCLUDE	"system/depacker.asm"
MPLAY	JP	PLAYER+3
;------
CLEAR_RGB_
	EI
	HALT
	LD	A,CLEAR_RGB_COLOR
	OUT	(#FE),A
	LD	A,#17
	CALL	PAGER
	LD	HL,#5800
	LD	DE,#5801
	LD	(HL),CLEAR_RGB_COLOR*8+CLEAR_RGB_COLOR
	LD	BC,767
	LDIR
	LD	HL,#D800
	LD	DE,#D801
	LD	(HL),CLEAR_RGB_COLOR*8+CLEAR_RGB_COLOR
	LD	BC,767
	LDIR
	RET
;-----------------------------
	ORG	($/256)*256+256
COMMTBL //---
	DW	COMM_INI	;0 init fx
	DW	COMM_EXE	;1 execute fx
	DW	COMM_ASM	;2   
	DW	IM2DEMO		;3  
	DW	COMM_NEXTFAZE	;4      
	DW	COMM_DEPACK	;5   

//====================================================
// Variables
//====================================================
VAR_STACK	EQU	#BFBF
MUS_PAGE	EQU	PGFAST3;
MUS_PAGE2	EQU	#14;
;MUS_INI		EQU	PLAYER
MUS_PLAY	EQU	MPLAY
PAGE		EQU	#5B5C ;23388 - value saved for port #7FFD
MUSPOS		DW	0	//   
MUSPOS_LOCAL	DW	0	//     
EFF_FAZE	DB	0
//====================================================
// TIMELINE
//====================================================
EFFTABLE
	IF COMPILE_MODE=CM_PREVIEW
		INCLUDE effects/EFFECT/_timeline.asm
	ENDIF
	IF  COMPILE_MODE=CM_DEMO
		INCLUDE timeline.asm
	ENDIF
;-------------
BLINKER	EI
	HALT
	LD	A,#17
	CALL	PAGER
	LD	A,7
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),7*8+7
	LDIR
	EI
	HALT
	EI
	HALT
	XOR	A
	OUT	(#FE),A
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),L
	LDIR
	RET
LOAD_3D13
	LD	DE,(23796)
	LD	C,#05
	JP	#3D13
	;---------------
LOADER	DI
	LD	DE,(23796)
	DEC	E
	LD	(23796),DE
	;--- ACROSS15
		LD	HL,#8000
		LD	B,PG15LEN
		CALL	LOAD_3D13
		LD	HL,#8000
		LD	DE,#4000
		CALL	DEPACKER
	;--- ACROSSMX
		LD	A,MUS_PAGE
		CALL	PAGER
		LD	HL,#C000
		LD	B,MUSPGLEN
		CALL	LOAD_3D13
	;--- ACROSS17
		LD	HL,#8000
		LD	B,PG17LEN
		CALL	LOAD_3D13
		;-
		LD	A,#17
		CALL	PAGER
		;-
		LD	HL,#8000
		LD	DE,#DB00
		CALL	DEPACKER
	;--- ACROSS12
		LD	A,#10
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG12LEN
		CALL	LOAD_3D13
		;-
		LD	HL,#C000
		LD	DE,#8000
		CALL	DEPACKER
	;--- ACROSS10
		LD	A,#10
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG10LEN
		CALL	LOAD_3D13
	;--- ACROSS11
		LD	A,#11
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG11LEN
		CALL	LOAD_3D13
	;--- ACROSS13
		LD	A,#13
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG13LEN
		CALL	LOAD_3D13
	;--- ACROSS14
		LD	A,#14
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG14LEN
		CALL	LOAD_3D13
		;---
		RET
LOADER2
	;--- ACROSS20
		LD	A,#10
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG20LEN
		CALL	LOAD_3D13
		;---
	;CALL	BLINKER
	;--- ACROSS21
		LD	A,#11
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG21LEN
		CALL	LOAD_3D13
		;---
	;CALL	BLINKER
	;--- ACROSS23
		LD	A,#13
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG23LEN
		CALL	LOAD_3D13
	;CALL	BLINKER
	;--- ACROSS24
		LD	A,#14
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG24LEN
		CALL	LOAD_3D13
		CALL	MUSIC21_INI
	;CALL	BLINKER
	;--- ACROSS26
		LD	A,#16
		CALL	PAGER
		;-
		LD	HL,#C000
		LD	B,PG26LEN
		CALL	LOAD_3D13
	;---
		CALL	#C000
		RET
		
MUSIC_PART_2
	LD	A,#16
	LD	(MPLPAGE),A
	LD	HL,#C003
	LD	(MPLADR),HL
	RET
		
;-------------
LOW_KERNAL_END	EQU	$
LOW_KERNAL_SIZE	EQU	LOW_KERNAL_END-LOW_KERNAL_BEGIN
;====================================================
; MUSIC
;====================================================
	IF COMPILE_MODE=CM_DEMO
	ORG	#6800
	INCLUDE	music/player.asm
	ENDIF
;====================================================
; EFFECT CODE SECTION
;====================================================
	ORG	#8000
EFF_BEGIN
//-----------
	IF COMPILE_MODE=CM_PREVIEW
		INCLUDE	effects/EFFECT/effect.asm
	ENDIF
//-----------
EFF_END
EFF_SIZE	EQU	EFF_END-EFF_BEGIN
;====================================================
; High memory kernal (HIGH_KERNAL)
;====================================================
//       INT_ROUTINES
	ORG	#BF01
PAGER	LD	BC,#7FFD
	LD	(PAGE),A
	OUT	(C),A
	RET
IM2DEMO DI
	LD	A,#BE	;    INT
	LD	I,A
	IM	2
	LD	HL,IM2DEMO_
	LD	(#BEFF),HL
	RET
IM2CORR	DI
	LD	A,#BE	;    INT
	LD	I,A
	IM	2
	LD	HL,IM2CORR_
	LD	(#BEFF),HL
	RET	
//----------
IM2DEMO_
	DI	;4
	JP	MUS_PLAY_FX
IM2_MUSFLAG	EQU	$-2
//---  int`   
INTCORR_ LD BC,#6FF
	;  6 ! (   3)
	; 2  - :
	;1- -    IMER   INT,
	;2- -   D.
	DI
	LD	HL,IM2CORR_
	LD	(#BEFF),HL
IM2BACK	XOR	A
	LD	HL,IM2LOOP ;+2t
	EI
IM2LOOP	DEC	A
	JP	(HL)
	;-1t (INT=11t)
IM2CORR_
	POP	HL	;+2t
	LD	E,(HL)	;-1t
	RL	E	;"JP (HL)">128
	RLA
	LD	E,D
	LD	D,A
	SUB	E
	SUB	C	;   D?
	SBC	A,A
	OR	4	;-1t 4=EXIT,#FF=NO EXIT
	DEC	B	; +1   
	AND	B	;  NO EXIT
	JR	NZ,IM2BACK
	;--
	LD	HL,IM2DEMO_	;10
	LD	(#BEFF),HL	;16
	RET			;10 /36
IM1SET	DI
	LD	IY,#5C3A
	LD	A,#3F
	LD	I,A
	IM	1
	RET
MUS_OFF	LD	E,15
	XOR	A
MUS_OFF_LP
	LD	BC,#FFFD
	OUT	(C),E
	LD	B,#BF
	OUT	(C),A
	DEC	E
	JP	NZ,MUS_OFF_LP
	RET
HI_KERNAL_END
//====================================================
// INFO
//====================================================
	DISPLAY	"--------------------------------"
	DISPLAY	"LOW_KERN BEGIN: ",/A,#6400
	DISPLAY	"LOW_KERN END: ",/A,LOW_KERNAL_END
	DISPLAY	"LOW_KERN SIZE: ",/A,LOW_KERNAL_SIZE
	DISPLAY	"LOW_KERN FREE: ",/A, (#8000-LOW_KERNAL_END)
	DISPLAY	"HI_KERN END: ",/A,HI_KERNAL_END," (#BFBF max)"
	DISPLAY	"--------------------------------"
	DISPLAY	"EFFECT END: ",/A,EFF_END
	DISPLAY	"EFFECT SIZE: ",/A,EFF_SIZE
	DISPLAY	"--------------------------------"
	DISPLAY	"MUSPOS_LOCAL: ",/A,MUSPOS_LOCAL
	DISPLAY	"--------------------------------"
//====================================================
// SAVE FX BINARY CODE & TRY TO COMPRESS
//====================================================
	SAVEBIN	"compile/effect.bin", #8000, EFF_SIZE
//====================================================
// SAVE PREVIEW
//====================================================
	IF COMPILE_MODE=CM_PREVIEW
PG17LEN	EQU	0
PG16LEN	EQU	0
PG15LEN	EQU	0
PG14LEN	EQU	0
PG13LEN	EQU	0
PG12LEN	EQU	0
PG11LEN	EQU	0
PG10LEN	EQU	0
PG20LEN	EQU	0
PG21LEN	EQU	0
PG23LEN	EQU	0
PG24LEN	EQU	0
PG26LEN	EQU	0
MUSIC21_INI	EQU	0

MUSPGLEN EQU	0
		DISPLAY	"PREVIEW EFFECT: ", EFFECT
		;--------------------------
		IF MACHINE_TYPE=MT_PENTAGON
			EMPTYTRD "preview.trd"
			;--- page 0
				ORG	#C000
				DS	16384,%01010101
			ORG	#C000
			INCLUDE	effects/EFFECT/eff_page0.asm
			SAVETRD "preview.trd","CODE.C",#6200,#A000
			IF $-#C000 == 0
PG0LEN	EQU	1
			ELSE
PG0LEN	EQU	$-#C000
			ENDIF
			SAVEBIN	"compile/pg0.bin", #C000, PG0LEN
			DISPLAY "PAGE_0_END: ", /A, $
			;--- page 1
				ORG	#C000
				DS	16384,%01010101
			ORG	#C000
			INCLUDE	effects/EFFECT/eff_page1.asm
			SAVETRD "preview.trd","PAGE.C",#C000,#4000
			DISPLAY "PAGE_1_END: ", /A, $ 
			;--- page 7
				ORG	#C000
				DS	16384,%01010101
			ORG	#DB00
			INCLUDE	effects/EFFECT/eff_page7.asm
			SAVETRD "preview.trd","PAGE17.C",#DB00,#2500
			IF $-#DB00 == 0
PG7LEN	EQU	1
			ELSE
PG7LEN	EQU	$-#DB00
			ENDIF
			SAVEBIN	"compile/pg7.bin", #DB00, PG7LEN
			DISPLAY "PAGE_7_END: ", /A, $ 
			;--- page music
				ORG	#C000
				DS	16384,%01010101
			ORG	#C000
			;INCLUDE	"music/musicpage.asm"
			INCLUDE	"music/part2/PLAYER.asm"
MUSBINEND		SAVETRD "preview.trd","MUSIC.C",#C000,MUSBINEND-#C000
			;--- page music
				ORG	#8000
				DS	512,0
			ORG	#8000
			INCBIN "system/boot_prev_trdos_v2.bin"
			SAVETRD "preview.trd","prev_trd.B",#8000,$-#8000
		ENDIF
		;--------------------------
		IF MACHINE_TYPE=MT_ZX128 OR MACHINE_TYPE=MT_ZX2A
				ORG	#C000
			INCLUDE	effects/EFFECT/eff_page0.asm
			SAVEBIN "temp/code.C",#6200,#A000
				ORG	#C000
			INCLUDE	effects/EFFECT/eff_page1.asm
			SAVEBIN "temp/page.C",#C000,#4000
				ORG	#C000
			INCLUDE	"music/musicpage.asm"
MUSBINEND
			SAVEBIN "temp/music.C",#C000,MUSBINEND-#C000

//			SHELLEXEC "bin2tap.exe -a 25088 -o code.tap temp\code.C"
//			SHELLEXEC "bin2tap.exe -a 49152 -o page.tap temp\page.C"
//			SHELLEXEC "bin2tap.exe -a 49152 -o music.tap temp\music.C"

			SHELLEXEC "bin2tap.exe temp\code.C temp\code.tap"
			SHELLEXEC "bin2tap.exe temp\page.C temp\page.tap"
			SHELLEXEC "bin2tap.exe temp\music.C temp\music.tap"

			IF MACHINE_TYPE=MT_ZX128
				SHELLEXEC "system\makeprev128.bat"
			ENDIF
			IF MACHINE_TYPE=MT_ZX2A
				SHELLEXEC "system\makeprev2a.bat"
			ENDIF
		ENDIF
		;--------------------------		
	ENDIF
	
//====================================================	
// SAVE DEMO
//====================================================
	IF COMPILE_MODE=CM_DEMO
EFF_INI		EQU	#8000
EFF_RUN		EQU	#8003
		EMPTYTRD "preview.trd"
		ORG	#5C53
		INCBIN "system/ACROSS.B"
		SAVETRD "preview.trd", "ACROSS.B", #5C53, 121
		SAVETRD "preview.trd", "ACROSSLK.C", #6200, #8000-#6200
		SAVETRD "preview.trd", "ACROSSHK.C", #BF00, #0100
		;--- pg15
		ORG	#C000
		INCBIN	"bin/10_begin_texts.bin.mlz"
		SAVETRD "preview.trd","ACROSS15.C",#C000,$-#C000
PG15LEN		EQU	($+255-#C000)/256
		;--- music
		ORG	#C000
		INCLUDE	"music/musicpage.asm"
		SAVETRD "preview.trd","ACROSS16.C",#C000,$-#C000
MUSPGLEN	EQU	($+255-#C000)/256
		;--- pg17
		ORG	#8000
		INCBIN	"bin/10_begin_pg7.bin.mlz"
		SAVETRD "preview.trd","ACROSS17.C",#8000,$-#8000
PG17LEN		EQU	($+255-#8000)/256
		;--- pg12
		ORG	#C000
		INCBIN	"bin/10_begin_code.bin.mlz"
		SAVETRD "preview.trd","ACROSS12.C",#C000,$-#C000
PG12LEN		EQU	($+255-#C000)/256
;----------------------------------------
		;--- pg10
		ORG	#C000
		INCLUDE	"bin/page_10.asm"
		SAVETRD "preview.trd","ACROSS10.C",#C000,$-#C000
PG10LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 10 SIZE: ", /A, PG10LEN*256
		;--- pg11
		ORG	#C000
		INCLUDE	"bin/page_11.asm"
		SAVETRD "preview.trd","ACROSS11.C",#C000,$-#C000
PG11LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 11 SIZE: ", /A, PG11LEN*256
		;--- pg13
		ORG	#C000
		INCLUDE	"bin/page_13.asm"
		SAVETRD "preview.trd","ACROSS13.C",#C000,$-#C000
PG13LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 13 SIZE: ", /A, PG13LEN*256
		;--- pg13
		ORG	#C000
		INCLUDE	"bin/page_14.asm"
		SAVETRD "preview.trd","ACROSS14.C",#C000,$-#C000
PG14LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 14 SIZE: ", /A, PG14LEN*256
;----------------------------------------
		;--- pg20
		ORG	#C000
		INCLUDE	"bin/page_20.asm"
		SAVETRD "preview.trd","ACROSS21.C",#C000,$-#C000
PG20LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 20 SIZE: ", /A, PG20LEN*256
		;--- pg21
		ORG	#C000
		INCLUDE	"bin/page_21.asm"
		SAVETRD "preview.trd","ACROSS21.C",#C000,$-#C000
PG21LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 21 SIZE: ", /A, PG21LEN*256
		;--- pg23
		ORG	#C000
		INCLUDE	"bin/page_23.asm"
		SAVETRD "preview.trd","ACROSS23.C",#C000,$-#C000
PG23LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 23 SIZE: ", /A, PG23LEN*256
		;--- pg24
		ORG	#C000
		INCLUDE	"bin/page_24.asm"
		SAVETRD "preview.trd","ACROSS24.C",#C000,$-#C000
PG24LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 24 SIZE: ", /A, PG24LEN*256
		;--- pg26
		ORG	#C000
		INCLUDE	"bin/page_26.asm"
		SAVETRD "preview.trd","ACROSS26.C",#C000,$-#C000
PG26LEN		EQU	($+255-#C000)/256
		DISPLAY	"DEMO PAGE 26 SIZE: ", /A, PG26LEN*256
;----------------------------------------
	ENDIF
	DISPLAY	"COMM_EXE: ", /A, COMM_EXE
	DISPLAY "MUSPOS: ", /A, MUSPOS