<?
header('Content-Type: text/html; charset=utf-8');
require_once 'check_access.php';
include 'fx_arr.php';
$view = isset($_GET['view']) ? (int)$_GET['view'] : 0;
$action = isset($_GET['action']) ? $_GET['action'] : false;
$fx_id = isset($_GET['fx_id']) ? $_GET['fx_id'] : false;
if ($action == 'move_left' && $fx_id !== false) {
	$n = array_search($fx_id, $fx_timeline);
	if ($n > 0) {
		$tmp = $fx_timeline[$n-1];
		$fx_timeline[$n-1] = $fx_timeline[$n];
		$fx_timeline[$n] = $tmp;
	}
	file_put_contents('fx_timeline.txt', implode(',', $fx_timeline));
	header('Location: preview.php');
}
if ($action == 'move_right' && $fx_id !== false) {
	$n = array_search($fx_id, $fx_timeline);
	if ($n < sizeof($fx_timeline)-1) {
		$tmp = $fx_timeline[$n+1];
		$fx_timeline[$n+1] = $fx_timeline[$n];
		$fx_timeline[$n] = $tmp;
	}
	file_put_contents('fx_timeline.txt', implode(',', $fx_timeline));
	header('Location: preview.php');
}
$ready_arr = array(
    0 => '-',
    1 => '+',
    2 => '&plusmn;',
);
$ready_title_arr = array(
    0 => 'не приступал',
    1 => 'готово',
    2 => 'частично сделан',
);

?>
<!DOCTYPE html>
<html lang="ru">
<head>
	<meta charset="utf-8">
	<title>ACROSS THE EDGE - PREVIEW EFFECTS & FAZES</title>
	<style>
		#fx-blocks .fx-block {
			border: 1px solid #000;
			display: inline-block;
			margin: 10px;
            position:relative;
		}
		<?if ($view == 0) {?>
			#fx-blocks .fx-block.tml-inv {
				display: none;
			}
		<?}?>
		#fx-blocks .fx-block .fx-block-hdr {
			background-color: #000;
			color: #fff;
			font-weight: bold;
			padding: 5px 10px;
			border-bottom: 1px solid #808080;
			font-size: 12px;
		}
		#fx-blocks .fx-block .fx-block-hdr a {
			color: #fff;
		}
		#fx-blocks .fx-block img {
			width: 192px;
			cursor: pointer;
            :relative;
		}
		div.fx {
			vertical-align: top;
			white-space: nowrap;
			max-width: 100%;
			overflow-x: auto;
		}
		div.faze {
			display: inline-block;
			border: 1px solid #000;
			width: 192px;
			font-size:12px;
			text-align: center;
			margin: 0px 5px;
			vertical-align: top;
		}
		div.faze img {
			max-width: 100%;
			cursor: pointer;
		}
		div.desc {
			white-space: normal;
			background-color: #e0e0e0;
			padding: 2px;
		}
		div.clearfix {
			clear: both;
		}
		div.header {
			padding: 2px 10px;
			color: #fff;
			background-color: #808080;
			margin: 5px 0px;
		}
		div#zoom {
			border: 2px solid #000;
			padding: 10px;
			position: fixed;
			top: 50%;
			left: 50%;
			margin-left: -384px;
			margin-top: -300px;
			background-color: #fff;
			display: none;
		}
		div#zoom img {
			width: 768px;
			width: 600px;
			border: 1px solid #000;
			cursor: pointer;
		}
		div#zoom_bg {
			position: fixed;
			top: 0px;
			left: 0px;
			width: 100%;
			height: 100%;
			background: #000;
			opacity: 0.75;
			display: none;
		}
		div.selector {
			display: inline-block;
		}
		div.selector a {
			display: inline-block;
			border: 1px solid;
			padding: 2px 10px;
			font-weight: bold;
		}
		div.selector a.active {
			background-color: #00d0e0;
		}
		div.fx-block-img {
			line-height: 0px;
            position:relative;
		}
        div.fx-block-ready {
            position:absolute;
            left: -10px;
            top: -10px;
            background-color: #fff;
            width: 10px;
            height: 10px;
            text-align:center;
            line-height:12px;
            padding:2px;
            font-weight: bold;
            border: 1px solid #000;
            cursor: pointer;
        }
        div.fx-block-ready.ready-0 {
            background-color: red;
            color: #fff;
        }
        div.fx-block-ready.ready-1 {
            background-color: #00ff00;
            color: #000;
        }
        div.fx-block-ready.ready-2 {
            background-color: #ffff00;
            color: #000;
        }
		div.fx-block-hdr span {
			float:right;
		}
		div.fx-block-hdr span a {
			padding: 0px 2px;
			cursor: pointer;
			text-decoration: none;
		}
		div.fx-block-hdr span a:hover {
			color:#d0d0d0;
			background-color:#808080;
		}
	</style>
	<script>
		function js_do_zoom(img) {
			document.getElementById('zoom_img').src = img.src;
			document.getElementById('zoom').style.display = 'block';
			document.getElementById('zoom_bg').style.display = 'block';
		}
		function js_close_zoom() {
			document.getElementById('zoom').style.display = 'none';
			document.getElementById('zoom_bg').style.display = 'none';
		}
	</script>
</head>
<body>
<div class="selector"><a href="index.php">back</a></div>
<h1>ACROSS THE EDGE - TIMELINE</h1>
<div>View: 
	<div class="selector"><a href="preview.php?view=0" <?=$view==0 ? 'class="active"' : ''?>>short</a></div>
	<div class="selector"><a href="preview.php?view=1" <?=$view==1 ? 'class="active"' : ''?>>full</a></div>
</div>
<div id="fx-blocks" class="">
	<?foreach ($fx_timeline as $fx_n=>$fx_id) {
		$fx = $fx_arr[$fx_id];
		$title = sprintf('%02d',$fx_id). '_' . $fx['title'];
		foreach ($fx['fazes'] as $faze_id=>$faze) {
			$class = (isset($faze['show_in_timeline']) && $faze['show_in_timeline']) ? 'tml-vis' : 'tml-inv';
			if (true) {?>
			<div class="fx-block <?=$class?>">
                <div class="fx-block-ready ready-<?=$fx['ready']?>" title="<?=$ready_title_arr[$fx['ready']]?>"><?=$ready_arr[$fx['ready']]?></div>
				<div class="fx-block-hdr"><a href="#<?=$title?>"><?=$title?></a>
					<span>
						<a href="?action=move_left&fx_id=<?=$fx_id?>">&#9664;</a>
						<a href="?action=move_right&fx_id=<?=$fx_id?>">&#9654;</a>
					</span>
				</div>
				<div class="fx-block-img"><img src="preview/<?=$faze['img']?>" onclick="js_do_zoom(this)" /></div>
			</div>
			<?}
		}
	}?>
</div>
<h1>ACROSS THE EDGE - PREVIEW EFFECTS & FAZES</h1>
<?foreach ($fx_timeline as $fx_id) {
	$fx = $fx_arr[$fx_id];
	$title = sprintf('%02d',$fx_id). '_' . $fx['title'];
	?>
	<div class="header" id="<?=$title?>"><b><?=$title?></b></div>
	<div class="fx">
		<?foreach ($fx['fazes'] as $faze_id=>$faze) {?>
			<div class="faze">
				<div><img src="preview/<?=$faze['img']?>" onclick="js_do_zoom(this)" /></div>
				<div class="desc"><?=($faze_id+1)?><br><?=$faze['desc']?></div>
			</div>
		<?}?>
	</div>
	<div class="clearfix"></div>
	<div><?=$fx['desc']?></div>
	<?if (isset($fx['web'])) {?>
		<div><a href="<?=$fx['web']?>">web-preview</a></div>
	<?}?>
	<?if (isset($fx['video'])) {
		for ($i=1;$i<=$fx['video'];$i++) {?>
		<div><a href="preview/fx<?=(int)$fx_id?>-video-<?=$i?>.avi">video-<?=$i?></a></div>
		<?}
	}?>
<?}?>
<div id="zoom_bg" onclick="js_close_zoom()"></div>
<div id="zoom"><img id="zoom_img" src="" onclick="js_close_zoom()"/></div>
</body>
</html>