//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID59c531a8_2d16_48b3_8641_ae8d9bce5223
{
    public class Class_Canvas : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SizeWidth = 0,
            SizeHeight = 1,
            ColorR = 2,
            ColorG = 3,
            ColorB = 4,
            ColorA = 5
        }
        //<<< _inputids
    
        private bool BuildRenderTarget(OperatorPartContext context, int width, int height) {
            var resourceChanged = ResourceManager.ValidateRenderTargetResource(ref _renderTargetResource, OperatorPart, context.D3DDevice,
                                                                               width, height);
            if (resourceChanged) {
                Utilities.DisposeObj(ref _renderTargetView);
                _renderTargetView = new RenderTargetView(context.D3DDevice, _renderTargetResource.Texture);
            }
            return resourceChanged;
        }

        public override void Dispose() {
            ResourceManager.Dispose(_renderTargetResource);
            Utilities.DisposeObj(ref _renderTargetView);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var SizeWidth = inputs[(int)InputId.SizeWidth].Eval(context).Value;
            var SizeHeight = inputs[(int)InputId.SizeHeight].Eval(context).Value;
            var Size = new Vector2(SizeWidth, SizeHeight);
            var ColorR = inputs[(int)InputId.ColorR].Eval(context).Value;
            var ColorG = inputs[(int)InputId.ColorG].Eval(context).Value;
            var ColorB = inputs[(int)InputId.ColorB].Eval(context).Value;
            var ColorA = inputs[(int)InputId.ColorA].Eval(context).Value;
            var Color = new Color4(ColorR, ColorG, ColorB, ColorA);
            //<<< _params


            if (BuildRenderTarget(context, (int)SizeWidth, (int)SizeHeight))
                Changed = true;

            if (Changed) {
                context.D3DDevice.ImmediateContext.ClearRenderTargetView(_renderTargetView, new SharpDX.Color4(ColorR, ColorG, ColorB, ColorA));
                Changed = false;
            }

            context.Image = _renderTargetResource.Texture;

            return context;
        }

        Resource _renderTargetResource;
        RenderTargetView _renderTargetView;
    }

}


