;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Dragon Attack - An entry for CPCRetroDev2016
;;  Copyright (C) 2016  Paul Kooistra
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;
;;  For questions about the source you can PM me, Axelay, on the CPCWiki forums
;;-------------------------------------------------------------------------------

; sfx precedence - lowest has highest precedence, only one channel used for fx
SFXBitBExp equ 0
SFXBitPlyExp equ 1
SFXBitDet equ 2
SFXBitNMELFire equ 3
SFXBitNMERFire equ 4
SFXBitNMEInv equ 5
SFXBitNMEHit equ 6
SFXBitPlyFire equ 7


.HandleSfx
; below comes from the arkos tracker player sfx comment, repeated here for reference
;	A = No Channel (0,1,2)
;	L = SFX Number (>0)
;	H = Volume (0...F)
;	E = Note (0...143)
;	D = Speed (0 = As original, 1...255 = new Speed (1 is the fastest))
;	BC = Inverted Pitch (-#FFFF -> FFFF). 0 is no pitch. The higher the pitch, the lower the sound.
;	call PLY_SFX_Play
    ld hl,SfxTrigger+1 ; is sfxtimer
    ld a,(hl)
    or a
    jr z,HSFXTimerClear ; no sfx active
; masking timer is non zero indicating sfx active, so reduce by one
    dec a
    ld (hl),a
.HSFXTimerClear
    dec l ; is now SfxTrigger
    ld a,(hl)
    ld (hl),0 ; clear any triggered fx
    or a
    ret z ; no new sound effect, dont waste time checking bits
; check which bit is set (see reference at top of this source file) and trigger that effect
    rra ; boss explosion
    jr c,Hsfx_BossExp
    rra ; player explosion
    jr c,Hsfx_PlyExp
    rra ; ring detonation
    jr c,Hsfx_RingDet
    rra ; enemy laser fire
    jr c,Hsfx_Laser
    rra ; enemy ring fire
    jr c,Hsfx_Ring
    rra ; enemy invulnerble
    jr c,Hsfx_Invulnerable
    rra ; hit hit
    jr c,Hsfx_EnemyHit
; was non zero, so must be last option, no check required
    jr Hsfx_PlayerShot

.Hsfx_EnemyHit
; hit boss invulnerable
    ld ix,FXTable+20 ; points to table containing the note, timer set, timer override value, volume
    ld c,5 ; sound effect number as defined in arkos sound effect file
    jr MngEfx_Chan2_Commmon
.Hsfx_Invulnerable
; hit boss invulnerable
    ld ix,FXTable+16
    ld c,6
    jr MngEfx_Chan2_Commmon
.Hsfx_BossExp
; player explosion
    ld ix,FXTable+12
    ld c,1
    jr MngEfx_Chan2_Commmon
.Hsfx_PlyExp
; player explosion
    ld ix,FXTable+24
    ld c,1
    jr MngEfx_Chan2_Commmon
.Hsfx_RingDet
; ring detonatation
    ld ix,FXTable+8
    ld c,4
    jr MngEfx_Chan2_Commmon
.Hsfx_Laser
; enemy laser fire
    ld ix,FXTable+4
    ld c,2
    jr MngEfx_Chan2_Commmon
.Hsfx_PlayerShot
; player fire - different process
    inc l ; point to timer
    ld a,(hl)
    or a
    ret nz ; if override timer is non zero, no player fire effect
    call cpct_getRandom_lcg_u8_asm ; get random number to generate variance in fire sfx
    and a,1 ; cap to 0-1
    add a,53
    ld e,a ; set note
    ld c,7 ; set effect number
    ld h,&c ; set volume
    jr MngEfx_Chan2_Commmon_Bypass
.Hsfx_Ring
; enemy fire
    ld ix,FXTable
    ld c,3

.MngEfx_Chan2_Commmon
    inc l ; point to current mask timer value
    ld a,(hl)
    cp a,(ix+2) ; compare it to the triggered sound effects override value
    ret nc ; other sfx with higher precedence still playing, sfxtimer is higher than the override value of the new sfx
; is ok to trigger new sfx
    ld a,(ix+1) ; get new sfx timer value
    ld (hl),a ; and write to timer
    ld h,(ix+3) ; get volume
    ld e,(ix+0) ; get note
.MngEfx_Chan2_Commmon_Bypass
    ld l,c ; put sfx number in l as required by player
;	A = No Channel (0,1,2)
;	L = SFX Number (>0)
;	H = Volume (0...F)
;	E = Note (0...143)
;	D = Speed (0 = As original, 1...255 = new Speed (1 is the fastest))
;	BC = Inverted Pitch (-#FFFF -> FFFF). 0 is no pitch. The higher the pitch, the lower the sound.
;	call PLY_SFX_Play
;    ld h,&f
    ld bc,0 ; use default pitch
    ld a,2 ; channel 2
    ld d,b ; original speed
    call PLY_SFX_Play ; trigger new sfx with arkos player call
    ret

.FXTable
; 2 enemy ring firing
    defb 60,6,5,15 ; note, timer set, timer override value, volume
; 3 enemy laser fire
    defb 48,6,5,15
; 4 ring explosion
    defb 36,20,15,15
; 5 boss explosion
    defb 24,25,24,15
; 6 enemy invulnerble
    defb 60+15,4,3,15
; 7 enemy hit
    defb 60,4,3,13
; 8 player explosion
    defb 18,25,24,15
