;;-----------------------------LICENSE NOTICE------------------------------------
;;  This file is part of Dragon Attack - An entry for CPCRetroDev2016
;;  Copyright (C) 2016  Paul Kooistra
;;
;;  This program is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License as published by
;;  the Free Software Foundation, either version 3 of the License, or
;;  (at your option) any later version.
;;
;;  This program is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License for more details.
;;
;;  You should have received a copy of the GNU General Public License
;;  along with this program.  If not, see <http://www.gnu.org/licenses/>.
;;
;;  For questions about the source you can PM me, Axelay, on the CPCWiki forums
;;-------------------------------------------------------------------------------

; defines the lists of lines of text for the menu pages
; the follwoing lines are the high score entries
Line18 equ &6820
Line19 equ 47+&6820
Line20 equ 2*47+&6820
Line21 equ 3*47+&6820
Line22 equ 4*47+&6820

.PageList
    defw MainMenuPage
    defw ControlPage
    defw OptionsPage
    defw LivesPage
    defw HighsPage
    defw FireModePage
    defw HighsEntryPage

.MainMenuPage
    defb 0,0,7,0,0,6,0,8,0,9,0,0,0
.ControlPage
    defb 0,0,1,0,2,0,3,0,4,0,5,0,0
.OptionsPage
    defb 0,0,10,0,11,0,12,0,24,0,0,13,0
.LivesPage
    defb 0,0,0,0,14,0,15,0,16,0,0,0,0
.HighsPage
    defb 17,0,18,0,19,0,20,0,21,0,22,0,13
.FireModePage
    defb 0,0,0,0,25,0,26,0,27,0,0,0,0
.HighsEntryPage
    defb 17,0,18,0,19,0,20,0,21,0,22,0,23

.LineIndex
    defw Line0
    defw Line1
    defw Line2
    defw Line3
    defw Line4
    defw Line5
    defw Line6
    defw Line7
    defw Line8
    defw Line9
    defw Line10
    defw Line11
    defw Line12
    defw Line13
    defw Line14
    defw Line15
    defw Line16
    defw Line17
    defw Line18
    defw Line19
    defw Line20
    defw Line21
    defw Line22
    defw Line23
    defw Line24
    defw Line25
    defw Line26
    defw Line27

.Line0 ; blank
    defb 128+64+32,&8f
    defb 128+64+32,0
    defb 255 ; end marker
.Line1 ; Control heading
    defb 128+64+10,&8f,128+11
    defb #db,#db,#43,#6f,#6e,#74,#72,#6f,#6c,#db,#db
    defb 128+64+11,&8f
    defb 128+64+10,0,128+1,1,128+64+8,0,192+2,1,192+11,0
    defb 255 ; end marker
.Line2 ; Joystick
    defb 192+11,&8f,128+8
    defb #4a,#6f,#79,#73,#74,#69,#63,#6b
    defb 192+13,&8f
    defb 192+11,0,128+1,&a,192+7,1,192+13,0
    defb 255 ; end marker
.Line3 ; Keyz
    defb 192+11,&8f,128+4
    defb #4b,#65,#79,#7a
    defb 192+17,&8f
    defb 192+11,0,128+1,&a,192+3,1,192+17,0
    defb 255 ; end marker
.Line4 ; Cursor
    defb 192+11,&8f,128+6
    defb #43,#75,#72,#73,#6f,#72
    defb 192+15,&8f
    defb 192+11,0,128+1,&a,192+5,1,192+15,0
    defb 255 ; end marker
.Line5 ; Multiplay P1
    defb 192+11,&8f,128+12
    defb #4d,#75,#6c,#74,#69,#70,#6c,#61,#79,#8f,#50,#31
    defb 192+9,&8f
    defb 192+11,0,128+1,&a,192+8,1,128+3,0,5,5,192+9,0
    defb 255 ; end marker
.Line6 ; Start Game
    defb 192+11,&8f,128+10
    defb "Start Game"
    defb 192+11,&8f
    defb 192+11,0,128+1,&a,192+9,1,192+11,0
    defb 255 ; end marker
.Line7 ;main menu heading
    defb 192+9,&8f,128+13
    defb #db,#db,#4d,#61,#69,#6e,#20,#4d,#65,#6e,#75,#d9,#d9
    defb 192+10,#8f
    defb 192+9,0,128+1,1,192+11,0,128+1,1,192+10,0
    defb 255 ; end marker
.Line8 ;options
    defb 192+11,&8f,128+7
    defb #4f,#70,#74,#69,#6f,#6e,#73
    defb 192+14,&8f
    defb 192+11,0,128+1,&a,192+6,1,192+14,0
    defb 255 ; end marker
.Line9 ;view highs
    defb 192+11,&8f,128+10
    defb #56,#69,#65,#77,#8f,#48,#69,#67,#68,#73
    defb 192+11,&8f
    defb 192+11,0,128+5,&a,1,1,1,0,192+5,1,192+11,0
    defb 255 ; end marker
.Line10 ;options
    defb 192+10,&8f,128+11
    defb #db,#db,#4f,#70,#74,#69,#6f,#6e,#73,#d9,#d9
    defb 192+11,&8f
    defb 192+10,0,128+1,1,192+9,0,128+1,1,192+11,0
    defb 255 ; end marker
.Line11 ;control
    defb 192+11,&8f,128+7
    defb #43,#6f,#6e,#74,#72,#6f,#6c
    defb 192+14,&8f
    defb 192+11,0,128+1,&a,192+6,1,192+14,0
    defb 255 ; end marker
.Line12 ;lives
    defb 192+11,&8f,128+5
    defb #4c,#69,#76,#65,#73
    defb 192+16,&8f
    defb 192+11,0,128+1,&a,192+4,1,192+16,0
    defb 255 ; end marker
.Line13 ;enter to return - changed to esc to exit
;    defb 192+8,&8f,128+15
;    defb #45,#4e,#54,#45,#52,#8f,#74,#6f
;    defb #8f,#72,#65,#74,#75,#72,#6e
;    defb 192+9,&8f
;    defb 192+8,0,192+5,&a,128+4,0,1,1,0,192+6,1,192+9,0
    defb 192+10,&8f,128+11
    defb "ESC to exit"
    defb 192+11,&8f
    defb 192+10,0,192+3,&a,192+8,1,192+11,0
    defb 255 ; end marker
.Line14 ;lives heading
    defb 192+11,&8f,128+9
    defb #db,#db,#4c,#69,#76,#65,#73,#d9,#d9
    defb 192+12,&8f
    defb 192+11,0,128+1,1,192+7,0,128+1,1,192+12,0
    defb 255 ; end marker
.Line15 ;select starting lives
    defb 192+5,&8f,128+22
    defb #53,#65,#6c,#65,#63,#74,#8f,#73,#74,#61,#72,#74,#69,#6e,#67,#8f,#6c,#69,#76
    defb #65,#73,#3a,192+5,#8f
    defb 192+5,0,192+6,1,128+1,0,192+8,1,128+1,0,192+6,1,192+5,0
    defb 255 ; end marker
.Line16 ;lives selection
    defb 192+7,&8f,128+17
    defb #31,#8f,#32,#8f,#33,#8f,#34,#8f,#35,#8f,#36,#8f,#37,#8f,#38,#8f,#39
    defb 192+8,&8f
    defb 192+7,0,128+17
    defb #0a,#00,#0a,#00,#0a,#00,#0a,#00,#0a,#00,#0a,#00,#0a,#00,#0a,#00,#0a
    defb 192+8,0
    defb 255 ; end marker
.Line17 ;highs heading
    defb 192+11,&8f,128+9
    defb #db,#db,#48,#69,#67,#68,#73,#d9,#d9
    defb 192+12,&8f
    defb 192+11,0,128+1,1,192+7,0,128+1,1,192+12,0
    defb 255 ; end marker
.Line23 ;highs entry prompt
    defb 192+8,&8f,128+15
    text "Enter your name"
    defb 192+9,&8f
    defb 192+8,0,192+15,1,192+9,0
    defb 255 ; end marker
.Line24 ;fire mode
    defb 192+11,&8f,128+9
    defb "Fire Mode"
    defb 192+12,&8f
    defb 192+11,0,128+1,&a,192+8,1,192+12,0
    defb 255 ; end marker
.Line25 ;fire mode heading
    defb 192+9,&8f,128+13
    text #db,#db,"Fire Mode",#d9,#d9
    defb 192+10,#8f
    defb 192+9,0,128+1,1,192+11,0,128+1,1,192+10,0
    defb 255 ; end marker
.Line26 ; Normal
    defb 192+11,&8f,128+8
    text "Standard"
    defb 192+13,&8f
    defb 192+11,0,128+1,&a,192+7,1,192+13,0
    defb 255 ; end marker
.Line27 ; Inverted
    defb 192+11,&8f,128+8
    text "Inverted"
    defb 192+13,&8f
    defb 192+11,0,128+1,&a,192+7,1,192+13,0
    defb 255 ; end marker
