//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "sprites.h"

// Tiles.
const u8 kTileBasic01[64] = {
    0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x0C, 0x48,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x1C, 0x2C, 0x68,
	0x1C, 0x1C, 0x2C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x1C, 0x2C, 0x68,
	0x1C, 0x1C, 0x2C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x48, 0xC0, 0xC0, 0xC0,
	0xC0, 0xC0, 0xC0, 0xC0};

const u8 kTileEnd[64] = {
    0x00, 0x15, 0x2A, 0x00,
	0x00, 0x15, 0x2A, 0x00,
	0x00, 0x41, 0x82, 0x00,
	0x00, 0x41, 0x82, 0x00,
	0x00, 0x41, 0x82, 0x00,
	0x00, 0x41, 0x82, 0x00,
	0x00, 0x3F, 0x3F, 0x00,
	0x00, 0x3F, 0x3F, 0x00,
	0x00, 0x55, 0x20, 0x00,
	0x00, 0x55, 0x20, 0x00,
	0x00, 0x55, 0x20, 0x00,
	0x00, 0x55, 0x20, 0x00,
	0x00, 0x55, 0x20, 0x00,
	0x00, 0x55, 0x20, 0x00,
	0x00, 0x55, 0x20, 0x00,
	0x00, 0x55, 0x20, 0x00};

const u8 kTileLaserVertical[64] = {
    0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64,
	0x98, 0x75, 0xBA, 0x64};

const u8 kTileLaserHorizontal[64] = {
    0xCC, 0xCC, 0xCC, 0xCC,
	0xCC, 0xCC, 0xCC, 0xCC,
	0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30,
	0xCC, 0xCC, 0xCC, 0xCC,
	0xCC, 0xCC, 0xCC, 0xCC};

const u8 kTileDeformBlock01[64] = {
    0x0C, 0x0C, 0x0C, 0x0C,
	0x0C, 0x0C, 0x0C, 0x48,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x1E, 0x2D, 0x68,
	0x1C, 0x1E, 0x2D, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x1C, 0x1E, 0x2D, 0x68,
	0x1C, 0x1E, 0x2D, 0x68,
	0x1C, 0x3C, 0x3C, 0x68,
	0x48, 0xC0, 0xC0, 0xC0,
	0xC0, 0xC0, 0xC0, 0xC0};

const u8 kTileDeformBlock02[64] = {
    0xC0, 0xC0, 0xC0, 0xC0,
	0xC0, 0xC0, 0xC0, 0x80,
	0xC1, 0xC3, 0xC3, 0x82,
	0xC1, 0x41, 0x82, 0x82,
	0xC1, 0x41, 0x82, 0x82,
	0xC1, 0xC3, 0xC3, 0x82,
	0xC1, 0xC3, 0xC3, 0x82,
	0xC1, 0xC3, 0xC3, 0x82,
	0xC1, 0xC3, 0xC3, 0x82,
	0xC1, 0xC3, 0xC3, 0x82,
	0xC1, 0xC3, 0xC3, 0x82,
	0xC1, 0x41, 0x82, 0x82,
	0xC1, 0x41, 0x82, 0x82,
	0xC1, 0xC3, 0xC3, 0x82,
	0x80, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00};

const u8 kPlayerIdleRight01[64] = {
    0x15, 0x3F, 0x3F, 0x2A,
	0x15, 0x3F, 0x3F, 0x3F,
	0x3F, 0x3B, 0x3F, 0x3F,
	0x3F, 0x33, 0x33, 0x37,
	0x3F, 0x55, 0x22, 0xBF,
	0x3F, 0x00, 0x22, 0x11,
	0x3F, 0x33, 0x33, 0x33,
	0x3F, 0x33, 0x33, 0x33,
	0x3F, 0x33, 0x33, 0x33,
	0x3F, 0x33, 0x11, 0x33,
	0x3F, 0x33, 0x00, 0x33,
	0x3F, 0x33, 0x33, 0x33,
	0x3F, 0x33, 0x33, 0x22,
	0x6B, 0x82, 0x41, 0x82,
	0x41, 0x82, 0x41, 0x82,
	0x41, 0x82, 0x41, 0x82 };

const u8 kPlayerIdleRight02[64] = {
    0x00, 0x00, 0x00, 0x15,
	0x15, 0x3F, 0x3F, 0x3F,
	0x15, 0x3F, 0x3F, 0x3F,
	0x3F, 0x3B, 0x3F, 0x3F,
	0x3F, 0x33, 0x33, 0x37,
	0x3F, 0x55, 0x22, 0xBB,
	0x3F, 0x00, 0x22, 0x11,
	0x3F, 0x33, 0x33, 0x33,
	0x3F, 0x33, 0x33, 0x33,
	0x3F, 0x33, 0x33, 0x33,
	0x3F, 0x33, 0x11, 0x33,
	0x3F, 0x33, 0x00, 0x33,
	0x3F, 0x33, 0x33, 0x33,
	0x3F, 0x33, 0x33, 0x22,
	0x3F, 0x82, 0x41, 0x82,
	0x41, 0x82, 0x41, 0x82 };

const u8 kPlayerIdleLeft01[64] = {
    0x15, 0x3F, 0x3F, 0x2A,
	0x3F, 0x3F, 0x3F, 0x2A,
	0x3F, 0x3B, 0x37, 0x3F,
	0x3F, 0x33, 0x33, 0x3F,
	0x7F, 0x11, 0xAA, 0x3F,
	0x22, 0x11, 0x00, 0x3F,
	0x33, 0x33, 0x33, 0x3F,
	0x33, 0x33, 0x33, 0x3F,
	0x33, 0x33, 0x33, 0x3F,
	0x33, 0x22, 0x33, 0x3F,
	0x33, 0x00, 0x33, 0x3F,
	0x33, 0x33, 0x33, 0x3F,
	0x11, 0x33, 0x33, 0x3F,
	0x41, 0x82, 0x41, 0x97,
	0x41, 0x82, 0x41, 0x82,
	0x41, 0x82, 0x41, 0x82 };

const u8 kPlayerIdleLeft02[64] = {
    0x2A, 0x00, 0x00, 0x00,
	0x3F, 0x3F, 0x3F, 0x2A,
	0x3F, 0x3F, 0x3F, 0x2A,
	0x3F, 0x3B, 0x37, 0x3F,
	0x3B, 0x33, 0x33, 0x3F,
	0x77, 0x11, 0xAA, 0x3F,
	0x22, 0x11, 0x00, 0x3F,
	0x33, 0x33, 0x33, 0x3F,
	0x33, 0x33, 0x33, 0x3F,
	0x33, 0x33, 0x33, 0x3F,
	0x33, 0x22, 0x33, 0x3F,
	0x33, 0x00, 0x33, 0x3F,
	0x33, 0x33, 0x33, 0x3F,
	0x11, 0x33, 0x33, 0x3F,
	0x41, 0x82, 0x41, 0x3F,
	0x41, 0x82, 0x41, 0x82 };

const u8 kPlayerWin01[64] = {
    0x15, 0x3F, 0x3F, 0x2A,
	0x15, 0x3F, 0x3F, 0x2A,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x3B, 0x37, 0x3F,
	0x3F, 0x33, 0x33, 0x3F,
	0x2A, 0xBB, 0x77, 0x15,
	0x2A, 0x11, 0x22, 0x15,
	0x33, 0x33, 0x33, 0x33,
	0x33, 0x33, 0x33, 0x33,
	0x33, 0x77, 0xBB, 0x33,
	0x3B, 0x22, 0x11, 0x37,
	0x3B, 0x33, 0x33, 0x37,
	0x3B, 0x33, 0x33, 0x37,
	0x6B, 0x82, 0x41, 0x97,
	0x6B, 0x82, 0x41, 0x97,
	0x41, 0x82, 0x41, 0x82 };

const u8 kPlayerJumpRight01[64] = {
    0x00, 0x3F, 0x3F, 0x2A,
	0x15, 0x3F, 0x3F, 0x2A,
	0x15, 0x3B, 0x3F, 0x3F,
	0x3F, 0x33, 0x33, 0x37,
	0x3F, 0x55, 0x33, 0x33,
	0x3F, 0x00, 0x22, 0xBB,
	0x3F, 0x33, 0x22, 0x11,
	0x3B, 0x33, 0x33, 0x33,
	0x3B, 0x33, 0x33, 0x33,
	0x3B, 0x22, 0x33, 0x22,
	0x3B, 0x22, 0x11, 0x22,
	0x3B, 0x33, 0x33, 0x22,
	0x3B, 0x33, 0x33, 0x22,
	0x41, 0x82, 0x41, 0x82,
	0xC3, 0x00, 0xC3, 0x00,
	0xC3, 0x00, 0xC3, 0x00 };

const u8 kPlayerJumpRight02[64] = {
    0x15, 0x3F, 0x00, 0x00,
	0x15, 0x3F, 0x3F, 0x2A,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x33, 0x3F, 0x3F,
	0x3F, 0x55, 0x33, 0x37,
	0x3F, 0x00, 0x22, 0xBB,
	0x3F, 0x33, 0x22, 0x11,
	0x3F, 0x33, 0x33, 0x33,
	0x3B, 0x33, 0x33, 0x33,
	0x3B, 0x22, 0x33, 0x33,
	0x3B, 0x22, 0x11, 0x22,
	0x3B, 0x33, 0x33, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x41, 0x82, 0x41, 0x82,
	0xC3, 0x00, 0xC3, 0x00,
	0xC3, 0x00, 0xC3, 0x00 };

const u8 kPlayerJumpLeft01[64] = {
    0x15, 0x3F, 0x00, 0x00,
	0x15, 0x3F, 0x3F, 0x2A,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x33, 0x3F, 0x3F,
	0x33, 0x33, 0xAA, 0x3F,
	0x77, 0x11, 0x00, 0x3F,
	0x22, 0x11, 0x33, 0x37,
	0x33, 0x33, 0x33, 0x37,
	0x33, 0x33, 0x33, 0x37,
	0x11, 0x33, 0x11, 0x37,
	0x11, 0x22, 0x11, 0x37,
	0x11, 0x33, 0x33, 0x37,
	0x11, 0x33, 0x33, 0x37,
	0x41, 0x82, 0x41, 0x82,
	0x00, 0xC3, 0x00, 0xC3,
	0x00, 0xC3, 0x00, 0xC3 };

const u8 kPlayerJumpLeft02[64] = {
    0x00, 0x3F, 0x3F, 0x2A,
	0x15, 0x3F, 0x3F, 0x3F,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x33, 0x3F, 0x3F,
	0x3F, 0x33, 0xAA, 0x3F,
	0x7F, 0x11, 0x00, 0x3F,
	0x2A, 0x11, 0x33, 0x37,
	0x33, 0x33, 0x33, 0x37,
	0x33, 0x33, 0x33, 0x37,
	0x33, 0x33, 0x11, 0x37,
	0x11, 0x22, 0x11, 0x37,
	0x11, 0x33, 0x33, 0x37,
	0x11, 0x33, 0x33, 0x22,
	0x41, 0x82, 0x41, 0x82,
	0x00, 0xC3, 0x00, 0xC3,
	0x00, 0xC3, 0x00, 0xC3 };

const u8 kPlayerFallRight01[64] = {
    0x00, 0x2A, 0x00, 0x2A,
	0x15, 0x3F, 0x15, 0x2A,
	0x3F, 0x3F, 0x3F, 0x2A,
	0x3F, 0x33, 0x37, 0x3F,
	0x3F, 0x55, 0x33, 0x3F,
	0x3B, 0x00, 0x22, 0xBB,
	0x3B, 0x33, 0x22, 0x11,
	0x3B, 0x33, 0x33, 0x33,
	0x3B, 0x33, 0x33, 0x33,
	0x3B, 0x22, 0x33, 0x22,
	0x3B, 0x22, 0x11, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x41, 0x82, 0x41, 0x82,
	0xC3, 0x00, 0xC3, 0x00,
	0xC3, 0x00, 0xC3, 0x00 };

const u8 kPlayerFallRight02[64] = {
    0x2A, 0x15, 0x15, 0x2A,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x33, 0x37, 0x33,
	0x3F, 0x55, 0x33, 0x33,
	0x3B, 0x00, 0x22, 0xBB,
	0x3B, 0x33, 0x22, 0x11,
	0x3B, 0x33, 0x33, 0x33,
	0x3B, 0x33, 0x33, 0x33,
	0x3B, 0x22, 0x33, 0x22,
	0x3B, 0x22, 0x11, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x41, 0x82, 0x41, 0x82,
	0xC3, 0x00, 0xC3, 0x00,
	0xC3, 0x00, 0xC3, 0x00 };

const u8 kPlayerFallLeft01[64] = {
    0x00, 0x15, 0x15, 0x2A,
	0x15, 0x3F, 0x3F, 0x3F,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x33, 0x3F, 0x3F,
	0x33, 0x33, 0xAA, 0x3F,
	0x77, 0x11, 0x00, 0x3F,
	0x22, 0x11, 0x33, 0x37,
	0x33, 0x33, 0x33, 0x37,
	0x33, 0x33, 0x33, 0x37,
	0x11, 0x33, 0x11, 0x37,
	0x11, 0x22, 0x11, 0x37,
	0x11, 0x33, 0x33, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x41, 0x82, 0x41, 0x82,
	0x00, 0xC3, 0x00, 0xC3,
	0x00, 0xC3, 0x00, 0xC3 };

const u8 kPlayerFallLeft02[64] = {
    0x15, 0x00, 0x3F, 0x2A,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x33, 0x3F, 0x3F,
	0x33, 0x33, 0xAA, 0x3F,
	0x77, 0x11, 0x00, 0x3F,
	0x22, 0x11, 0x33, 0x37,
	0x33, 0x33, 0x33, 0x37,
	0x33, 0x33, 0x33, 0x37,
	0x11, 0x33, 0x11, 0x37,
	0x11, 0x22, 0x11, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x41, 0x82, 0x41, 0x82,
	0x00, 0xC3, 0x00, 0xC3,
	0x00, 0xC3, 0x00, 0xC3 };

const u8 kPlayerDeath01[64] = {
    0x15, 0x3F, 0x3F, 0x2A,
	0x15, 0x3F, 0x3F, 0x2A,
	0x3F, 0x3F, 0x3F, 0x3F,
	0x3F, 0x3B, 0x37, 0x3F,
	0x3F, 0x33, 0x33, 0x3F,
	0x7F, 0xBB, 0x77, 0xBF,
	0x7F, 0xBB, 0x77, 0xBF,
	0x33, 0x33, 0x33, 0x33,
	0x33, 0x33, 0x33, 0x33,
	0x33, 0x77, 0xBB, 0x33,
	0x3B, 0x22, 0x11, 0x37,
	0x3B, 0x33, 0x33, 0x37,
	0x3B, 0x33, 0x33, 0x37,
	0x6B, 0x82, 0x41, 0x97,
	0x6B, 0x82, 0x41, 0x97,
	0x41, 0x82, 0x41, 0x82 };

const u8 kPlayerDeath02[64] = {
    0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x15, 0x3F, 0x3F, 0x2A,
	0x15, 0x3B, 0x37, 0x2A,
	0x15, 0x33, 0x33, 0x2A,
	0x55, 0xBB, 0x77, 0xAA,
	0x55, 0xBB, 0x77, 0xAA,
	0x11, 0x33, 0x33, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x11, 0x77, 0xBB, 0x22,
	0x11, 0x22, 0x11, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x11, 0x33, 0x33, 0x22,
	0x41, 0x82, 0x41, 0x82,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00 };

const u8 kPlayerDeath03[64] = {
    0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x33, 0x33, 0x00,
	0x00, 0xBB, 0x77, 0x00,
	0x00, 0xBB, 0x77, 0x00,
	0x00, 0x33, 0x33, 0x00,
	0x00, 0x33, 0x33, 0x00,
	0x00, 0x77, 0xBB, 0x00,
	0x00, 0x22, 0x11, 0x00,
	0x00, 0x33, 0x33, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00 };

const u8 kPlayerDeath04[64] = {
    0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x11, 0x22, 0x00,
	0x00, 0x11, 0x22, 0x00,
	0x00, 0x11, 0x22, 0x00,
	0x00, 0x55, 0xAA, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00 };

const u8 kPlayerDeath05[64] = {
    0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00 };

const u8 kBlock01[64] = {
    0x00, 0xAA, 0x55, 0x00,
	0x00, 0xAA, 0x55, 0x00,
	0x40, 0xC0, 0xC0, 0x80,
	0x40, 0xC0, 0xC0, 0x80,
	0xEA, 0x3C, 0x3C, 0xD5,
	0xEA, 0x94, 0x68, 0xD5,
	0x40, 0x3C, 0x3C, 0x80,
	0x40, 0x3C, 0x3C, 0x80,
	0x40, 0x3C, 0x3C, 0x80,
	0x40, 0x3C, 0x3C, 0x80,
	0xEA, 0x94, 0x68, 0xD5,
	0xEA, 0x3C, 0x3C, 0xD5,
	0x40, 0xC0, 0xC0, 0x80,
	0x40, 0xC0, 0xC0, 0x80,
	0x00, 0xAA, 0x55, 0x00,
	0x00, 0xAA, 0x55, 0x00 };

const u8 kBlock02[64] = {
    0x00, 0x55, 0x00, 0xAA,
	0x00, 0x55, 0x00, 0xAA,
	0xEA, 0xC0, 0xC0, 0x80,
	0xEA, 0xC0, 0xC0, 0x80,
	0x40, 0x3C, 0x3C, 0x80,
	0x40, 0x94, 0x68, 0x80,
	0x40, 0x3C, 0x3C, 0xD5,
	0x40, 0x3C, 0x3C, 0xD5,
	0xEA, 0x3C, 0x3C, 0x80,
	0xEA, 0x3C, 0x3C, 0x80,
	0x40, 0x94, 0x68, 0x80,
	0x40, 0x3C, 0x3C, 0x80,
	0x40, 0xC0, 0xC0, 0xD5,
	0x40, 0xC0, 0xC0, 0xD5,
	0x55, 0x00, 0xAA, 0x00,
	0x55, 0x00, 0xAA, 0x00 };

const u8 kBlock03[64] = {
    0x55, 0x00, 0xAA, 0x00,
	0x55, 0x00, 0xAA, 0x00,
	0x40, 0xC0, 0xC0, 0xD5,
	0x40, 0xC0, 0xC0, 0xD5,
	0x40, 0x3C, 0x3C, 0x80,
	0x40, 0x94, 0x68, 0x80,
	0xEA, 0x3C, 0x3C, 0x80,
	0xEA, 0x3C, 0x3C, 0x80,
	0x40, 0x3C, 0x3C, 0xD5,
	0x40, 0x3C, 0x3C, 0xD5,
	0x40, 0x94, 0x68, 0x80,
	0x40, 0x3C, 0x3C, 0x80,
	0xEA, 0xC0, 0xC0, 0x80,
	0xEA, 0xC0, 0xC0, 0x80,
	0x00, 0x55, 0x00, 0xAA,
	0x00, 0x55, 0x00, 0xAA };

const u8 kNumber0[16] = {
    0x55, 0xFF,
	0x55, 0xFF,
	0x55, 0x55,
	0x55, 0x55,
	0x55, 0x55,
	0x55, 0x55,
	0x55, 0xFF,
	0x55, 0xFF};


const u8 kNumber1[16] = {
    0x00, 0xAA,
	0x55, 0xAA,
	0x55, 0xAA,
	0x00, 0xAA,
	0x00, 0xAA,
	0x00, 0xAA,
	0x55, 0xFF,
	0x55, 0xFF};


const u8 kNumber2[16] = {
    0x55, 0xFF,
	0x55, 0xFF,
	0x55, 0x55,
	0x00, 0x55,
	0x00, 0xFF,
	0x55, 0xAA,
	0x55, 0xFF,
	0x55, 0xFF};


const u8 kNumber3[16] = {
    0x55, 0xFF,
	0x55, 0xFF,
	0x00, 0x55,
	0x00, 0xFF,
	0x00, 0xFF,
	0x00, 0x55,
	0x55, 0xFF,
	0x55, 0xFF};


const u8 kNumber4[16] = {
    0x55, 0x55,
	0x55, 0x55,
	0x55, 0x55,
	0x55, 0xFF,
	0x55, 0xFF,
	0x00, 0x55,
	0x00, 0x55,
	0x00, 0x55};


const u8 kNumber5[16] = {
    0x55, 0xFF,
	0x55, 0xFF,
	0x55, 0x00,
	0x55, 0xFF,
	0x55, 0xFF,
	0x00, 0x55,
	0x55, 0xFF,
	0x55, 0xFF};


const u8 kNumber6[16] = {
    0x55, 0xFF,
	0x55, 0xFF,
	0x55, 0x00,
	0x55, 0xFF,
	0x55, 0x55,
	0x55, 0x55,
	0x55, 0xFF,
	0x55, 0xFF};


const u8 kNumber7[16] = {
    0x55, 0xFF,
	0x55, 0xFF,
	0x00, 0x55,
	0x00, 0x55,
	0x00, 0x55,
	0x00, 0x55,
	0x00, 0x55,
	0x00, 0x55};


const u8 kNumber8[16] = {
    0x55, 0xFF,
	0x55, 0x55,
	0x55, 0x55,
	0x55, 0xFF,
	0x55, 0xFF,
	0x55, 0x55,
	0x55, 0x55,
	0x55, 0xFF};


const u8 kNumber9[16] = {
    0x55, 0xFF,
	0x55, 0xFF,
	0x55, 0x55,
	0x55, 0xFF,
	0x55, 0xFF,
	0x00, 0x55,
	0x55, 0xFF,
	0x55, 0xFF};


const u8 kNumberDots[16] = {
    0x00, 0x00,
	0x00, 0xAA,
	0x00, 0xAA,
	0x00, 0x00,
	0x00, 0x00,
	0x00, 0xAA,
	0x00, 0xAA,
	0x00, 0x00};

const u8 kDefeatsIcon[16] = {
    0x33, 0x33,
    0xBB, 0x77,
    0xBB, 0x77,
    0x33, 0x33,
    0x33, 0x33,
    0x77, 0xBB,
    0x22, 0x11,
    0x33, 0x33};

const u8 kTimeIcon[16] = {
    0x15, 0x3F,
	0x15, 0x3F,
	0x00, 0x2A,
	0x00, 0xA2,
	0x00, 0xA2,
	0x00, 0xA2,
	0x00, 0x0A,
	0x00, 0x0A};

const u8 kPlayText[88] = {
	0x55, 0x00, 0x00, 0xFF, 0xAA, 0xAA, 0x00, 0xFF, 0xAA, 0xAA, 0xAA,
	0xFF, 0x00, 0x00, 0xFF, 0xAA, 0xAA, 0x00, 0xFF, 0xAA, 0xAA, 0xAA,
	0xFF, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0x00, 0xAA, 0xAA, 0xAA, 0xAA,
	0x55, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0x00, 0xAA, 0xAA, 0xFF, 0xAA,
	0x55, 0x00, 0x00, 0xFF, 0xAA, 0xAA, 0x00, 0xFF, 0xAA, 0xFF, 0xAA,
	0x55, 0x00, 0x00, 0xFF, 0xAA, 0xAA, 0x00, 0xFF, 0xAA, 0x55, 0x00,
	0xFF, 0xAA, 0xAA, 0xAA, 0x00, 0xFF, 0xAA, 0xAA, 0xAA, 0x55, 0x00,
	0xFF, 0xAA, 0xAA, 0xAA, 0x00, 0xFF, 0xAA, 0xAA, 0xAA, 0x55, 0x00};

const u8 kAuthorText[192] = {
	0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00,
	0xFF, 0xAA, 0xFF, 0xAA, 0x55, 0x00, 0xFF, 0xAA,
	0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00,
	0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0x00, 0xFF, 0xAA,
	0xAA, 0x00, 0xAA, 0xAA, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0xAA, 0xAA, 0x00, 0xAA, 0x00, 0x00, 0x00,
	0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0x00, 0xAA, 0x00,
	0xAA, 0x00, 0xAA, 0xAA, 0xAA, 0x00, 0xFF, 0x00, 0xAA, 0xAA, 0xAA, 0x00, 0xFF, 0x00, 0x55, 0x00,
	0x00, 0xAA, 0xAA, 0xAA, 0x55, 0x00, 0xFF, 0xAA,
	0xAA, 0x00, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0x00, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0x00, 0x55, 0x00,
	0x55, 0xAA, 0xAA, 0xAA, 0x55, 0x00, 0xAA, 0xAA,
	0xAA, 0x00, 0xFF, 0xAA, 0x00, 0xAA, 0xAA, 0x00, 0xAA, 0xAA, 0x00, 0xAA, 0xAA, 0x00, 0x00, 0x00,
	0xFF, 0x00, 0xAA, 0xAA, 0x55, 0x00, 0xAA, 0xAA,
	0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00,
	0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0x55, 0x00, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00,
	0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA};


const u8 kTitleHair[432] = {
	0x3F, 0x82, 0x15, 0x6B, 0x15, 0x3F, 0x3F, 0x3F, 0x82, 0x3F, 0x3F, 0x3F, 0x6B, 0x15, 0x3F, 0x3F,
	0x82, 0x00,
	0x3F, 0x82, 0x15, 0x6B, 0x15, 0x3F, 0x3F, 0x3F, 0x82, 0x3F, 0x3F, 0x3F, 0x6B, 0x15, 0x3F, 0x3F,
	0x6B, 0x00,
	0x7B, 0x82, 0x15, 0xE3, 0x15, 0xB7, 0xB7, 0x7B, 0x82, 0x7B, 0x7B, 0x3F, 0xE3, 0x15, 0xB7, 0xB7,
	0x6B, 0x00,
	0xF3, 0x82, 0x51, 0xE3, 0x51, 0xF3, 0xF3, 0xF3, 0x82, 0xF3, 0xF3, 0xF3, 0xE3, 0x51, 0xF3, 0xF3,
	0xF3, 0x82,
	0xF3, 0x82, 0x51, 0xE3, 0x51, 0xE3, 0xC3, 0xF3, 0x82, 0xF3, 0xF3, 0xF3, 0xE3, 0x51, 0xE3, 0xC3,
	0xF3, 0x82,
	0xF3, 0x82, 0x51, 0xE3, 0x51, 0xE3, 0xC3, 0xF3, 0x82, 0xF3, 0xF3, 0xF3, 0xE3, 0x51, 0xE3, 0xC3,
	0xF3, 0x82,
	0xF3, 0x82, 0x51, 0xE3, 0x51, 0xE3, 0x00, 0xF3, 0x82, 0x00, 0xF3, 0xE3, 0x00, 0x51, 0xE3, 0x00,
	0xF3, 0x82,
	0xA7, 0x82, 0x51, 0x4B, 0x51, 0x4B, 0x00, 0xA7, 0x82, 0x00, 0xA7, 0xE3, 0x00, 0x51, 0x4B, 0x00,
	0xA7, 0x82,
	0xA7, 0x82, 0x51, 0x4B, 0x51, 0x4B, 0x00, 0xA7, 0x82, 0x00, 0xA7, 0xE3, 0x00, 0x51, 0x4B, 0x00,
	0xA7, 0x82,
	0x0F, 0x82, 0x05, 0x4B, 0x05, 0x4B, 0x00, 0x0F, 0x82, 0x00, 0x0F, 0x4B, 0x00, 0x05, 0x4B, 0x00,
	0x0F, 0x82,
	0x0F, 0x0F, 0x0F, 0x4B, 0x05, 0x0F, 0x0F, 0x0F, 0x82, 0x00, 0x0F, 0x4B, 0x00, 0x05, 0x0F, 0x0F,
	0x4B, 0x00,
	0x0F, 0x0F, 0x0F, 0x4B, 0x05, 0x0F, 0x0F, 0x0F, 0x82, 0x00, 0x0F, 0x4B, 0x00, 0x05, 0x0F, 0x0F,
	0x4B, 0x00,
	0x0F, 0x0F, 0x0F, 0x4B, 0x05, 0x0F, 0x0F, 0x0F, 0x82, 0x00, 0x0F, 0x4B, 0x00, 0x05, 0x0F, 0x0F,
	0x4B, 0x00,
	0x0F, 0x0F, 0x0F, 0x4B, 0x05, 0x0F, 0x0F, 0x0F, 0x82, 0x00, 0x0F, 0x4B, 0x00, 0x05, 0x0F, 0x0F,
	0x4B, 0x00,
	0x0F, 0xC3, 0x87, 0x4B, 0x05, 0x4B, 0xC3, 0x0F, 0x82, 0x00, 0x0F, 0x4B, 0x00, 0x05, 0x0F, 0x0F,
	0x82, 0x00,
	0x5B, 0xC3, 0x87, 0xE3, 0x05, 0xE3, 0xC3, 0x5B, 0x82, 0x00, 0x5B, 0x4B, 0x00, 0x05, 0xA7, 0xA7,
	0x82, 0x00,
	0x5B, 0x82, 0x05, 0xE3, 0x05, 0xE3, 0x00, 0x5B, 0x82, 0x00, 0x5B, 0x4B, 0x00, 0x05, 0xE3, 0xD3,
	0x4B, 0x00,
	0x5B, 0x82, 0x05, 0xE3, 0x05, 0xE3, 0x00, 0x5B, 0x82, 0x00, 0x5B, 0x4B, 0x00, 0x05, 0xE3, 0xD3,
	0x4B, 0x00,
	0xF3, 0x82, 0x51, 0xE3, 0x51, 0xE3, 0x00, 0xF3, 0x82, 0xF3, 0xF3, 0xF3, 0xE3, 0x51, 0xE3, 0x41,
	0xE3, 0x00,
	0xF3, 0x82, 0x51, 0xE3, 0x51, 0xE3, 0x00, 0xF3, 0x82, 0xF3, 0xF3, 0xF3, 0xE3, 0x51, 0xE3, 0x41,
	0xE3, 0x00,
	0xB7, 0x82, 0x51, 0x6B, 0x51, 0x6B, 0x00, 0xB7, 0x82, 0xB7, 0xB7, 0xF3, 0x6B, 0x51, 0x6B, 0x00,
	0xB7, 0x82,
	0xB7, 0x82, 0x51, 0x6B, 0x51, 0x6B, 0x00, 0xB7, 0x82, 0xB7, 0xB7, 0xF3, 0x6B, 0x51, 0x6B, 0x00,
	0xB7, 0x82,
	0x3F, 0x82, 0x15, 0x6B, 0x15, 0x6B, 0x00, 0x3F, 0x82, 0x3F, 0x3F, 0x3F, 0x6B, 0x15, 0x6B, 0x00,
	0x3F, 0x82,
	0x3F, 0x82, 0x15, 0x6B, 0x15, 0x6B, 0x00, 0x3F, 0x82, 0x3F, 0x3F, 0x3F, 0x6B, 0x15, 0x6B, 0x00,
	0x3F, 0x82};


const u8 kTitleBoy[312] = {
	0x3F, 0x3F, 0x6B, 0x00, 0x15, 0x3F, 0x3F, 0x3F, 0x82, 0x3F, 0x82, 0x15, 0x6B,
	0x3F, 0x3F, 0x3F, 0x82, 0x15, 0x3F, 0x3F, 0x3F, 0x82, 0x3F, 0x82, 0x15, 0x6B,
	0x7B, 0x7B, 0x3F, 0x82, 0x15, 0xB7, 0xB7, 0x7B, 0x82, 0x7B, 0x82, 0x15, 0xE3,
	0xF3, 0xF3, 0xF3, 0xE3, 0x51, 0xF3, 0xF3, 0xF3, 0x82, 0xF3, 0x82, 0x51, 0xE3,
	0xF3, 0xC3, 0xD3, 0xE3, 0x51, 0xF3, 0xF3, 0xF3, 0x82, 0xF3, 0x82, 0x51, 0xE3,
	0xF3, 0xC3, 0xD3, 0xE3, 0x51, 0xF3, 0xF3, 0xF3, 0x82, 0xF3, 0x82, 0x51, 0xE3,
	0xF3, 0x82, 0x51, 0xE3, 0x51, 0xE3, 0xC3, 0xF3, 0x82, 0xF3, 0x82, 0x51, 0xE3,
	0xA7, 0x82, 0x51, 0x4B, 0x51, 0x4B, 0xC3, 0xA7, 0x82, 0xA7, 0x82, 0x51, 0x4B,
	0xA7, 0x82, 0x51, 0x4B, 0x51, 0x4B, 0x00, 0xA7, 0x82, 0xA7, 0xA7, 0xF3, 0x4B,
	0x0F, 0x82, 0x05, 0x4B, 0x05, 0x4B, 0x00, 0x0F, 0x82, 0x0F, 0x0F, 0x0F, 0x4B,
	0x0F, 0x0F, 0x0F, 0x82, 0x05, 0x4B, 0x00, 0x0F, 0x82, 0x0F, 0x0F, 0x0F, 0xC3,
	0x0F, 0x0F, 0x0F, 0x82, 0x05, 0x4B, 0x00, 0x0F, 0x82, 0x05, 0x0F, 0x0F, 0x82,
	0x0F, 0xC3, 0x87, 0x82, 0x05, 0x4B, 0x00, 0x0F, 0x82, 0x05, 0x0F, 0x4B, 0x82,
	0x0F, 0xC3, 0x87, 0x82, 0x05, 0x4B, 0x00, 0x0F, 0x82, 0x00, 0x0F, 0x4B, 0x00,
	0x0F, 0x82, 0x05, 0x82, 0x05, 0x4B, 0x00, 0x0F, 0x82, 0x00, 0x0F, 0x4B, 0x00,
	0x5B, 0x82, 0x05, 0xE3, 0x05, 0xE3, 0x00, 0x5B, 0x82, 0x00, 0x5B, 0xE3, 0x00,
	0x5B, 0x82, 0x05, 0xE3, 0x05, 0xA7, 0xF3, 0x5B, 0x82, 0x00, 0x5B, 0xE3, 0x00,
	0x5B, 0x82, 0x05, 0xE3, 0x05, 0xA7, 0xF3, 0x5B, 0x82, 0x00, 0x5B, 0xE3, 0x00,
	0xF3, 0xF3, 0xF3, 0xE3, 0x51, 0xF3, 0xF3, 0xF3, 0x82, 0x00, 0xF3, 0xE3, 0x00,
	0xF3, 0xF3, 0xF3, 0xE3, 0x51, 0xF3, 0xF3, 0xF3, 0x82, 0x00, 0xF3, 0xE3, 0x00,
	0xB7, 0xB7, 0x7B, 0x6B, 0x51, 0x7B, 0x3F, 0xB7, 0x82, 0x00, 0xB7, 0x6B, 0x00,
	0xB7, 0xB7, 0x7B, 0x82, 0x51, 0x7B, 0x3F, 0xB7, 0x82, 0x00, 0xB7, 0x6B, 0x00,
	0x3F, 0x3F, 0x3F, 0x82, 0x15, 0x3F, 0x3F, 0x3F, 0x82, 0x00, 0x3F, 0x6B, 0x00,
	0x3F, 0x3F, 0x6B, 0x00, 0x15, 0x3F, 0x3F, 0x3F, 0x82, 0x00, 0x3F, 0x6B, 0x00};


const u8 kMoveText[64] = {
    0xAA, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x00,
	0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0x00,
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0x00,
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x00,
	0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0xAA, 0xAA, 0xFF, 0xAA, 0x55, 0x00, 0xFF, 0xAA};


const u8 kJumpText[64] = {
	0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA,
	0x00, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0x00, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA,
	0x00, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA,
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA,
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0x00,
	0xFF, 0xAA, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0x00};


const u8 kLeftIcon[64] = {
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xAA, 0xFF, 0xFF,
	0xFF, 0xAA, 0xFF, 0xFF,
	0xFF, 0x00, 0xFF, 0xFF,
	0xFF, 0x00, 0x00, 0x55,
	0xAA, 0x00, 0x00, 0x55,
	0xAA, 0x00, 0x00, 0x55,
	0xFF, 0x00, 0x00, 0x55,
	0xFF, 0x00, 0xFF, 0xFF,
	0xFF, 0xAA, 0xFF, 0xFF,
	0xFF, 0xAA, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF};


const u8 kRightIcon[64] = {
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0x55, 0xFF,
	0xFF, 0xFF, 0x55, 0xFF,
	0xFF, 0xFF, 0x00, 0xFF,
	0xAA, 0x00, 0x00, 0xFF,
	0xAA, 0x00, 0x00, 0x55,
	0xAA, 0x00, 0x00, 0x55,
	0xAA, 0x00, 0x00, 0xFF,
	0xFF, 0xFF, 0x00, 0xFF,
	0xFF, 0xFF, 0x55, 0xFF,
	0xFF, 0xFF, 0x55, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF};


const u8 kJumpIcon[192] = {
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA,
	0xFF, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0xAA,
	0xFF, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0xAA,
	0xFF, 0x55, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0x55, 0xFF, 0xAA,
	0xFF, 0x55, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0xFF, 0x00, 0xFF, 0xAA,
	0xFF, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x55, 0xFF, 0x00, 0xFF, 0xAA,
	0xFF, 0xFF, 0x55, 0x00, 0x55, 0x00, 0x55, 0x55, 0xFF, 0x55, 0xFF, 0xAA,
	0xFF, 0x00, 0x55, 0x55, 0xFF, 0x55, 0x55, 0x00, 0x55, 0x00, 0x55, 0xAA,
	0xFF, 0x00, 0x55, 0x55, 0xFF, 0x55, 0x55, 0x00, 0x55, 0x00, 0x55, 0xAA,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA,
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA};


const u8 kMusicText[80] = {
	0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x55, 0x00, 0xAA, 0x00,
	0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x55, 0x00, 0xAA, 0x00,
	0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xAA, 0x55, 0x00, 0xAA, 0x00,
	0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0xAA, 0x55, 0x00, 0xAA, 0x00,
	0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA};


const u8 kMusicIcon[64] = {
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xAA, 0x55, 0xAA, 0x55,
	0xAA, 0x55, 0xAA, 0x55,
	0xAA, 0x00, 0x00, 0x55,
	0xAA, 0xAA, 0x55, 0x55,
	0xAA, 0xAA, 0x55, 0x55,
	0xAA, 0xFF, 0xFF, 0x55,
	0xAA, 0xFF, 0xFF, 0x55,
	0xAA, 0xFF, 0xFF, 0x55,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF};


const u8 kPressSpaceText[176] = {
    0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00, 0xFF, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00, 0xFF, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0x00, 0x00, 0xAA, 0x00, 0xAA, 0xAA,
	0xAA, 0xAA, 0xAA, 0x00, 0xAA, 0x00,
	0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0x00, 0x00, 0xAA, 0x00, 0xAA, 0xAA,
	0xAA, 0xAA, 0xAA, 0x00, 0xFF, 0x00,
	0xFF, 0xAA, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00, 0xFF, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xAA, 0x00, 0xFF, 0x00,
	0xFF, 0xAA, 0xFF, 0xAA, 0xAA, 0x00, 0x00, 0xAA, 0x00, 0xAA, 0x00, 0x00, 0x00, 0xAA, 0xFF, 0xAA,
	0xFF, 0xAA, 0xAA, 0x00, 0xAA, 0x00,
	0xAA, 0x00, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00, 0xFF, 0xAA, 0xAA, 0x00,
	0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA,
	0xAA, 0x00, 0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA, 0x00, 0x00, 0xFF, 0xAA, 0xAA, 0x00,
	0xAA, 0xAA, 0xFF, 0xAA, 0xFF, 0xAA};


const u8 kMapsText[72] = {
	0x55, 0x55, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x00,
	0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55,
	0x55, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x55,
	0x55, 0xFF, 0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00,
	0x55, 0x55, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x00,
	0x55, 0x55, 0x55, 0xFF, 0x55, 0xFF, 0x00, 0x55, 0x55,
	0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x55, 0xFF, 0x55,
	0x55, 0x55, 0x55, 0x55, 0x55, 0x00, 0x55, 0xFF, 0x00};


const u8 kDefeatsText[120] = {
	0x55, 0xAA, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x00,
	0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55,
	0x55, 0x55, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x55, 0x00, 0xAA, 0x55, 0x00, 0x55,
	0x55, 0x55, 0x55, 0xAA, 0x55, 0x00, 0x55, 0xAA, 0x55, 0x55, 0x00, 0xAA, 0x55, 0x00, 0x00,
	0x55, 0x55, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xFF, 0x00, 0xAA, 0x55, 0xFF, 0x00,
	0x55, 0x55, 0x55, 0x00, 0x55, 0xAA, 0x55, 0x00, 0x55, 0xFF, 0x00, 0xAA, 0x00, 0x55, 0x55,
	0x55, 0xFF, 0x55, 0xFF, 0x55, 0x00, 0x55, 0xFF, 0x55, 0x55, 0x00, 0xAA, 0x55, 0xFF, 0x55,
	0x55, 0xAA, 0x55, 0xFF, 0x55, 0x00, 0x55, 0xFF, 0x55, 0x55, 0x00, 0xAA, 0x55, 0xFF, 0x00};


const u8 kTimeText[72] = {
	0x55, 0xFF, 0x55, 0xFF, 0x55, 0x55, 0x55, 0xFF, 0x00,
	0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55, 0xFF, 0x55,
	0x00, 0xAA, 0x00, 0xAA, 0x55, 0xFF, 0x55, 0x00, 0x55,
	0x00, 0xAA, 0x00, 0xAA, 0x55, 0xFF, 0x55, 0xAA, 0x00,
	0x00, 0xAA, 0x00, 0xAA, 0x55, 0x55, 0x55, 0xAA, 0x00,
	0x00, 0xAA, 0x00, 0xAA, 0x55, 0x55, 0x55, 0x00, 0x55,
	0x00, 0xAA, 0x55, 0xFF, 0x55, 0x55, 0x55, 0xFF, 0x55,
	0x00, 0xAA, 0x55, 0xFF, 0x55, 0x55, 0x55, 0xFF, 0x00};

const u8 kOfText[32] = {
	0x55, 0xFF, 0x55, 0xFF,
	0x55, 0xFF, 0x55, 0xFF,
	0x55, 0x55, 0x55, 0x00,
	0x55, 0x55, 0x55, 0x00,
	0x55, 0x55, 0x55, 0xAA,
	0x55, 0x55, 0x55, 0xAA,
	0x55, 0xFF, 0x55, 0x00,
	0x55, 0xFF, 0x55, 0x00};
