//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "menu.h"

#include <cpctelera.h>
#include "../globals.h"
#include "../art/sprites.h"
#include "../entity/entities.h"
#include "../audio/audio.h"
#include "../util/util.h"

TEntity playerDemo;
u8 musicIsOn;

void InitializeMenu() {
	u8 *pscr;

    cpct_clearScreen_f64(0);

    // Horizontal lines.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 0, 0);
    cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_RED, COLOR_RED), 40, 2);
    cpct_drawSolidBox(pscr + 40, cpct_px2byteM0(COLOR_RED, COLOR_RED), 40, 2);
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 0, SCR_HEIGHT - 2);
    cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_RED, COLOR_RED), 40, 2);
    cpct_drawSolidBox(pscr + 40, cpct_px2byteM0(COLOR_RED, COLOR_RED), 40, 2);

    // Vertical lines.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 0, 1);
    cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_RED, COLOR_RED), 1, SCR_HEIGHT - 2);
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, SCR_WIDTH - 1, 1);
    cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_RED, COLOR_RED), 1, SCR_HEIGHT - 2);

    // Title
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 22, 32);
    cpct_drawSprite(kTitleHair, pscr, 18, 24);
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 44, 32);
    cpct_drawSprite(kTitleBoy, pscr, 13, 24);

	// Tutorial
	pscr = cpct_getScreenPtr(CPCT_VMEM_START, 22, 100);
	cpct_drawSprite(kJumpText, pscr, 8, 8);
	pscr = cpct_getScreenPtr(CPCT_VMEM_START, 20, 112);
	cpct_drawSprite(kJumpIcon, pscr, 12, TILE_HEIGHT);

	pscr = cpct_getScreenPtr(CPCT_VMEM_START, 50, 100);
	cpct_drawSprite(kMoveText, pscr, 8, 8);
	pscr = cpct_getScreenPtr(CPCT_VMEM_START, 47, 112);
	cpct_drawSprite(kLeftIcon, pscr, TILE_WIDTH, TILE_HEIGHT);
	pscr = cpct_getScreenPtr(CPCT_VMEM_START, 56, 112);
	cpct_drawSprite(kRightIcon, pscr, TILE_WIDTH, TILE_HEIGHT);

	pscr = cpct_getScreenPtr(CPCT_VMEM_START, 35, 100);
	cpct_drawSprite(kMusicText, pscr, 10, 8);
	pscr = cpct_getScreenPtr(CPCT_VMEM_START, 38, 112);
	cpct_drawSprite(kMusicIcon, pscr, TILE_WIDTH, TILE_HEIGHT);
	
	// Press Space.
	pscr = cpct_getScreenPtr(CPCT_VMEM_START, 29, SCR_HEIGHT - 50);
	cpct_drawSprite(kPressSpaceText, pscr, 22, 8);

    // Developed by text.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 28, SCR_HEIGHT - 20);
    cpct_drawSprite(kAuthorText, pscr, 24, 8);

	// Player Demo.
	playerDemo.x = 38;
	playerDemo.y = 70;
	playerDemo.prevX = playerDemo.x;
	playerDemo.prevY = playerDemo.y;
	playerDemo.right = playerDemo.x + TILE_WIDTH;
	playerDemo.bottom = playerDemo.y + TILE_HEIGHT;
	SetAnimationFrame(&playerDemo, kPlayerIdleRight, 1);

	cpct_waitVSYNC();
}

void MenuLoop() {
	u8 ticks = 0;
	u8 drawPressSpace = 0;
	u8 *pscr;

    while (1) {
        cpct_scanKeyboard_f();

        if (cpct_isKeyPressed(Key_Space)) {
			WaitKeyUp(Key_Space);
            break;
        } else if (cpct_isKeyPressed(Key_CursorLeft)) {
            SetAnimationFrame(&playerDemo, kPlayerIdleLeft, 1);
        } else if (cpct_isKeyPressed(Key_CursorRight)) {
            SetAnimationFrame(&playerDemo, kPlayerIdleRight, 1);
        } else if (cpct_isKeyPressed(Key_M)) {
			WaitKeyUp(Key_M);

			if (musicIsOn) {
				cpct_akp_musicInit(kSfx);
			} else {
				cpct_akp_musicInit(kMusic);
			}

			musicIsOn = !musicIsOn;
        }

		cpct_waitVSYNC();

		if ((ticks & 31) == 0) {
			if (drawPressSpace) {
				pscr = cpct_getScreenPtr(CPCT_VMEM_START, 29, SCR_HEIGHT - 50);
				cpct_drawSprite(kPressSpaceText, pscr, 22, 8);

				drawPressSpace = 0;
			} else {
				pscr = cpct_getScreenPtr(CPCT_VMEM_START, 29, SCR_HEIGHT - 50);
				cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_BLACK, COLOR_BLACK), 22, 8);

				drawPressSpace = 1;
			}
		}

		DrawEntity(&playerDemo);

        ticks++;
    }
}
