//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Dynamic;
using Framefield.Core.OperatorPartTraits;

namespace Framefield.Core.IDd5769b1d_fe58_4c2f_81f1_25451b9cbf1c
{
    public class Class_OverrideCamera : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            Camera = 1
        }
        //<<< _inputids
        //>>> _outputids
        private enum OutputId
        {
            Output = 0,
            Camera = 1
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params_OFF
            var SceneInput = inputs[(int)InputId.SceneInput];
            var cameraInput = inputs[(int)InputId.Camera];  // Needs to be checked for null!
            //<<< _params_OFF



            var prevTransform = context.WorldToCamera;
            var prevCamProj = context.CameraProjection;

            if (cameraInput != null)
            {
            
                try {
                    var dynamicResult = cameraInput.Eval(context).Dynamic;  // Needs to be checked for null!

                    var cam = dynamicResult.This as ICameraProvider;
                    if(cam != null) {

                        context.WorldToCamera = cam.GetLastWorldToCamera();
                        context.CameraProjection = cam.GetLastCameraToView();
                    }
                }
                catch (Exception e) {
                }
            }
            
            /*
            switch (outputIdx)
            {
                case (int)OutputId.Output:
                    SceneInput.Eval(context);
                    break;
                case (int)OutputId.This:
                    dynamic obj = new ExpandoObject();
                    obj.This = this;
                    context.Dynamic = obj;
                    break;
            }*/            

            SceneInput.Eval(context);

            context.CameraProjection = prevCamProj;
            context.WorldToCamera = prevTransform;

            return context;
        }
    }
}

