//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.Rendering;

using Buffer = SharpDX.Direct3D11.Buffer;

namespace Framefield.Core.ID4b030b99_246c_443b_972e_4b9200c29848
{
    public class Class_PhongShader : FXSourceCodeFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Scene = 1
        }
        //<<< _inputids

        #region Renderer
        public class Renderer : BaseRenderer
        {
            public override void Dispose()
            {
                Utilities.DisposeObj(ref _pointLightsBuffer);
                Utilities.DisposeObj(ref _pointLightsSRV);
                base.Dispose();
            }
        
            public override void SetupEffect(OperatorPartContext context)
            {
                base.SetupEffect(context);
                try
                {
                    SetupMaterialConstBuffer(context);
                    SetupFogSettingsConstBuffer(context);
                    SetupPointLightsStructuredBufferForEffect(context, "pointLights", ref _pointLightsBuffer, ref _pointLightsSRV);
                }
                catch (Exception e)
                {
                    Logger.Error(ParentFunc, "Error building constant buffer: {0} - Source: {1}", e.Message, e.Source);
                }
            }
            public OperatorPart.Function ParentFunc {get;set;}

            Buffer _pointLightsBuffer;
            ShaderResourceView _pointLightsSRV;
        }
        #endregion

        public Class_PhongShader()
        {
            _renderer = new Renderer(){ParentFunc = this};
        }

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _renderer);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Scene = inputs[(int)InputId.Scene];
            //<<< _params
           
            if (_effect == null)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                Changed = true;
            }

            var prevEffect = context.Effect;
            var prevRenderer = context.Renderer;
            
            context.Effect = _effect;
            context.Renderer = _renderer;

            Scene.Eval(context);

            context.Effect = prevEffect;
            context.Renderer = prevRenderer;

            return context;
        }

        Renderer _renderer;
    }
}


