//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDb93b955f_4ebb_4448_9bcd_8d49f68892e9
{
    public class Class_ToNormalMap : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Image = 0,
            Scale = 1,
            ComputeOcclusion = 2
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _normalMap);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            if (Changed)
            {
                //>>> _params
                var Image = inputs[(int)InputId.Image].Eval(context).Image; // Needs to be checked for null!
                var Scale = inputs[(int)InputId.Scale].Eval(context).Value;
                var ComputeOcclusion = (int) inputs[(int)InputId.ComputeOcclusion].Eval(context).Value;
                //<<< _params

                Dispose();
                NormalMapFlags flags = (NormalMapFlags) ComputeOcclusion;
                _normalMap = new Texture2D(context.D3DDevice, Image.Description);
                Texture2D.ComputeNormalMap(context.D3DDevice.ImmediateContext, Image, _normalMap, flags | NormalMapFlags.Mirror, Channel.Red, Scale);
                Changed = false;
            }
            context.Image = _normalMap;

            return context;
        }

        Texture2D _normalMap = null;
    }
}

