//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core.OperatorPartTraits;
using Framefield.Core.Rendering;
using Buffer = SharpDX.Direct3D11.Buffer;
using SharpDX.Direct3D;

namespace Framefield.Core.ID425d251b_f7ba_451f_8454_889d3595ce8b
{
    public class Class_UVDisplaceMesh : FXSourceCodeFunction, IFXSceneSourceCode
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            CenterX = 1,
            CenterY = 2,
            CenterZ = 3,
            NoiseAmount = 4,
            NoiseScale = 5,
            NoiseTexture = 6,
            NoiseAmountXYZWidth = 7,
            NoiseAmountXYZHeight = 8,
            NoiseAmountXYZDepth = 9,
            Mesh = 10,
            Facetize = 11,
            ScaleNormals = 12
        }
        //<<< _inputids

        public Class_UVDisplaceMesh()
        {
        }

        public override void Dispose() 
        {
            Utilities.DisposeObj(ref _mesh);
            base.Dispose();
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            try
            {
                UpdateMesh(context, inputs);
                context.Mesh = _mesh;
            }
            catch (Exception exception)
            {
                Logger.Error(this, "Load Effect error: {0}", exception.Message);
            }

            return context;
        }

        bool _firstEval = true;
        private void UpdateMesh(OperatorPartContext context, List<OperatorPart> inputs)
        {
            if (_firstEval)
            {
                for (int i = 0; i < NumCodes(); ++i)
                    Compile(i);
                _firstEval = false;
                Changed = true;
            }

            if (!Changed && _mesh.Vertices != null)
                return;

            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var CenterZ = inputs[(int)InputId.CenterZ].Eval(context).Value;
            var Center = new Vector3(CenterX, CenterY, CenterZ);
            var NoiseAmount = inputs[(int)InputId.NoiseAmount].Eval(context).Value;
            var NoiseScale = inputs[(int)InputId.NoiseScale].Eval(context).Value;
            var NoiseTexture = inputs[(int)InputId.NoiseTexture].Eval(context).Image; // Needs to be checked for null!
            var NoiseAmountXYZWidth = inputs[(int)InputId.NoiseAmountXYZWidth].Eval(context).Value;
            var NoiseAmountXYZHeight = inputs[(int)InputId.NoiseAmountXYZHeight].Eval(context).Value;
            var NoiseAmountXYZDepth = inputs[(int)InputId.NoiseAmountXYZDepth].Eval(context).Value;
            var NoiseAmountXYZ = new Vector3(NoiseAmountXYZWidth, NoiseAmountXYZHeight, NoiseAmountXYZDepth);
            var Mesh = inputs[(int)InputId.Mesh].Eval(context).Mesh;
            var Facetize = inputs[(int)InputId.Facetize].Eval(context).Value;
            var ScaleNormals = inputs[(int)InputId.ScaleNormals].Eval(context).Value;
            //<<< _params

            if (NoiseTexture == null)
                return;
            
            //Logger.Info(this, "collect meshes");
//            Scene.Func.Changed = false;

            if (Mesh == null)
                return;

            _mesh.AttributesSize = Mesh.AttributesSize;
            _mesh.NumTriangles = Mesh.NumTriangles;
            _mesh.InputElements = Mesh.InputElements;
            if (_mesh.Vertices == null || _mesh.Vertices.Description.SizeInBytes != Mesh.Vertices.Description.SizeInBytes)
            {
                if (_mesh.Vertices != null)
                    _mesh.Vertices.Dispose();

                _mesh.Vertices = new Buffer(D3DDevice.Device, new BufferDescription()
                                                                    {
                                                                        BindFlags = BindFlags.StreamOutput | BindFlags.VertexBuffer,
                                                                        CpuAccessFlags = CpuAccessFlags.None,
                                                                        OptionFlags = ResourceOptionFlags.None,
                                                                        SizeInBytes = _mesh.NumTriangles*Mesh.AttributesSize*3,
                                                                        Usage = ResourceUsage.Default
                                                                    });
            }
            
            //var textureView = new ShaderResourceView(D3DDevice, NoiseTexture);
            var noiseTextureView = new ShaderResourceView(context.D3DDevice, NoiseTexture);
            _effect.GetVariableByName("NoiseTexture").AsShaderResource().SetResource(noiseTextureView);

            
            _effect.GetVariableByName("Facetize").AsScalar().Set(Facetize);
            _effect.GetVariableByName("Center").AsVector().Set(new Vector3(CenterX, CenterY, CenterZ));
            _effect.GetVariableByName("NoiseAmount").AsScalar().Set(NoiseAmount);
            _effect.GetVariableByName("NoiseScale").AsScalar().Set(NoiseScale);
            _effect.GetVariableByName("ScaleNormals").AsScalar().Set(ScaleNormals);   
            _effect.GetVariableByName("NoiseAmountXYZ").AsVector().Set(new Vector3(NoiseAmountXYZ.X, NoiseAmountXYZ.Y, NoiseAmountXYZ.Z));

            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(_mesh.Vertices, 0) });
            context.D3DDevice.ImmediateContext.OutputMerger.DepthStencilState = new DepthStencilState(context.D3DDevice,
                                                                                                        new DepthStencilStateDescription()
                                                                                                            {
                                                                                                                IsDepthEnabled = false,
                                                                                                                IsStencilEnabled = false
                                                                                                            });
            context.D3DDevice.ImmediateContext.InputAssembler.InputLayout = context.InputLayout;
            context.D3DDevice.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.TriangleList;
            context.D3DDevice.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(Mesh.Vertices, Mesh.AttributesSize, 0));
            var technique = _effect.GetTechniqueByIndex(0);
            technique.GetPassByIndex(0).Apply(context.D3DDevice.ImmediateContext);
            context.D3DDevice.ImmediateContext.Draw(_mesh.NumTriangles*3, 0);
            context.D3DDevice.ImmediateContext.StreamOutput.SetTargets(new [] { new StreamOutputBufferBinding(null, 0) });

            Changed = false;
        }

        private Mesh _mesh = new Mesh();
    }
}


