/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

public class Reverb
implements SoundObject {
    PApplet parent;
    private Engine m_engine;
    private int[] m_nodeId = new int[]{-1, -1};
    private float m_room = 1.0f;
    private float m_damp = 0.0f;
    private float m_wet = 0.5f;

    public Reverb(PApplet pApplet) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        Engine.setPreferences(pApplet, 512, 44100);
        Reverb reverb = this;
        reverb.m_engine.start();
    }

    public void process(SoundObject soundObject, float f, float f2, float f3) {
        this.m_room = f;
        this.m_damp = f2;
        this.m_wet = f3;
        this.m_nodeId = Engine.reverbPlay(soundObject.returnId(), this.m_room, this.m_damp, this.m_wet);
    }

    public void process(SoundObject soundObject, float f, float f2) {
        this.m_room = f;
        this.m_damp = f2;
        this.m_nodeId = Engine.reverbPlay(soundObject.returnId(), this.m_room, this.m_damp, this.m_wet);
    }

    public void process(SoundObject soundObject, float f) {
        this.m_room = f;
        this.m_nodeId = Engine.reverbPlay(soundObject.returnId(), this.m_room, this.m_damp, this.m_wet);
    }

    public void process(SoundObject soundObject) {
        this.m_nodeId = Engine.reverbPlay(soundObject.returnId(), this.m_room, this.m_damp, this.m_wet);
    }

    private void set() {
        if (this.m_nodeId[0] != -1) {
            Engine.reverbSet(this.m_room, this.m_damp, this.m_wet, this.m_nodeId[0]);
        }
    }

    public void set(float f, float f2, float f3) {
        this.m_room = f;
        this.m_damp = f2;
        this.m_wet = f3;
        this.set();
    }

    public void room(float f) {
        this.m_room = f;
        this.set();
    }

    public void damp(float f) {
        this.m_damp = f;
        this.set();
    }

    public void wet(float f) {
        this.m_wet = f;
        this.set();
    }

    @Override
    public int[] returnId() {
        return this.m_nodeId;
    }

    public void stop() {
        if (this.m_nodeId[0] != -1) {
            Engine.synthStop(this.m_nodeId);
            for (int i = 0; i < this.m_nodeId.length; ++i) {
                this.m_nodeId[i] = -1;
            }
        }
    }

    public void dispose() {
        Engine.synthStop(this.m_nodeId);
    }
}

