// Check the configuration file for more details
var config = require('./config');

var express = require('express');
var app = require('express')();
var server = require('http').Server(app);

var io = require('socket.io')(server);

console.log("Trying to start server with config:", config.serverip + ":" + config.serverport);

server.listen(config.serverport, config.serverip, function () {
  console.log("Server running @ http://" + config.serverip + ":" + config.serverport);
});

// Allow some files to be server over HTTP
app.use(express.static(__dirname + '/'));

// Serve GET on http://domain/
app.get('/', function (req, res) {
  res.sendFile(__dirname + '/index.html');
});
app.get('/gun', function (req, res) {
  res.sendFile(__dirname + '/gun.html');
});
app.get('/gun2', function (req, res) {
  res.sendFile(__dirname + '/gun2.html');
});
app.get('/target', function (req, res) {
  res.sendFile(__dirname + '/index.html');
});

// Server GET on http://domain/api/config
// A hack to provide client the system config
app.get('/api/config', function (req, res) {
  res.send('var config = ' + JSON.stringify(config));
});

// And finally some websocket stuff
io.on('connection', function (socket) { // Incoming connections from clients
  // Greet the newcomer
  socket.emit('hello', { greeting: 'Hi socket ' + socket.id + ' this is Server speaking! Let\'s play ping-pong. You pass!' });

  socket.on('ping', function (data) { // ping-event from the client to be respond with pong
    console.log("received ping from client: ", data);
    socket.emit('pong', { id: data.id });
  });
  socket.on('conexion', function (data) {
    io.emit('conexion', data);
  });

  socket.on('caliberright', function (data) {
    io.emit('caliberright', data);
  });

  socket.on('caliberleft', function (data) {
    io.emit('caliberleft', data);
  });

  socket.on('nota', function (data) {
    io.emit('nota', data);
  });
  socket.on('nota2', function (msg) {
    io.emit('nota2', msg);
  });
});
