cbuffer cbPerObject :register(b0)
{
    matrix WVP;
		matrix WorldMatrix;
		float4 MaterialDiffuseColor;
		float4 MaterialAmbientColor;
		float4 MaterialSpecularColor;
		float fMaterialSelfIllumination;
		float fMaterialShininess;
		float _padding_00;
		float _padding_01;
		float4 WorldCameraPosition;
};


struct VOut
{
    float4 position : SV_POSITION;
    //float3 unprocessed_pos : TEXCOORD;
	float4 normal : NORMAL;
	float4 worldPosition: TEXCOORD;
    float2 texcoord : COLOR;
};

//TODO: rajonni miert nem muxik a float4 position
struct VertexIn
{
    float3 position : POSITION;
    float3 normal : NORMAL;
    float3 tangent : TANGENT;
    float3 bitangent : BITANGENT;
    float2 texcoord : TEXCOORD;
};

VOut main(VertexIn vin)
{
    VOut output;

    output.position = mul(WVP, float4(vin.position, 1)); // transform the vertex from 3D to 2D
    //output.unprocessed_pos = vin.position.xyz;
    output.texcoord = vin.texcoord;

	output.worldPosition = mul(WorldMatrix, float4(vin.position, 1));
	output.normal = mul(WorldMatrix, float4(vin.normal, 0.0));

    return output;
}
