SamplerState sm:register(s1); // linear sampler
Texture2D input_blur:register(t0); // buffer after 2x blur passes
Texture2D input:register(t1); // original scene

cbuffer c : register(b1)
{
	float smooth; // 0.0 -> box filter, > 0.0 for gaussian
	float size; // length of the blur (global)
	float samplesx; // number of samples to take
	float directionx; // direction of blur
	float powerx; // length of the blur
	float samplesy; // number of samples to take
	float directiony; // direction of blur
	float powery; // length of the blur
	float blur_intensity; // how much of blur to mix
	float scene_intensity; // how much of scene to mix
}

float4 main(float4 PositionSS : SV_Position, float2 t : TEXCOORD) : SV_TARGET0
{
	float4 b = input_blur.Sample(sm,t);
	float4 s = input.Sample(sm,t);
	b *= blur_intensity;
	s *= scene_intensity;
	return b + s;
}